/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

import de.jreality.backends.texture.Texture;
import de.jreality.softviewer.ArrayStack;
import de.jreality.softviewer.Triangle;

public abstract class AbstractPolygon {
    public static final int WX = 0;
    public static final int WY = 1;
    public static final int WZ = 2;
    public static final int WW = 3;
    public static final int SX = 4;
    public static final int SY = 5;
    public static final int SZ = 6;
    public static final int SW = 7;
    public static final int R = 8;
    public static final int G = 9;
    public static final int B = 10;
    public static final int A = 11;
    public static final int U = 12;
    public static final int V = 13;
    public static final int NX = 14;
    public static final int NY = 15;
    public static final int NZ = 16;
    public static final int VERTEX_LENGTH = 17;
    private double[] center = new double[17];
    private double transparency;
    private Texture texture;
    private boolean interpolateColor;
    private boolean interpolateAlpha;
    private boolean isSkybox;

    public double[] getCenter() {
        return this.center;
    }

    public final Triangle[] triangulate(Triangle[] ta, ArrayStack stack) {
        int length = this.getLength() - 2;
        if (length <= 0) {
            return ta == null ? new Triangle[]{} : ta;
        }
        if (ta == null || ta.length < length) {
            ta = new Triangle[length];
        }
        double[] start = this.getPoint(length + 1);
        double[] next = this.getPoint(0);
        for (int i = 0; i < length; ++i) {
            Triangle t = stack.pop();
            t.setShadingFrom(this);
            ta[i] = t;
            t.setPointFrom(0, start);
            t.setPointFrom(1, next);
            next = this.getPoint(i + 1);
            t.setPointFrom(2, next);
        }
        return ta;
    }

    public final void setTransparency(double t) {
        this.transparency = t;
    }

    public final double getTransparency() {
        return this.transparency;
    }

    public final Texture getTexture() {
        return this.texture;
    }

    public final void setTexture(Texture texture) {
        this.texture = texture;
    }

    public boolean isInterpolateColor() {
        return this.interpolateColor;
    }

    public void setInterpolateColor(boolean interpolateColor) {
        this.interpolateColor = interpolateColor;
    }

    public boolean isInterpolateAlpha() {
        return this.interpolateAlpha;
    }

    public void setInterpolateAlpha(boolean interpolateAlpha) {
        this.interpolateAlpha = interpolateAlpha;
    }

    public void setShadingFrom(AbstractPolygon p) {
        this.setInterpolateAlpha(p.isInterpolateAlpha());
        this.setInterpolateColor(p.isInterpolateColor());
        this.setTransparency(p.getTransparency());
        this.setTexture(p.getTexture());
        this.setSkybox(p.isSkybox());
        this.setCenterFrom(p.getCenter());
    }

    public abstract double[] getPoint(int var1);

    public abstract int getLength();

    public void setPointFrom(int i, double[] data) {
        System.arraycopy(data, 0, this.getPoint(i), 0, 17);
    }

    public void setCenterFrom(double[] data) {
        System.arraycopy(data, 0, this.getCenter(), 0, 17);
    }

    public boolean isSkybox() {
        return this.isSkybox;
    }

    public void setSkybox(boolean isSkybox) {
        this.isSkybox = isSkybox;
    }
}

