/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.math.Matrix;
import de.jreality.shader.ImageData;
import de.jreality.shader.Texture2D;
import de.jreality.soft.Texture;

public class SimpleTexture
implements Texture {
    protected final byte[] bytes;
    protected final int width;
    protected final int height;
    protected final double[] matrix;
    protected final boolean clampU;
    protected final boolean clampV;
    protected final int incr;
    protected final boolean interpolate;
    private static final double[] identity = new Matrix().getArray();

    public SimpleTexture(ImageData id) {
        this.bytes = id.getByteArray();
        this.width = id.getWidth();
        this.height = id.getHeight();
        this.matrix = identity;
        this.clampU = true;
        this.clampV = true;
        this.interpolate = true;
        this.incr = 3 * this.width * this.height == this.bytes.length ? 3 : 4;
    }

    public SimpleTexture(Texture2D texture) {
        this.bytes = texture.getImage().getByteArray();
        this.width = texture.getImage().getWidth();
        this.height = texture.getImage().getHeight();
        this.matrix = texture.getTextureMatrix().getArray();
        this.clampU = texture.getRepeatS() == 10496;
        this.clampV = texture.getRepeatT() == 10496;
        this.incr = 3 * this.width * this.height == this.bytes.length ? 3 : 4;
        this.interpolate = texture.getMinFilter() == 9729;
    }

    public void getColor(double u, double v, int x, int y, int[] color) {
        if (this.interpolate) {
            this.getPixelInterpolate(u, v, color);
        } else {
            this.getPixelNearest(u, v, color);
        }
    }

    protected final void getPixelNearest(double uu, double vv, int[] color) {
        int b;
        int a;
        double u = (double)this.width * (uu * this.matrix[0] + vv * this.matrix[1] + this.matrix[3]);
        double v = (double)this.height * (uu * this.matrix[4] + vv * this.matrix[5] + this.matrix[7]);
        u = u < 0.0 ? u - Math.floor(u / (double)this.width) : u;
        double d = v = v < 0.0 ? v - Math.floor(v / (double)this.height) : v;
        a = this.clampU ? ((a = (int)u) < 0 ? 0 : (a >= this.width ? this.width - 1 : a)) : (int)u % this.width;
        b = this.clampV ? ((b = (int)v) < 0 ? b : (b >= this.height ? this.height - 1 : b)) : (int)v % this.height;
        int pos = this.incr * (a + this.width * b);
        color[0] = color[0] * (0xFF & this.bytes[pos + 0]);
        color[1] = color[1] * (0xFF & this.bytes[pos + 1]);
        color[2] = color[2] * (0xFF & this.bytes[pos + 2]);
        color[3] = this.incr == 4 ? color[3] * (0xFF & this.bytes[pos + 3]) : color[3] * 255;
    }

    protected final void getPixelInterpolate(double uu, double vv, int[] color) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        double a = 0.0;
        double u = (double)this.width * (uu * this.matrix[0] + vv * this.matrix[1] + this.matrix[3]);
        double v = (double)this.height * (uu * this.matrix[4] + vv * this.matrix[5] + this.matrix[7]);
        u = u < 0.0 ? u - Math.floor(u / (double)this.width) : u;
        v = v < 0.0 ? v - Math.floor(v / (double)this.height) : v;
        double dam = u;
        int am = (int)dam;
        dam = 1.0 - (dam - (double)am);
        double dap = u + 1.0;
        int ap = (int)dap;
        dap = 1.0 - dam;
        if (this.clampU) {
            int n = am < 0 ? am : (am = am >= this.width ? this.width - 1 : am);
            ap = ap < 0 ? ap : (ap >= this.width ? this.width - 1 : ap);
        } else {
            am %= this.width;
            ap %= this.width;
        }
        double dbm = v;
        int bm = (int)dbm;
        dbm = 1.0 - (dbm - (double)bm);
        double dbp = v + 1.0;
        int bp = (int)dbp;
        dbp = 1.0 - dbm;
        if (this.clampV) {
            int n = bm < 0 ? bm : (bm = bm >= this.height ? this.height - 1 : bm);
            bp = bp < 0 ? bp : (bp >= this.height ? this.height - 1 : bp);
        } else {
            bm %= this.height;
            bp %= this.height;
        }
        int pos = this.incr * (am + this.width * bm);
        double fac = dam * dbm;
        r += fac * (double)(0xFF & this.bytes[pos + 0]);
        g += fac * (double)(0xFF & this.bytes[pos + 1]);
        b += fac * (double)(0xFF & this.bytes[pos + 2]);
        if (this.incr == 4) {
            a += fac * (double)(0xFF & this.bytes[pos + 3]);
        }
        pos = this.incr * (ap + this.width * bm);
        fac = dap * dbm;
        r += fac * (double)(0xFF & this.bytes[pos + 0]);
        g += fac * (double)(0xFF & this.bytes[pos + 1]);
        b += fac * (double)(0xFF & this.bytes[pos + 2]);
        if (this.incr == 4) {
            a += fac * (double)(0xFF & this.bytes[pos + 3]);
        }
        pos = this.incr * (ap + this.width * bp);
        fac = dap * dbp;
        r += fac * (double)(0xFF & this.bytes[pos + 0]);
        g += fac * (double)(0xFF & this.bytes[pos + 1]);
        b += fac * (double)(0xFF & this.bytes[pos + 2]);
        if (this.incr == 4) {
            a += fac * (double)(0xFF & this.bytes[pos + 3]);
        }
        pos = this.incr * (am + this.width * bp);
        fac = dam * dbp;
        r += fac * (double)(0xFF & this.bytes[pos + 0]);
        g += fac * (double)(0xFF & this.bytes[pos + 1]);
        b += fac * (double)(0xFF & this.bytes[pos + 2]);
        if (this.incr == 4) {
            a += fac * (double)(0xFF & this.bytes[pos + 3]);
        }
        color[0] = color[0] * (0xFF & (int)r);
        color[1] = color[1] * (0xFF & (int)g);
        color[2] = color[2] * (0xFF & (int)b);
        color[3] = this.incr == 4 ? color[3] * (0xFF & (int)a) : color[3] * 255;
    }
}

