/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.soft.DefaultPolygonShader;
import de.jreality.soft.DefaultVertexShader;
import de.jreality.soft.LineShader;
import de.jreality.soft.PointShader;
import de.jreality.soft.PolygonShader;
import de.jreality.soft.VertexShader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShaderLookup {
    private ShaderLookup() {
    }

    public static PolygonShader lookupPolygonShader(String name) {
        return (PolygonShader)ShaderLookup.lookup1(name, "Polygon");
    }

    public static VertexShader lookupVertexShader(String name) {
        try {
            return (VertexShader)ShaderLookup.lookup1(name, "Vertex");
        }
        catch (Exception e) {
            return new DefaultVertexShader();
        }
    }

    public static LineShader lookupLineShader(String name) {
        return (LineShader)ShaderLookup.lookup1(name, "Line");
    }

    public static PointShader lookupPointShader(String name) {
        return (PointShader)ShaderLookup.lookup1(name, "Point");
    }

    private static Object lookup1(String shaderName, String type) {
        Object ps;
        try {
            String clName = "de.jreality.soft." + Character.toUpperCase(shaderName.charAt(0)) + shaderName.substring(1) + type + "Shader";
            Logger.getLogger("de.jreality").log(Level.FINEST, "attempt to load {0}", clName);
            Class<?> cl = Class.forName(clName);
            Logger.getLogger("de.jreality").log(Level.FINEST, "loaded {0}", cl);
            ps = cl.newInstance();
            Logger.getLogger("de.jreality").log(Level.FINEST, "instantiated {0}", cl);
        }
        catch (ClassNotFoundException ex) {
            type = Character.toUpperCase(type.charAt(0)) + type.substring(1);
            Logger.getLogger("de.jreality").log(Level.WARNING, "unsupported {0} shader {1}", new String[]{type, shaderName});
            try {
                ps = Class.forName("de.jreality.soft.Default" + type + "Shader").newInstance();
            }
            catch (Exception e) {
                throw new Error();
            }
        }
        catch (Exception ex) {
            type = Character.toUpperCase(type.charAt(0)) + type.substring(1);
            Logger.getLogger("de.jreality").log(Level.WARNING, "{0} shader {1} failed {2}", new Object[]{type, shaderName, ex});
            ps = new DefaultPolygonShader();
        }
        return ps;
    }

    public static VertexShader getVertexShaderAttr(EffectiveAppearance eAppearance, String base, String attr) {
        String vShader = (String)eAppearance.getAttribute(ShaderUtility.nameSpace(base, attr), "default");
        String vShaderName = (String)eAppearance.getAttribute(ShaderUtility.nameSpace(base, attr + ".name"), ShaderUtility.nameSpace(base, attr));
        VertexShader vShaderImpl = ShaderLookup.lookupVertexShader(vShader);
        vShaderImpl.setup(eAppearance, vShaderName);
        return vShaderImpl;
    }

    public static PolygonShader getPolygonShaderAttr(EffectiveAppearance eAppearance, String base, String attr) {
        String vShader = (String)eAppearance.getAttribute(ShaderUtility.nameSpace(base, attr), "default");
        String vShaderName = (String)eAppearance.getAttribute(ShaderUtility.nameSpace(base, attr + ".name"), ShaderUtility.nameSpace(base, attr));
        PolygonShader vShaderImpl = ShaderLookup.lookupPolygonShader(vShader);
        vShaderImpl.setup(eAppearance, vShaderName);
        return vShaderImpl;
    }

    public static LineShader getLineShaderAttr(EffectiveAppearance eAppearance, String base, String attr) {
        String vShader = (String)eAppearance.getAttribute(ShaderUtility.nameSpace(base, attr), "default");
        String vShaderName = (String)eAppearance.getAttribute(ShaderUtility.nameSpace(base, attr + ".name"), ShaderUtility.nameSpace(base, attr));
        LineShader vShaderImpl = ShaderLookup.lookupLineShader(vShader);
        vShaderImpl.setup(eAppearance, vShaderName);
        return vShaderImpl;
    }

    public static PointShader getPointShaderAttr(EffectiveAppearance eAppearance, String base, String attr) {
        String vShader = (String)eAppearance.getAttribute(ShaderUtility.nameSpace(base, attr), "default");
        String vShaderName = (String)eAppearance.getAttribute(ShaderUtility.nameSpace(base, attr + ".name"), ShaderUtility.nameSpace(base, attr));
        PointShader vShaderImpl = ShaderLookup.lookupPointShader(vShader);
        vShaderImpl.setup(eAppearance, vShaderName);
        return vShaderImpl;
    }
}

