/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.math.Rn;
import de.jreality.scene.Geometry;
import de.jreality.scene.PointSet;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.StorageModel;
import de.jreality.soft.ClippingBox;
import de.jreality.soft.ClippingPlaneSoft;
import de.jreality.soft.DefaultPerspective;
import de.jreality.soft.Environment;
import de.jreality.soft.Intersector;
import de.jreality.soft.LineProcessor;
import de.jreality.soft.LineShader;
import de.jreality.soft.Perspective;
import de.jreality.soft.PointProcessor;
import de.jreality.soft.PointShader;
import de.jreality.soft.Polygon;
import de.jreality.soft.PolygonComparator;
import de.jreality.soft.PolygonProcessor;
import de.jreality.soft.PolygonRasterizer;
import de.jreality.soft.PolygonShader;
import de.jreality.soft.VecMat;
import java.util.Arrays;

public class PolygonPipeline
implements PolygonProcessor,
PointProcessor,
LineProcessor {
    private int vertexColorLength;
    private DataList vertexColor;
    private boolean vertexColors;
    private final boolean queueOpaque;
    private final boolean sortOpaque;
    private final boolean triangulate = false;
    private final boolean useTexCoords = true;
    private double[] matrix;
    private double[] inverseTransposeMatrix = new double[16];
    int polygonCount = 0;
    Polygon[] polygons = new Polygon[0];
    private int vertexCount = 0;
    double[] vertexData = new double[1300];
    PolygonComparator comp = new PolygonComparator();
    private Perspective perspective = new DefaultPerspective();
    private Environment environment;
    private PolygonShader faceShader;
    private LineShader lineShader;
    private PointShader pointShader;
    private PolygonShader shader;
    private double[] pointVertices = new double[48];
    private static int[] pointIndices = new int[]{0, 3, 6, 9, 12, 15, 18, 21};
    private static int[][] pointOutlineIndices = new int[][]{{0, 24, 27, 3}, {3, 27, 30, 6}, {6, 30, 33, 9}, {9, 33, 36, 12}, {12, 36, 39, 15}, {15, 39, 42, 18}, {18, 42, 45, 21}, {21, 45, 24, 0}};
    private static double[][] pointColors = new double[16][4];
    private DataList pointColorDataList = StorageModel.DOUBLE_ARRAY_ARRAY.createWritableDataList(pointColors);
    private static int[] pointNormals = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static int[][] pointOutlineNormals = new int[][]{{0, 3, 6, 0}, {0, 6, 9, 0}, {0, 9, 12, 0}, {0, 12, 15, 0}, {0, 15, 18, 0}, {0, 18, 21, 0}, {0, 21, 24, 0}, {0, 24, 3, 0}};
    private static double[] zNormal = new double[27];
    private static int[] lineIndices = new int[]{0, 3, 6, 9};
    private double pointRadius = 0.025;
    private double outlineFraction = 0.3333333333333333;
    private double lineWidth = 0.01;
    private final PolygonRasterizer renderer;
    private static final int POLYGON_INCR = 100;
    private static final int VERTEX_INCR = 1200;
    private double[] point0 = new double[4];
    private double[] normal0 = new double[3];
    private double[] point1 = new double[4];
    private double[] normal1 = new double[3];
    private double[] substMatrix = new double[16];
    private static final double[] identity = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    private double[] line = new double[12];
    private double[] direction = new double[3];
    private double[] normal2 = new double[6];
    private static int[] nIndices = new int[]{0, 3, 3, 0};
    private static final double cs = Math.cos(0.2);
    private static final double ss = Math.sin(0.2);
    private double[] test1 = new double[3];
    private double[] test2 = new double[3];
    private DoubleArray tda1 = new DoubleArray(this.test1);
    private DoubleArray tda2 = new DoubleArray(this.test2);
    private double[] test3 = new double[3];
    private double[] test4 = new double[3];
    private DoubleArray tda3 = new DoubleArray(this.test3);
    private DoubleArray tda4 = new DoubleArray(this.test4);
    private double[] zzNormal = new double[3];

    public PolygonPipeline(PolygonRasterizer renderer) {
        this(renderer, false);
    }

    public PolygonPipeline(PolygonRasterizer renderer, boolean sortAll) {
        this.sortOpaque = sortAll;
        this.queueOpaque = sortAll;
        this.renderer = renderer;
        PolygonPipeline.zNormal[0] = 0.0;
        PolygonPipeline.zNormal[1] = 0.0;
        PolygonPipeline.zNormal[2] = 1.0;
        for (int i = 0; i < 8; ++i) {
            int pos = 3 * i;
            double d = Math.cos(2.0 * (double)i * Math.PI / 8.0);
            PolygonPipeline.zNormal[pos + 3] = d;
            this.pointVertices[pos] = d;
            double d2 = Math.sin(2.0 * (double)i * Math.PI / 8.0);
            PolygonPipeline.zNormal[pos + 4] = d2;
            this.pointVertices[pos + 1] = d2;
            PolygonPipeline.zNormal[pos + 5] = 0.01;
        }
    }

    public final void clearPipeline() {
        this.polygonCount = 0;
        this.vertexCount = 0;
        this.faceShader = null;
        this.lineShader = null;
        this.pointShader = null;
    }

    private final void increasePolygonCapacity() {
        Polygon[] np = new Polygon[this.polygons.length + 100];
        System.arraycopy(this.polygons, 0, np, 0, this.polygons.length);
        for (int i = this.polygons.length; i < np.length; ++i) {
            np[i] = new Polygon();
        }
        this.polygons = np;
    }

    private final void increaseVertexCapacity(int amount) {
        int a = amount > 1200 ? amount : 1200;
        double[] nv = new double[this.vertexData.length + 13 * a];
        System.arraycopy(this.vertexData, 0, nv, 0, this.vertexData.length);
        this.vertexData = nv;
    }

    public final void processPolygon(double[] vd, int[] vertices, double[] nd, int[] normals) {
        if (this.faceShader == null) {
            return;
        }
        this.shader = this.faceShader;
        this.computeArray(vd, vertices, nd, normals);
    }

    final void startGeometry(Geometry geom) {
        if (this.lineShader != null) {
            this.lineShader.startGeometry(geom);
        }
        if (this.faceShader != null) {
            this.faceShader.startGeometry(geom);
        }
        if (this.pointShader != null) {
            this.pointShader.startGeometry(geom);
        }
        if (geom instanceof PointSet) {
            this.vertexColor = ((PointSet)geom).getVertexAttributes(Attribute.COLORS);
            boolean bl = this.vertexColors = this.vertexColor != null;
            if (this.vertexColors) {
                this.vertexColorLength = this.vertexColor.getStorageModel().getDimensions()[1];
            }
        } else {
            this.vertexColor = null;
            this.vertexColors = false;
        }
    }

    public final void processPolygon(DoubleArrayArray vd, IntArray vertices, DoubleArrayArray nd, IntArray normals, DataList texCoords) {
        if (this.faceShader == null) {
            return;
        }
        this.shader = this.faceShader;
        this.computeArray(vd, vertices, nd, normals, texCoords);
    }

    private final void computeArray(double[] vd, int[] vertices, double[] nd, int[] normals) {
        if (2 * vertices.length + 6 >= (this.vertexData.length - this.vertexCount) / 13) {
            this.increaseVertexCapacity(vertices.length / 3);
        }
        int vc = this.vertexCount;
        for (int i = 0; i < vertices.length; ++i) {
            int vi = vertices[i];
            VecMat.transform(this.matrix, vd[vi++], vd[vi++], vd[vi], this.vertexData, vc + 0);
            this.vertexData[vc + 3] = 1.0;
            int ni = normals[i];
            VecMat.transformNormal(this.inverseTransposeMatrix, nd[ni++], nd[ni++], nd[ni], this.vertexData, vc + 10);
            vc += 13;
            if (!this.vertexColors) continue;
            DoubleArray color = this.vertexColor.item(vi / 3).toDoubleArray();
            this.vertexData[vc + 4] = color.getValueAt(0);
            this.vertexData[vc + 5] = color.getValueAt(1);
            this.vertexData[vc + 6] = color.getValueAt(2);
            this.vertexData[vc + 7] = this.vertexColorLength == 4 || this.vertexColorLength == -1 && color.getLength() > 3 ? color.getValueAt(3) : 1.0;
        }
        this.compute(vertices.length);
    }

    private final void computeArrayNoTransform(double[] vd, int[] vertices, double[] nd, int[] normals) {
        if (2 * vertices.length + 6 >= (this.vertexData.length - this.vertexCount) / 13) {
            this.increaseVertexCapacity(vertices.length / 3);
        }
        int vc = this.vertexCount;
        for (int i = 0; i < vertices.length; ++i) {
            int vi = vertices[i];
            this.vertexData[vc + 0] = vd[vi++];
            this.vertexData[vc + 1] = vd[vi++];
            this.vertexData[vc + 2] = vd[vi];
            this.vertexData[vc + 3] = 1.0;
            int ni = normals[i];
            this.vertexData[vc + 10] = nd[ni++];
            this.vertexData[vc + 11] = nd[ni++];
            this.vertexData[vc + 12] = nd[ni];
            vc += 13;
        }
        this.compute(vertices.length);
    }

    private final void computeArray(DoubleArrayArray vd, IntArray vertices, DoubleArrayArray nd, IntArray normals, DataList texCoords) {
        if (2 * vertices.getLength() + 6 >= (this.vertexData.length - this.vertexCount) / 13) {
            this.increaseVertexCapacity(vertices.getLength() / 3);
        }
        int vc = this.vertexCount;
        if (vd.getLengthAt(0) == 3) {
            for (int i = 0; i < vertices.getLength(); ++i) {
                int vi = vertices.getValueAt(i);
                DoubleArray vertex = vd.item(vi).toDoubleArray();
                VecMat.transform(this.matrix, vertex.getValueAt(0), vertex.getValueAt(1), vertex.getValueAt(2), this.vertexData, vc + 0);
                this.vertexData[vc + 3] = 1.0;
                int ni = normals.getValueAt(i);
                DoubleArray normal = nd.item(ni).toDoubleArray();
                VecMat.transformNormal(this.inverseTransposeMatrix, normal.getValueAt(0), normal.getValueAt(1), normal.getValueAt(2), this.vertexData, vc + 10);
                if (this.vertexColors) {
                    DoubleArray color = this.vertexColor.item(vi).toDoubleArray();
                    this.vertexData[vc + 4] = color.getValueAt(0);
                    this.vertexData[vc + 5] = color.getValueAt(1);
                    this.vertexData[vc + 6] = color.getValueAt(2);
                    double d = this.vertexData[vc + 7] = this.vertexColorLength == 4 || this.vertexColorLength == -1 && color.getLength() > 3 ? color.getValueAt(3) : 1.0;
                }
                if (texCoords != null) {
                    DoubleArray tc = texCoords.item(vi).toDoubleArray();
                    this.vertexData[vc + 8] = tc.getValueAt(0);
                    this.vertexData[vc + 9] = tc.getValueAt(1);
                }
                vc += 13;
            }
        } else {
            for (int i = 0; i < vertices.getLength(); ++i) {
                int vi = vertices.getValueAt(i);
                DoubleArray vertex = vd.item(vi).toDoubleArray();
                VecMat.transform(this.matrix, vertex.getValueAt(0), vertex.getValueAt(1), vertex.getValueAt(2), vertex.getValueAt(3), this.vertexData, vc + 0);
                if (this.vertexData[vc + 3] != 0.0) {
                    double d = this.vertexData[vc + 3];
                    int n = vc + 0;
                    this.vertexData[n] = this.vertexData[n] / d;
                    int n2 = vc + 1;
                    this.vertexData[n2] = this.vertexData[n2] / d;
                    int n3 = vc + 2;
                    this.vertexData[n3] = this.vertexData[n3] / d;
                    this.vertexData[vc + 3] = 1.0;
                }
                int ni = normals.getValueAt(i);
                DoubleArray normal = nd.item(ni).toDoubleArray();
                VecMat.transformNormal(this.inverseTransposeMatrix, normal.getValueAt(0), normal.getValueAt(1), normal.getValueAt(2), this.vertexData, vc + 10);
                if (this.vertexColors) {
                    DoubleArray color = this.vertexColor.item(vi).toDoubleArray();
                    this.vertexData[vc + 4] = color.getValueAt(0);
                    this.vertexData[vc + 5] = color.getValueAt(1);
                    this.vertexData[vc + 6] = color.getValueAt(2);
                    double d = this.vertexData[vc + 7] = this.vertexColorLength == 4 || this.vertexColorLength == -1 && color.getLength() > 3 ? color.getValueAt(3) : 1.0;
                }
                if (texCoords != null) {
                    DoubleArray tc = texCoords.item(vi).toDoubleArray();
                    this.vertexData[vc + 8] = tc.getValueAt(0);
                    this.vertexData[vc + 9] = tc.getValueAt(1);
                }
                vc += 13;
            }
        }
        this.compute(vertices.getLength());
    }

    private final void compute(int verticesLength) {
        if (this.polygonCount + 1 >= this.polygons.length) {
            this.increasePolygonCapacity();
        }
        Polygon p = this.polygons[this.polygonCount++];
        p.length = verticesLength;
        p.setShader(this.shader);
        for (int i = 0; i < verticesLength; ++i) {
            p.vertices[i] = this.vertexCount;
            this.vertexCount += 13;
        }
        this.environment.setMatrix(this.matrix);
        this.shader.shadePolygon(p, this.vertexData, this.environment);
        int numClip = this.environment.getNumClippingPlanes();
        if (numClip > 0) {
            ClippingPlaneSoft[] cp = this.environment.getClippingPlanes();
            for (int k = 0; k < numClip; ++k) {
                double d = VecMat.dot(cp[k].getNormal(), cp[k].getPoint());
                int res = Intersector.clipToHalfspace(p, cp[k].getNormal(), -1, d, this);
                if (res != -1) continue;
                p.setShader(null);
                this.vertexCount -= p.length * 13;
                --this.polygonCount;
                return;
            }
        }
        for (int i = 0; i < p.length; ++i) {
            this.perspective.perspective(this.vertexData, p.vertices[i]);
        }
        boolean clippedAway = this.clipPolygon();
        if (!clippedAway) {
            boolean isTransparent = p.getShader().needsSorting();
            if (this.queueOpaque || isTransparent) {
                if (this.sortOpaque || isTransparent) {
                    p.computeCenterZ(this.vertexData);
                }
                return;
            }
            this.renderer.renderPolygon(p, this.vertexData, p.getShader().isOutline());
        }
        p.setShader(null);
        this.vertexCount -= p.length * 13;
        --this.polygonCount;
    }

    public int getFreeVertex() {
        if (this.vertexCount >= this.vertexData.length) {
            this.increaseVertexCapacity(1);
        }
        int vc = this.vertexCount;
        this.vertexCount += 13;
        return vc;
    }

    public void freePolygon(int idx) {
        if (idx != this.polygonCount - 1) {
            Polygon p = this.polygons[idx];
            this.polygons[idx] = this.polygons[this.polygonCount - 1];
            this.polygons[this.polygonCount - 1] = p;
        }
        --this.polygonCount;
    }

    public int getFreePolygon() {
        if (this.polygonCount >= this.polygons.length - 1) {
            this.increasePolygonCapacity();
        }
        int pc = this.polygonCount++;
        return pc;
    }

    private final boolean clipPolygon() {
        int polPos = this.polygonCount - 1;
        Polygon p1 = this.polygons[polPos];
        ClippingBox box = this.perspective.getFrustum();
        int x0out = 0;
        int x1out = 0;
        int y0out = 0;
        int y1out = 0;
        int z0out = 0;
        int z1out = 0;
        int n = p1.length;
        int v = p1.vertices[0];
        for (int i = 0; i < n; ++i) {
            v = p1.vertices[i];
            double vsw = this.vertexData[v + 3];
            if (this.vertexData[v + 0] < box.x0 * vsw) {
                ++x0out;
            }
            if (this.vertexData[v + 0] > box.x1 * vsw) {
                ++x1out;
            }
            if (this.vertexData[v + 1] < box.y0 * vsw) {
                ++y0out;
            }
            if (this.vertexData[v + 1] > box.y1 * vsw) {
                ++y1out;
            }
            if (this.vertexData[v + 2] < box.z0 * vsw) {
                ++z0out;
            }
            if (!(this.vertexData[v + 2] > box.z1 * vsw)) continue;
            ++z1out;
        }
        if (x0out + x1out + y0out + y1out + z0out + z1out == 0) {
            return false;
        }
        if (x0out == n || x1out == n || y0out == n || y1out == n || z0out == n || z1out == n) {
            return true;
        }
        if (x0out != 0) {
            this.clipToHalfspace(polPos, this.polygons, 0, -1, -box.x0);
        }
        if (x1out != 0) {
            this.clipToHalfspace(polPos, this.polygons, 0, 1, box.x1);
        }
        if (y0out != 0) {
            this.clipToHalfspace(polPos, this.polygons, 1, -1, -box.y0);
        }
        if (y1out != 0) {
            this.clipToHalfspace(polPos, this.polygons, 1, 1, box.y1);
        }
        if (z0out != 0) {
            this.clipToHalfspace(polPos, this.polygons, 2, -1, -box.z0);
        }
        if (z1out != 0) {
            this.clipToHalfspace(polPos, this.polygons, 2, 1, box.z1);
        }
        return p1.length == 0;
    }

    private void clipToHalfspace(int polPos, Polygon[] polygons, int index, int sign, double k) {
        Polygon p = polygons[polPos];
        if (p.length == 0) {
            return;
        }
        int u = p.vertices[p.length - 1];
        int v = p.vertices[0];
        double tu = (double)sign * this.vertexData[u + index] - k * this.vertexData[u + 3];
        double tv = 0.0;
        Polygon newP = polygons[polPos + 1];
        newP.length = 0;
        int i = 0;
        while (i < p.length) {
            if (tu <= 0.0 ^ (tv = (double)sign * this.vertexData[v + index] - k * this.vertexData[v + 3]) <= 0.0) {
                double t = tu / (tu - tv);
                for (int j = 0; j < 13; ++j) {
                    this.vertexData[this.vertexCount + j] = this.vertexData[u + j] + t * (this.vertexData[v + j] - this.vertexData[u + j]);
                }
                newP.vertices[newP.length++] = this.vertexCount;
                this.vertexCount += 13;
            }
            if (tv <= 0.0) {
                newP.vertices[newP.length++] = v;
            }
            u = v;
            tu = tv;
            v = p.vertices[++i];
        }
        int[] vp = p.vertices;
        p.vertices = newP.vertices;
        p.length = newP.length;
        newP.vertices = vp;
    }

    public final void setMatrix(double[] matrix) {
        this.matrix = matrix;
        Rn.transpose(this.inverseTransposeMatrix, matrix);
        Rn.inverse(this.inverseTransposeMatrix, this.inverseTransposeMatrix);
    }

    public final void sortPolygons() {
        Arrays.sort(this.polygons, 0, this.polygonCount, this.comp);
    }

    public final Perspective getPerspective() {
        return this.perspective;
    }

    public final void setPerspective(Perspective perspective) {
        this.perspective = perspective;
    }

    public final Environment getEnvironment() {
        return this.environment;
    }

    public final void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public final void renderRemaining(PolygonRasterizer renderer) {
        for (int i = 0; i < this.polygonCount; ++i) {
            Polygon p = this.polygons[i];
            renderer.renderPolygon(p, this.vertexData, p.getShader().isOutline());
            p.setShader(null);
        }
    }

    public final void processPoint(double[] data, int index, int length) {
        if (this.pointShader == null) {
            return;
        }
        if (length == 4) {
            this.processPoint(data[index], data[index + 1], data[index + 2], data[index + 3]);
        } else {
            this.processPoint(data[index], data[index + 1], data[index + 2], 1.0);
        }
    }

    public final void processPoint(DoubleArrayArray data, int index) {
        DoubleArray da = data.item(index).toDoubleArray();
        double w = 1.0;
        if (da.size() == 4) {
            w = da.getValueAt(3);
        }
        if (this.vertexColors) {
            DoubleArray color = this.vertexColor.item(index).toDoubleArray();
            for (int i = 0; i < 16; ++i) {
                PolygonPipeline.pointColors[i][0] = color.getValueAt(0);
                PolygonPipeline.pointColors[i][1] = color.getValueAt(1);
                PolygonPipeline.pointColors[i][2] = color.getValueAt(2);
                PolygonPipeline.pointColors[i][3] = this.vertexColorLength == 4 || this.vertexColorLength == -1 && color.getLength() > 3 ? color.getValueAt(3) : 1.0;
            }
            this.vertexColor = this.pointColorDataList;
        }
        this.processPoint(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), w);
    }

    public final void processPoint(double x, double y, double z, double w) {
        if (this.pointShader == null) {
            return;
        }
        VecMat.transform(this.matrix, x, y, z, w, this.point0, 0);
        VecMat.transformUnNormalized(this.matrix, 0.0, 0.0, this.pointRadius, this.normal0, 0);
        double[] mat = this.matrix;
        double[] tmat = this.inverseTransposeMatrix;
        this.matrix = this.substMatrix;
        double d = 1.0 - this.outlineFraction;
        double l = VecMat.norm(this.normal0);
        VecMat.assignScale(this.matrix, l * d);
        this.matrix[3] = this.point0[0];
        this.matrix[7] = this.point0[1];
        this.matrix[11] = this.point0[2] + this.pointRadius;
        Rn.transpose(this.inverseTransposeMatrix, this.matrix);
        Rn.inverse(this.inverseTransposeMatrix, this.inverseTransposeMatrix);
        this.shader = this.pointShader.getCoreShader();
        this.computeArray(this.pointVertices, pointIndices, zNormal, pointNormals);
        if (this.outlineFraction > 0.0) {
            int i;
            this.shader = this.pointShader.getOutlineShader();
            d = 1.0 / d;
            for (i = 0; i < 24; i += 3) {
                this.pointVertices[24 + i] = this.pointVertices[i] * d;
                this.pointVertices[25 + i] = this.pointVertices[i + 1] * d;
                this.pointVertices[26 + i] = -d;
            }
            for (i = 0; i < 8; ++i) {
                this.computeArray(this.pointVertices, pointOutlineIndices[i], zNormal, pointOutlineNormals[i]);
            }
        }
        this.matrix = mat;
        this.inverseTransposeMatrix = tmat;
    }

    public final void processLine(DoubleArray from, DoubleArray to) {
        if (this.lineShader == null) {
            return;
        }
        this.shader = this.lineShader.getPolygonShader();
        double w = 1.0;
        if (from.size() == 4) {
            w = from.getValueAt(3);
        }
        VecMat.transform(this.matrix, from.getValueAt(0), from.getValueAt(1), from.getValueAt(2), 1.0, this.point0, 0);
        VecMat.transformUnNormalized(this.matrix, 0.0, 0.0, this.lineWidth, this.normal0, 0);
        w = 1.0;
        if (to.size() == 4) {
            w = from.getValueAt(3);
        }
        VecMat.transform(this.matrix, to.getValueAt(0), to.getValueAt(1), to.getValueAt(2), 1.0, this.point1, 0);
        double[] mat = this.matrix;
        double[] tmat = this.inverseTransposeMatrix;
        this.matrix = identity;
        this.inverseTransposeMatrix = identity;
        this.direction[0] = this.point1[0] - this.point0[0];
        this.direction[1] = this.point1[1] - this.point0[1];
        this.direction[2] = this.point1[2] - this.point0[2];
        if (VecMat.norm(this.direction) == 0.0) {
            this.matrix = mat;
            this.inverseTransposeMatrix = tmat;
            return;
        }
        VecMat.normalize(this.direction);
        double length = VecMat.norm(this.normal0);
        VecMat.cross(this.direction, zNormal, this.normal0);
        VecMat.normalize(this.normal0);
        this.normal0[0] = this.normal0[0] * length;
        this.normal0[1] = this.normal0[1] * length;
        this.normal0[2] = this.normal0[2] * length;
        VecMat.cross(this.normal0, this.direction, this.normal1);
        VecMat.normalize(this.normal1);
        this.line[0] = this.point0[0] - this.normal0[0];
        this.line[1] = this.point0[1] - this.normal0[1];
        this.line[2] = this.point0[2] + length;
        this.line[3] = this.point0[0] + this.normal0[0];
        this.line[4] = this.point0[1] + this.normal0[1];
        this.line[5] = this.point0[2] + length;
        this.line[6] = this.point1[0] + this.normal0[0];
        this.line[7] = this.point1[1] + this.normal0[1];
        this.line[8] = this.point1[2] + length;
        this.line[9] = this.point1[0] - this.normal0[0];
        this.line[10] = this.point1[1] - this.normal0[1];
        this.line[11] = this.point1[2] + length;
        this.computeArray(this.line, lineIndices, this.normal1, pointNormals);
        this.matrix = mat;
        this.inverseTransposeMatrix = tmat;
    }

    public final void processPseudoTube(DoubleArray from, DoubleArray to) {
        if (this.lineShader == null) {
            return;
        }
        this.shader = this.lineShader.getPolygonShader();
        double w = 1.0;
        if (from.size() == 4) {
            w = from.getValueAt(3);
        }
        VecMat.transform(this.matrix, from.getValueAt(0), from.getValueAt(1), from.getValueAt(2), w, this.point0, 0);
        VecMat.transformUnNormalized(this.matrix, 0.0, 0.0, this.lineWidth, this.normal0, 0);
        w = 1.0;
        if (to.size() == 4) {
            w = to.getValueAt(3);
        }
        VecMat.transform(this.matrix, to.getValueAt(0), to.getValueAt(1), to.getValueAt(2), w, this.point1, 0);
        double[] mat = this.matrix;
        double[] tmat = this.inverseTransposeMatrix;
        this.matrix = identity;
        this.inverseTransposeMatrix = identity;
        this.direction[0] = this.point1[0] - this.point0[0];
        this.direction[1] = this.point1[1] - this.point0[1];
        this.direction[2] = this.point1[2] - this.point0[2];
        this.zzNormal[0] = this.point1[0] + this.point0[0];
        this.zzNormal[1] = this.point1[1] + this.point0[1];
        this.zzNormal[2] = this.point1[2] + this.point0[2];
        VecMat.normalize(this.zzNormal);
        if (VecMat.norm(this.direction) == 0.0) {
            this.matrix = mat;
            this.inverseTransposeMatrix = tmat;
            return;
        }
        VecMat.normalize(this.direction);
        double length = VecMat.norm(this.normal0);
        VecMat.cross(this.direction, this.zzNormal, this.normal0);
        VecMat.normalize(this.normal0);
        VecMat.cross(this.normal0, this.direction, this.normal1);
        this.normal0[0] = this.normal0[0] * length;
        this.normal0[1] = this.normal0[1] * length;
        this.normal0[2] = this.normal0[2] * length;
        VecMat.normalize(this.normal1);
        if (VecMat.dot(this.normal1, this.zzNormal) < 0.0) {
            this.normal1[0] = this.normal1[0] * -1.0;
            this.normal1[1] = this.normal1[1] * -1.0;
            this.normal1[2] = this.normal1[2] * -1.0;
            System.out.println("flip");
        }
        this.line[0] = this.point0[0] - this.normal0[0];
        this.line[1] = this.point0[1] - this.normal0[1];
        this.line[2] = this.point0[2];
        this.line[3] = this.point0[0];
        this.line[4] = this.point0[1];
        this.line[5] = this.point0[2] + length;
        this.line[6] = this.point1[0];
        this.line[7] = this.point1[1];
        this.line[8] = this.point1[2] + length;
        this.line[9] = this.point1[0] - this.normal0[0];
        this.line[10] = this.point1[1] - this.normal0[1];
        this.line[11] = this.point1[2];
        this.normal2[0] = cs / length * this.normal0[0] + ss * this.normal1[0];
        this.normal2[1] = cs / length * this.normal0[1] + ss * this.normal1[1];
        this.normal2[2] = ss * this.normal1[2];
        this.normal2[3] = this.normal1[0];
        this.normal2[4] = this.normal1[1];
        this.normal2[5] = this.normal1[2];
        this.computeArrayNoTransform(this.line, lineIndices, this.normal2, nIndices);
        this.line[0] = this.point0[0];
        this.line[1] = this.point0[1];
        this.line[2] = this.point0[2] + length;
        this.line[3] = this.point0[0] + this.normal0[0];
        this.line[4] = this.point0[1] + this.normal0[1];
        this.line[5] = this.point0[2];
        this.line[6] = this.point1[0] + this.normal0[0];
        this.line[7] = this.point1[1] + this.normal0[1];
        this.line[8] = this.point1[2];
        this.line[9] = this.point1[0];
        this.line[10] = this.point1[1];
        this.line[11] = this.point1[2] + length;
        this.normal2[0] = this.normal1[0];
        this.normal2[1] = this.normal1[1];
        this.normal2[2] = this.normal1[2];
        this.normal2[3] = -cs / length * this.normal0[0] + ss * this.normal1[0];
        this.normal2[4] = -cs / length * this.normal0[1] + ss * this.normal1[1];
        this.normal2[5] = ss * this.normal1[2];
        this.computeArrayNoTransform(this.line, lineIndices, this.normal2, nIndices);
        this.matrix = mat;
        this.inverseTransposeMatrix = tmat;
    }

    public PolygonShader getFaceShader() {
        return this.faceShader;
    }

    public void setFaceShader(PolygonShader faceShader) {
        this.faceShader = faceShader;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public double getPointRadius() {
        return this.pointRadius;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setPointRadius(double pointRadius) {
        this.pointRadius = pointRadius;
    }

    public LineShader getLineShader() {
        return this.lineShader;
    }

    public PointShader getPointShader() {
        return this.pointShader;
    }

    public void setLineShader(LineShader lineShader) {
        this.lineShader = lineShader;
        if (lineShader != null) {
            this.lineWidth = lineShader.getLineWidth();
        }
    }

    public void setPointShader(PointShader pointShader) {
        this.pointShader = pointShader;
        if (pointShader != null) {
            this.pointRadius = pointShader.getPointRadius();
            this.outlineFraction = pointShader.getOutlineFraction();
        }
    }

    public double getOutlineFraction() {
        return this.outlineFraction;
    }

    public void setOutlineFraction(double outlineFraction) {
        this.outlineFraction = outlineFraction;
    }

    public int copyPolygon(Polygon p) {
        int newP = this.getFreePolygon();
        Polygon np = this.polygons[newP];
        np.length = p.length;
        for (int i = 0; i < p.length; ++i) {
            np.vertices[i] = p.vertices[i];
            np.setShader(p.getShader());
            np.setCenterZ(p.getCenterZ());
        }
        return newP;
    }
}

