/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.soft.Polygon;
import de.jreality.soft.PolygonRasterizer;
import de.jreality.soft.SkyboxPolygonShader;
import de.jreality.soft.Texture;

public abstract class ModularLongPolygonRasterizer
implements PolygonRasterizer {
    protected static final int FIXP = 14;
    protected static final int FIXPS = 16384;
    protected static final int FIXPZ = 30;
    protected static final int FIXPZS = 0x40000000;
    protected static final int FIXPT = 30;
    protected static final int FIXPTS = 0x40000000;
    private int xmin = 0;
    private int xmax = 0;
    private int ymin = 0;
    private int ymax = 0;
    private int wh;
    private int hh;
    private int mh;
    private int pLength = 0;
    private long[][] polygon = new long[Polygon.MAXPOLYVERTEX][13];
    protected long transparency = 0L;
    protected long oneMinusTransparency = 255L;
    private Texture texture = null;
    private boolean interpolateColor = true;
    private boolean interpolateTexture = false;
    private static final boolean correctInterpolation = true;
    private long[][] tri = new long[3][];
    private long alsxI;
    private long alsyI;
    private long alszI;
    private long alrI;
    private long algI;
    private long albI;
    private long aluI;
    private long alvI;
    private long alwI;
    private long adlsxI;
    private long adlsyI;
    private long adlszI;
    private long adlrI;
    private long adlgI;
    private long adlbI;
    private long adluI;
    private long adlvI;
    private long adlwI;
    private long arsxI;
    private long arsyI;
    private long arszI;
    private long arrI;
    private long argI;
    private long arbI;
    private long aruI;
    private long arvI;
    private long arwI;
    private long adrsxI;
    private long adrsyI;
    private long adrszI;
    private long adrrI;
    private long adrgI;
    private long adrbI;
    private long adruI;
    private long adrvI;
    private long adrwI;
    protected long apsxI;
    protected long apsyI;
    protected long apszI;
    protected long aprI;
    protected long apgI;
    protected long apbI;
    protected long apuI;
    protected long apvI;
    protected long apwI;
    protected long adpsxI;
    protected long adpsyI;
    protected long adpszI;
    protected long adprI;
    protected long adpgI;
    protected long adpbI;
    protected long adpuI;
    protected long adpvI;
    protected long adpwI;
    private int[] color = new int[4];
    private static final int FIXPHS = 65536;
    private static final int ZEPS = -107374;

    public final void renderPolygon(Polygon p, double[] vertexData, boolean outline) {
        this.transparency = (long)(p.getShader().getVertexShader().getTransparency() * 255.0);
        this.oneMinusTransparency = 255L - this.transparency;
        this.pLength = p.length;
        for (int i = 0; i < this.pLength; ++i) {
            long iw;
            int pos = p.vertices[i];
            long[] pi = this.polygon[i];
            double w = 1.0 / vertexData[pos + 3];
            double wxy = w * (double)this.mh;
            pi[0] = (long)((double)this.wh + vertexData[pos + 0] * wxy);
            pi[1] = (long)((double)this.hh - vertexData[pos + 1] * wxy);
            pi[2] = (long)(vertexData[pos + 2] * w * 1.073741824E9);
            if (p.getShader() instanceof SkyboxPolygonShader) {
                pi[2] = 0x40000000L;
            }
            this.interpolateColor = p.getShader().interpolateColor();
            pi[3] = (long)(w * 1.073741824E9);
            pi[8] = (long)(vertexData[pos + 8] * 1.073741824E9 * w);
            pi[9] = (long)(vertexData[pos + 9] * 1.073741824E9 * w);
            long l = iw = this.interpolateColor ? (long)(w * 16384.0) : 16384L;
            if (this.transparency == 0L) {
                pi[4] = (long)((vertexData[pos + 4] > 1.0 ? 255.0 : vertexData[pos + 4] * 255.0) * (double)iw);
                pi[5] = (long)((vertexData[pos + 5] > 1.0 ? 255.0 : vertexData[pos + 5] * 255.0) * (double)iw);
                pi[6] = (long)((vertexData[pos + 6] > 1.0 ? 255.0 : vertexData[pos + 6] * 255.0) * (double)iw);
                continue;
            }
            pi[4] = this.oneMinusTransparency * (long)((vertexData[pos + 4] > 1.0 ? 255.0 : vertexData[pos + 4] * 255.0) * (double)iw);
            pi[5] = this.oneMinusTransparency * (long)((vertexData[pos + 5] > 1.0 ? 255.0 : vertexData[pos + 5] * 255.0) * (double)iw);
            pi[6] = this.oneMinusTransparency * (long)((vertexData[pos + 6] > 1.0 ? 255.0 : vertexData[pos + 6] * 255.0) * (double)iw);
        }
        if (outline) {
            this.transparency = 0L;
            for (int j = 0; j < this.pLength - 1; ++j) {
                this.line(this.polygon[j][0], this.polygon[j][1], this.polygon[j][2], this.polygon[j + 1][0], this.polygon[j + 1][1], this.polygon[j + 1][2], this.xmin, this.xmax, this.ymin, this.ymax);
            }
            this.line(this.polygon[this.pLength - 1][0], this.polygon[this.pLength - 1][1], this.polygon[this.pLength - 1][2], this.polygon[0][0], this.polygon[0][1], this.polygon[0][2], this.xmin, this.xmax, this.ymin, this.ymax);
        }
        this.transparency = (long)(p.getShader().getVertexShader().getTransparency() * 255.0);
        this.texture = p.getShader().getTexture();
        this.interpolateTexture = this.texture != null;
        this.interpolateColor = p.getShader().interpolateColor();
        if (this.interpolateColor) {
            // empty if block
        }
        this.scanPolyI(this.polygon, this.pLength, this.xmin, this.xmax - 1, this.ymin, this.ymax - 1);
    }

    private final void scanPolyI(long[][] p, int plength, long wxmin, long wxmax, long wymin, long wymax) {
        long ry;
        int ri;
        int i;
        int top = 0;
        if (plength > Polygon.MAXPOLYVERTEX) {
            System.err.println("scanPoly: polygon had to many vertices: " + plength);
            return;
        }
        if (!this.interpolateColor) {
            this.aprI = p[0][4];
            this.apgI = p[0][5];
            this.apbI = p[0][6];
        }
        long ymin = Integer.MAX_VALUE;
        for (i = 0; i < plength; ++i) {
            if (p[i][1] >= ymin) continue;
            ymin = p[i][1];
            top = i;
        }
        int li = ri = top;
        long rem = plength;
        long y = ymin + 8192L - 1L >> 14;
        long ly = ry = y - 1L;
        while (rem > 0L) {
            while (ly <= y && rem > 0L) {
                --rem;
                i = li - 1;
                if (i < 0) {
                    i = plength - 1;
                }
                this.incrementalizeYldlI(p[li], p[i], y);
                ly = p[i][1] + 8192L >> 14;
                li = i;
            }
            while (ry <= y && rem > 0L) {
                --rem;
                i = ri + 1;
                if (i >= plength) {
                    i = 0;
                }
                this.incrementalizeYrdrI(p[ri], p[i], y);
                ry = p[i][1] + 8192L >> 14;
                ri = i;
            }
            while (y < ly && y < ry) {
                if (y >= wymin && y <= wymax) {
                    if (this.alsxI <= this.arsxI) {
                        this.scanlinelrI(y, wxmin, wxmax, wymin, wymax);
                    } else {
                        this.scanlinerlI(y, wxmin, wxmax, wymin, wymax);
                    }
                }
                ++y;
                this.incrementldlI();
                this.incrementrdrI();
            }
        }
    }

    private final void incrementldlI() {
        this.alsxI += this.adlsxI;
        this.alszI += this.adlszI;
        if (this.interpolateColor) {
            this.alrI += this.adlrI;
            this.algI += this.adlgI;
            this.albI += this.adlbI;
        }
        if (this.interpolateTexture) {
            this.aluI += this.adluI;
            this.alvI += this.adlvI;
        }
        this.alwI += this.adlwI;
    }

    private final void incrementrdrI() {
        this.arsxI += this.adrsxI;
        this.arszI += this.adrszI;
        if (this.interpolateColor) {
            this.arrI += this.adrrI;
            this.argI += this.adrgI;
            this.arbI += this.adrbI;
        }
        if (this.interpolateTexture) {
            this.aruI += this.adruI;
            this.arvI += this.adrvI;
        }
        this.arwI += this.adrwI;
    }

    private final void incrementpdpI() {
        this.apszI += this.adpszI;
        if (this.interpolateColor) {
            this.aprI += this.adprI;
            this.apgI += this.adpgI;
            this.apbI += this.adpbI;
        }
        if (this.interpolateTexture) {
            this.apuI += this.adpuI;
            this.apvI += this.adpvI;
        }
        this.apwI += this.adpwI;
    }

    private final void scanlinelrI(long y, long wxmin, long wxmax, long wymin, long wymax) {
        long x = 0L;
        long lx = 0L;
        long rx = 0L;
        lx = this.alsxI + 8192L - 1L >> 14;
        if (lx < wxmin) {
            lx = wxmin;
        }
        if ((rx = this.arsxI - 8192L >> 14) > wxmax) {
            rx = wxmax;
        }
        if (lx > rx) {
            return;
        }
        this.incrementalizeXlrpdpI(lx);
        for (x = lx; x <= rx; ++x) {
            this.colorize(x, y);
            this.incrementpdpI();
        }
    }

    private final void colorize(long x, long y) {
        if (this.interpolateTexture) {
            this.texture.getColor((double)this.apuI / (double)this.apwI, (double)this.apvI / (double)this.apwI, (int)x, (int)y, this.color);
            int t = this.color[3];
            if (this.interpolateColor) {
                long ww = this.apwI >> 16;
                if (t < 255) {
                    this.setPixel((int)x, (int)y, (int)this.apszI, (int)(0xFFL & (this.aprI >> 8) * (long)(this.color[0] * t) / ww), (int)(0xFFL & (this.apgI >> 8) * (long)(this.color[1] * t) / ww), (int)(0xFFL & (this.apbI >> 8) * (long)(this.color[2] * t) / ww), 255 - t);
                } else {
                    this.setPixel((int)x, (int)y, (int)this.apszI, (int)(0xFFL & (this.aprI >> 8) * (long)this.color[0] / ww), (int)(0xFFL & (this.apgI >> 8) * (long)this.color[1] / ww), (int)(0xFFL & (this.apbI >> 8) * (long)this.color[2] / ww), (int)this.transparency);
                }
            } else if (t < 255) {
                this.setPixel((int)x, (int)y, (int)this.apszI, (int)((this.aprI >> 8) * (long)(this.color[0] * t)) >> 14, (int)((this.apgI >> 8) * (long)(this.color[1] * t)) >> 14, (int)((this.apbI >> 8) * (long)(this.color[2] * t)) >> 14, 255 - t);
            } else {
                this.setPixel((int)x, (int)y, (int)this.apszI, (int)((this.aprI >> 8) * (long)this.color[0]) >> 14, (int)((this.apgI >> 8) * (long)this.color[1]) >> 14, (int)((this.apbI >> 8) * (long)this.color[2]) >> 14, (int)this.transparency);
            }
        } else if (this.interpolateColor) {
            long ww = (this.apwI >> 16) - 1L;
            this.setPixel((int)x, (int)y, (int)this.apszI, (int)(0xFFL & this.aprI / ww), (int)(0xFFL & this.apgI / ww), (int)(0xFFL & this.apbI / ww), (int)this.transparency);
        } else {
            this.setPixel((int)x, (int)y, (int)this.apszI, (int)(this.aprI >> 14), (int)(this.apgI >> 14), (int)(this.apbI >> 14), (int)this.transparency);
        }
    }

    private final void scanlinerlI(long y, long wxmin, long wxmax, long wymin, long wymax) {
        long x = 0L;
        long lx = 0L;
        long rx = 0L;
        lx = this.arsxI + 8192L - 1L >> 14;
        if (lx < wxmin) {
            lx = wxmin;
        }
        if ((rx = this.alsxI - 8192L >> 14) > wxmax) {
            rx = wxmax;
        }
        if (lx > rx) {
            return;
        }
        this.incrementalizeXrlpdpI(lx);
        for (x = lx; x <= rx; ++x) {
            this.colorize(x, y);
            this.incrementpdpI();
        }
    }

    protected abstract void setPixel(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private final void incrementalizeXrlpdpI(long x) {
        long dx = this.alsxI - this.arsxI >> 7;
        if (dx == 0L) {
            dx = 128L;
        }
        long frac = (x << 14) + 8192L - this.arsxI >> 7;
        this.adpszI = (this.alszI - this.arszI) / dx;
        this.apszI = this.arszI + this.adpszI * frac;
        this.adpszI <<= 7;
        if (this.interpolateColor) {
            this.adprI = (this.alrI - this.arrI) / dx;
            this.aprI = this.arrI + this.adprI * frac;
            this.adprI <<= 7;
            this.adpgI = (this.algI - this.argI) / dx;
            this.apgI = this.argI + this.adpgI * frac;
            this.adpgI <<= 7;
            this.adpbI = (this.albI - this.arbI) / dx;
            this.apbI = this.arbI + this.adpbI * frac;
            this.adpbI <<= 7;
        }
        if (this.interpolateTexture) {
            this.adpuI = (this.aluI - this.aruI) / dx;
            this.apuI = this.aruI + this.adpuI * frac;
            this.adpuI <<= 7;
            this.adpvI = (this.alvI - this.arvI) / dx;
            this.apvI = this.arvI + this.adpvI * frac;
            this.adpvI <<= 7;
        }
        this.adpwI = (this.alwI - this.arwI) / dx;
        this.apwI = this.arwI + this.adpwI * frac;
        this.adpwI <<= 7;
    }

    private final void incrementalizeXlrpdpI(long x) {
        long dx = this.arsxI - this.alsxI >> 7;
        if (dx == 0L) {
            dx = 128L;
        }
        long frac = (x << 14) + 8192L - this.alsxI >> 7;
        this.adpszI = (this.arszI - this.alszI) / dx;
        this.apszI = this.alszI + this.adpszI * frac;
        this.adpszI <<= 7;
        if (this.interpolateColor) {
            this.adprI = (this.arrI - this.alrI) / dx;
            this.aprI = this.alrI + this.adprI * frac;
            this.adprI <<= 7;
            this.adpgI = (this.argI - this.algI) / dx;
            this.apgI = this.algI + this.adpgI * frac;
            this.adpgI <<= 7;
            this.adpbI = (this.arbI - this.albI) / dx;
            this.apbI = this.albI + this.adpbI * frac;
            this.adpbI <<= 7;
        }
        if (this.interpolateTexture) {
            this.adpuI = (this.aruI - this.aluI) / dx;
            this.apuI = this.aluI + this.adpuI * frac;
            this.adpuI <<= 7;
            this.adpvI = (this.arvI - this.alvI) / dx;
            this.apvI = this.alvI + this.adpvI * frac;
            this.adpvI <<= 7;
        }
        this.adpwI = (this.arwI - this.alwI) / dx;
        this.apwI = this.alwI + this.adpwI * frac;
        this.adpwI <<= 7;
    }

    private final void incrementalizeYldlI(long[] p1, long[] p2, long y) {
        long dy = p2[1] - p1[1] >> 7;
        if (dy == 0L) {
            dy = 128L;
        }
        long frac = (y << 14) + 8192L - p1[1] >> 7;
        this.adlsxI = (p2[0] - p1[0]) / dy;
        this.alsxI = p1[0] + this.adlsxI * frac;
        this.adlsxI <<= 7;
        this.adlszI = (p2[2] - p1[2]) / dy;
        this.alszI = p1[2] + this.adlszI * frac;
        this.adlszI <<= 7;
        if (this.interpolateColor) {
            this.adlrI = (p2[4] - p1[4]) / dy;
            this.alrI = p1[4] + this.adlrI * frac;
            this.adlrI <<= 7;
            this.adlgI = (p2[5] - p1[5]) / dy;
            this.algI = p1[5] + this.adlgI * frac;
            this.adlgI <<= 7;
            this.adlbI = (p2[6] - p1[6]) / dy;
            this.albI = p1[6] + this.adlbI * frac;
            this.adlbI <<= 7;
        }
        if (this.interpolateTexture) {
            this.adluI = (p2[8] - p1[8]) / dy;
            this.aluI = p1[8] + this.adluI * frac;
            this.adluI <<= 7;
            this.adlvI = (p2[9] - p1[9]) / dy;
            this.alvI = p1[9] + this.adlvI * frac;
            this.adlvI <<= 7;
        }
        this.adlwI = (p2[3] - p1[3]) / dy;
        this.alwI = p1[3] + this.adlwI * frac;
        this.adlwI <<= 7;
    }

    private final void incrementalizeYrdrI(long[] p1, long[] p2, long y) {
        long dy = p2[1] - p1[1] >> 7;
        if (dy == 0L) {
            dy = 128L;
        }
        long frac = (y << 14) + 8192L - p1[1] >> 7;
        this.adrsxI = (p2[0] - p1[0]) / dy;
        this.arsxI = p1[0] + this.adrsxI * frac;
        this.adrsxI <<= 7;
        this.adrszI = (p2[2] - p1[2]) / dy;
        this.arszI = p1[2] + this.adrszI * frac;
        this.adrszI <<= 7;
        if (this.interpolateColor) {
            this.adrrI = (p2[4] - p1[4]) / dy;
            this.arrI = p1[4] + this.adrrI * frac;
            this.adrrI <<= 7;
            this.adrgI = (p2[5] - p1[5]) / dy;
            this.argI = p1[5] + this.adrgI * frac;
            this.adrgI <<= 7;
            this.adrbI = (p2[6] - p1[6]) / dy;
            this.arbI = p1[6] + this.adrbI * frac;
            this.adrbI <<= 7;
        }
        if (this.interpolateTexture) {
            this.adruI = (p2[8] - p1[8]) / dy;
            this.aruI = p1[8] + this.adruI * frac;
            this.adruI <<= 7;
            this.adrvI = (p2[9] - p1[9]) / dy;
            this.arvI = p1[9] + this.adrvI * frac;
            this.adrvI <<= 7;
        }
        this.adrwI = (p2[3] - p1[3]) / dy;
        this.arwI = p1[3] + this.adrwI * frac;
        this.adrwI <<= 7;
    }

    private final void line(long x1, long y1, long z1, long x2, long y2, long z2, long xmin, long xmax, long ymin, long ymax) {
        long dirX = x2 - x1;
        long dirY = y2 - y1;
        long dirZ = z2 - z1;
        double l = (double)dirX * (double)dirX + (double)dirY * (double)dirY;
        long il = 1L * ((long)(l = Math.sqrt(l)) >> 14);
        if (il == 0L) {
            return;
        }
        long zz1 = z1 - (dirZ /= il) + -107374L;
        long zz2 = z2 + dirZ + -107374L;
        this.interpolateColor = false;
        this.interpolateTexture = false;
        this.scanPolyI(new long[][]{{x1 - dirX - (dirY /= il), y1 - dirY + (dirX /= il), zz1, 0L, 0L, 0L, 0L, 0L, 1L}, {x1 - dirX + dirY, y1 - dirY - dirX, zz1, 0L, 0L, 0L, 0L, 0L, 1L}, {x2 + dirX + dirY, y2 + dirY - dirX, zz2, 0L, 0L, 0L, 0L, 0L, 1L}, {x2 + dirX - dirY, y2 + dirY + dirX, zz2, 0L, 0L, 0L, 0L, 0L, 1L}}, 4, xmin, xmax - 1L, ymin, ymax - 1L);
    }

    public void setWindow(int xmin, int xmax, int ymin, int ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public void setSize(double width, double height) {
        this.wh = (int)width * 16384 / 2;
        this.hh = (int)height * 16384 / 2;
        this.mh = Math.min(this.wh, this.hh);
    }
}

