/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.soft.ModularDoublePolygonRasterizer;
import java.util.Arrays;

public class DoubleRasterizer
extends ModularDoublePolygonRasterizer {
    protected double[] zBuffer;
    private int w = 0;
    private int h = 0;
    private byte[] pixelsR;
    private byte backgroundB;
    private byte backgroundG;
    private byte backgroundR;

    public DoubleRasterizer(byte[] pixelBuffer) {
        this.pixelsR = pixelBuffer;
    }

    protected final void setPixel(int x, int y) {
        int pos = x + this.w * y;
        if (this.apsz > this.zBuffer[pos]) {
            return;
        }
        int tpos = 3 * pos;
        if (this.transparency == 0.0) {
            this.pixelsR[tpos++] = (byte)this.apr;
            this.pixelsR[tpos++] = (byte)this.apg;
            this.pixelsR[tpos] = (byte)this.apb;
            this.zBuffer[pos] = this.apsz;
        } else {
            this.pixelsR[tpos] = (byte)((double)(0xFF & this.pixelsR[tpos++]) * this.transparency + this.apr);
            this.pixelsR[tpos] = (byte)((double)(0xFF & this.pixelsR[tpos++]) * this.transparency + this.apg);
            this.pixelsR[tpos] = (byte)((double)(0xFF & this.pixelsR[tpos++]) * this.transparency + this.apb);
        }
    }

    protected final void setPixel(int x, int y, double z, double red, double green, double blue, double transparency) {
        int pos = x + this.w * y;
        if (z > this.zBuffer[pos]) {
            return;
        }
        int tpos = 3 * pos;
        if (transparency == 0.0) {
            this.pixelsR[tpos] = (byte)red;
            this.pixelsR[tpos + 1] = (byte)green;
            this.pixelsR[tpos + 2] = (byte)blue;
        } else {
            this.pixelsR[tpos] = (byte)((double)(0xFF & this.pixelsR[tpos]) * transparency + red);
            this.pixelsR[tpos + 1] = (byte)((double)(0xFF & this.pixelsR[tpos + 1]) * transparency + green);
            this.pixelsR[tpos + 2] = (byte)((double)(0xFF & this.pixelsR[tpos + 2]) * transparency + blue);
        }
        this.zBuffer[pos] = z;
    }

    public void setBackground(int argb) {
        this.backgroundB = (byte)argb;
        this.backgroundG = (byte)(argb >> 8);
        this.backgroundR = (byte)(argb >> 16);
    }

    public void clear() {
        int imv = Integer.MAX_VALUE;
        Arrays.fill(this.zBuffer, (double)imv);
        for (int i = 0; i < this.pixelsR.length; i += 3) {
            this.pixelsR[i] = this.backgroundR;
            this.pixelsR[i + 1] = this.backgroundG;
            this.pixelsR[i + 2] = this.backgroundB;
        }
    }

    public void setWindow(int xmin, int xmax, int ymin, int ymax) {
        super.setWindow(xmin, xmax, ymin, ymax);
        int nw = xmax - xmin;
        int nh = ymax - ymin;
        if (nw != this.w || nh != this.h) {
            this.w = nw;
            this.h = nh;
            int numPx = this.w * this.h;
            this.zBuffer = new double[numPx];
        }
    }

    public void start() {
    }

    public void stop() {
    }
}

