/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.soft.Renderer;
import de.jreality.util.LoggingSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Level;

public class DefaultViewer
extends Component
implements Runnable,
Viewer {
    private static final boolean ENFORCE_PAINT_ON_MOUSEEVENTS = false;
    private final Object renderLock = new Object();
    private SceneGraphPath cameraPath;
    private SceneGraphComponent root;
    private transient BufferedImage offscreen;
    private Renderer renderer;
    private boolean upToDate = false;
    private boolean backgroundExplicitlySet;
    private boolean imageValid;
    private boolean useDouble;
    private boolean useFloat;
    private Image bgImage;
    private final Object renderFinishLock = new Object();
    private final Object renderSynch = new Object();
    private boolean synchRendering;
    private boolean disposed;

    public DefaultViewer(int type) {
        switch (type) {
            case 0: {
                this.useDouble = false;
                this.useFloat = false;
                break;
            }
            case 1: {
                this.useFloat = true;
                this.useDouble = false;
                break;
            }
            case 2: {
                this.useFloat = false;
                this.useDouble = true;
                break;
            }
        }
        this.setBackground(Color.white);
        Thread renderThread = new Thread((Runnable)this, "jReality render thread");
        renderThread.start();
    }

    public DefaultViewer() {
        this(0);
    }

    public DefaultViewer(boolean useDouble) {
        this(useDouble ? 2 : 0);
    }

    public boolean isFocusable() {
        return true;
    }

    public Object getViewingComponent() {
        return this;
    }

    public void setSceneRoot(SceneGraphComponent c) {
        this.root = c;
        if (this.renderer != null) {
            this.renderer.setSceneRoot(c);
        }
    }

    public SceneGraphComponent getSceneRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() {
        Object object = this.renderLock;
        synchronized (object) {
            if (EventQueue.isDispatchThread() && this.synchRendering) {
                return;
            }
        }
        object = this.renderSynch;
        synchronized (object) {
            Object object2 = this.renderFinishLock;
            synchronized (object2) {
                Object object3 = this.renderLock;
                synchronized (object3) {
                    this.synchRendering = true;
                    if (this.upToDate) {
                        this.upToDate = false;
                        this.renderLock.notify();
                    }
                }
                while (this.synchRendering) {
                    try {
                        this.renderFinishLock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new Error();
                    }
                }
                if (EventQueue.isDispatchThread()) {
                    this.run();
                } else {
                    try {
                        EventQueue.invokeAndWait(this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void invalidate() {
        super.invalidate();
        this.imageValid = false;
        this.upToDate = false;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (!this.isShowing()) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        if (clip != null && clip.isEmpty()) {
            return;
        }
        DefaultViewer defaultViewer = this;
        synchronized (defaultViewer) {
            if (this.imageValid) {
                if (this.offscreen != null) {
                    if (this.bgImage != null) {
                        g.drawImage(this.bgImage, 0, 0, Color.GREEN, null);
                    }
                    g.drawImage(this.offscreen, 0, 0, null);
                    return;
                }
                System.err.println("paint: no offscreen in paint");
            } else if (!this.upToDate) {
                Object object = this.renderLock;
                synchronized (object) {
                    this.renderLock.notify();
                }
            }
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!EventQueue.isDispatchThread()) {
            while (true) {
                try {
                    Object object;
                    while (true) {
                        object = this.renderLock;
                        synchronized (object) {
                            while (this.upToDate) {
                                try {
                                    this.renderLock.wait();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                if (!this.disposed) continue;
                                return;
                            }
                            this.upToDate = true;
                        }
                        this.renderImpl();
                        if (this.synchRendering) break;
                        if (!this.imageValid) continue;
                        EventQueue.invokeLater(this);
                    }
                    object = this.renderLock;
                    synchronized (object) {
                        this.synchRendering = false;
                        Object e = this.renderFinishLock;
                        synchronized (e) {
                            this.renderFinishLock.notify();
                        }
                    }
                }
                catch (Exception ex) {
                    Thread t = Thread.currentThread();
                    t.getThreadGroup().uncaughtException(t, ex);
                    continue;
                }
                break;
            }
        }
        this.paintImmediately();
    }

    public final synchronized void renderSync() {
        this.renderImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void renderImpl() {
        Dimension d = this.getSize();
        if (d.width > 0 && d.height > 0) {
            Color c;
            if (this.offscreen == null || this.offscreen.getWidth() != d.width || this.offscreen.getHeight() != d.height) {
                this.imageValid = false;
                if (this.useDouble) {
                    this.offscreen = new BufferedImage(d.width, d.height, 2);
                    this.renderer = new Renderer.IntArrayDouble(this.offscreen);
                } else if (this.useFloat) {
                    this.offscreen = new BufferedImage(d.width, d.height, 2);
                    this.renderer = new Renderer.IntArrayFloat(this.offscreen);
                } else {
                    this.offscreen = new BufferedImage(d.width, d.height, 2);
                    this.renderer = new Renderer.IntArray(this.offscreen);
                }
                c = this.getBackground();
                this.renderer.setBackgroundColor(c != null ? c.getRGB() : 0);
                this.renderer.setCameraPath(this.cameraPath);
                this.renderer.setSceneRoot(this.root);
            } else if (!this.backgroundExplicitlySet) {
                c = this.getBackground();
                this.renderer.setBackgroundColor(c != null ? c.getRGB() : 0);
            }
            try {
                this.renderer.render();
            }
            catch (Exception e) {
                LoggingSystem.getLogger(this).log(Level.SEVERE, "renderer.render() failed! ", e);
            }
            DefaultViewer defaultViewer = this;
            synchronized (defaultViewer) {
                this.renderer.update();
                this.imageValid = true;
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
    }

    public void addNotify() {
        super.addNotify();
        this.requestFocus();
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        switch (e.getID()) {
            case 500: 
            case 501: 
            case 502: {
                this.requestFocus();
            }
        }
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        boolean bl = this.backgroundExplicitlySet = c != null;
        if (this.backgroundExplicitlySet && this.renderer != null) {
            this.renderer.setBackgroundColor(c.getRGB());
        }
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private void paintImmediately() {
        if (!this.isShowing()) {
            return;
        }
        Component c = this;
        Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Container parent = c.getParent();
        while (parent != null && c.isLightweight()) {
            bounds.x += c.getX();
            bounds.y += c.getY();
            c = parent;
            parent = c.getParent();
        }
        Graphics gfx = c.getGraphics();
        gfx.setClip(bounds);
        c.paint(gfx);
    }

    public SceneGraphPath getCameraPath() {
        return this.cameraPath;
    }

    public void setCameraPath(SceneGraphPath p) {
        this.cameraPath = p;
    }

    public boolean hasViewingComponent() {
        return true;
    }

    public void initializeFrom(Viewer v) {
        this.setSceneRoot(v.getSceneRoot());
        this.setCameraPath(v.getCameraPath());
    }

    public int getMetric() {
        return 0;
    }

    public void setMetric(int sig) {
    }

    public void setAuxiliaryRoot(SceneGraphComponent ar) {
        throw new UnsupportedOperationException("not implemented");
    }

    public SceneGraphComponent getAuxiliaryRoot() {
        throw new UnsupportedOperationException("not implemented");
    }

    public Image getBackgroundImage() {
        return this.bgImage;
    }

    public void setBackgroundImage(Image bgImage) {
        this.bgImage = bgImage;
    }

    public Dimension getViewingComponentSize() {
        return this.getSize();
    }

    public boolean canRenderAsync() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAsync() {
        Object object = this.renderLock;
        synchronized (object) {
            if (this.upToDate) {
                this.upToDate = false;
                this.renderLock.notify();
                Thread.yield();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.renderLock;
        synchronized (object) {
            this.disposed = true;
            this.renderLock.notify();
        }
    }
}

