/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.scene.Geometry;
import de.jreality.scene.PointSet;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.shader.CommonAttributes;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.soft.DirectionalLightSoft;
import de.jreality.soft.Environment;
import de.jreality.soft.SpotLightSoft;
import de.jreality.soft.VertexShader;
import java.awt.Color;

public class DefaultVertexShader
implements VertexShader {
    private boolean vertexColors;
    private boolean interpolateAlpha;
    private double phongSize = 8.0;
    private double phong = 0.7;
    private double red = 0.4;
    private double green = 0.4;
    private double blue = 0.6;
    private double transparency = 0.0;

    public DefaultVertexShader() {
    }

    public DefaultVertexShader(double[] color, double phong, double phongSize, double transparency) {
        this.red = color[0];
        this.green = color[1];
        this.blue = color[2];
        this.phong = phong;
        this.phongSize = phongSize;
        this.transparency = transparency;
    }

    public final void shadeVertex(double[] vd, int pos, Environment environment) {
        double a;
        double nx = vd[pos + 10];
        double ny = vd[pos + 11];
        double nz = vd[pos + 12];
        double px = vd[pos + 0];
        double py = vd[pos + 1];
        double pz = vd[pos + 2];
        double cdr = 0.0;
        double cdg = 0.0;
        double cdb = 0.0;
        double csr = 0.0;
        double csg = 0.0;
        double csb = 0.0;
        double normalflip = px * nx + py * ny + pz * nz <= 0.0 ? 1.0 : -1.0;
        int dirLightCount = environment.getNumDirectionalLights();
        DirectionalLightSoft[] directionalLights = environment.getDirectionalLights();
        for (int i = 0; i < dirLightCount; ++i) {
            DirectionalLightSoft light = directionalLights[i];
            double[] dl = light.direction;
            double lx = dl[0];
            double ly = dl[1];
            double lz = dl[2];
            double lr = light.red;
            double lg = light.green;
            double lb = light.blue;
            double intensity = light.intensity;
            double ntl = nx * lx + ny * ly + nz * lz;
            double fac = normalflip * ntl;
            if (fac < 0.0) continue;
            cdr += lr * (fac *= intensity);
            cdg += lg * fac;
            cdb += lb * fac;
            double t = 2.0 * ntl * nz - lz;
            if (!(t > 0.0)) continue;
            t = intensity * Math.pow(t, this.phongSize);
            csr += lr * t;
            csg += lg * t;
            csb += lb * t;
        }
        int spotLightCount = environment.getNumSpotLights();
        SpotLightSoft[] spotlights = environment.getSpotLights();
        for (int i = 0; i < spotLightCount; ++i) {
            double ntl;
            double fac;
            double cosCone;
            double dst;
            double cosAngle;
            SpotLightSoft light = spotlights[i];
            double[] dl = light.direction;
            double dx = dl[0];
            double dy = dl[1];
            double dz = dl[2];
            double[] src = light.source;
            double lx = src[0] - px;
            double ly = src[1] - py;
            double lz = src[2] - pz;
            if ((cosAngle = (lx /= (dst = Math.sqrt(lx * lx + ly * ly + lz * lz))) * dx + (ly /= dst) * dy + (lz /= dst) * dz) < (cosCone = light.cosConeAngle)) continue;
            double lr = light.red;
            double lg = light.green;
            double lb = light.blue;
            double intensity = 1.0 * light.intensity / (light.a0 + (light.a1 + light.a2 * dst) * dst);
            double softFrac = light.softEdgeFraction;
            if (cosAngle - cosCone < softFrac) {
                intensity *= (cosAngle - cosCone) / softFrac;
            }
            if ((fac = normalflip * (ntl = nx * lx + ny * ly + nz * lz)) < 0.0) continue;
            cdr += lr * (fac *= intensity);
            cdg += lg * fac;
            cdb += lb * fac;
            double t = 2.0 * ntl * nz - lz;
            if (!(t > 0.0)) continue;
            t = intensity * Math.pow(t, this.phongSize);
            csr += lr * t;
            csg += lg * t;
            csb += lb * t;
        }
        if (this.vertexColors) {
            cdr *= vd[pos + 4];
            cdg *= vd[pos + 5];
            cdb *= vd[pos + 6];
            a = vd[pos + 7];
        } else {
            cdr *= this.red;
            cdg *= this.green;
            cdb *= this.blue;
            a = this.transparency;
        }
        vd[pos + 4] = cdr += this.phong * csr;
        vd[pos + 5] = cdg += this.phong * csg;
        vd[pos + 6] = cdb += this.phong * csb;
        vd[pos + 7] = a;
    }

    public final double getTransparency() {
        return this.transparency;
    }

    public final void setTransparency(double transparency) {
        this.transparency = transparency;
    }

    public boolean interpolateAlpha() {
        return this.interpolateAlpha;
    }

    public void setup(EffectiveAppearance eAppearance, String name) {
        this.transparency = eAppearance.getAttribute(ShaderUtility.nameSpace(name, "transparency"), this.transparency);
        Color c = (Color)eAppearance.getAttribute(ShaderUtility.nameSpace(name, "diffuseColor"), CommonAttributes.DIFFUSE_COLOR_DEFAULT);
        float[] rgb = c.getComponents(null);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
        this.phong = eAppearance.getAttribute(ShaderUtility.nameSpace(name, "specularCoefficient"), 0.7);
        this.phongSize = eAppearance.getAttribute(ShaderUtility.nameSpace(name, "specularExponent"), 60.0);
    }

    public void startGeometry(Geometry geom) {
        DataList colors = null;
        this.vertexColors = geom instanceof PointSet && (colors = ((PointSet)geom).getVertexAttributes(Attribute.COLORS)) != null;
        this.interpolateAlpha = this.vertexColors && colors.getStorageModel().getDimensions()[1] != 3;
    }
}

