/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.shader;

import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class EffectiveAppearance {
    private EffectiveAppearance parentApp;
    private Appearance app;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        EffectiveAppearance pea = this;
        do {
            sb.append(pea.app.getName() + ":");
        } while ((pea = pea.parentApp) != null);
        return sb.toString();
    }

    private EffectiveAppearance(EffectiveAppearance parent, Appearance app) {
        this.parentApp = parent;
        this.app = app;
    }

    public static EffectiveAppearance create() {
        return new EffectiveAppearance(null, new Appearance());
    }

    public static EffectiveAppearance create(SceneGraphPath p) {
        EffectiveAppearance eap = EffectiveAppearance.create();
        ListIterator<SceneGraphNode> i = p.iterator();
        while (i.hasNext()) {
            SceneGraphComponent sgc;
            Appearance app;
            SceneGraphNode n = (SceneGraphNode)i.next();
            if (!(n instanceof SceneGraphComponent) || (app = (sgc = (SceneGraphComponent)n).getAppearance()) == null) continue;
            eap = eap.create(app);
        }
        return eap;
    }

    public EffectiveAppearance create(Appearance app) {
        return new EffectiveAppearance(this, app);
    }

    public Object getAttribute(String key, Object defaultValue) {
        return this.getAttribute(key, defaultValue, defaultValue.getClass());
    }

    public Object getAttribute(String key, Object defaultValue, Class class1) {
        int lastDot = key.lastIndexOf(46);
        String lastKeyPart = key.substring(lastDot + 1);
        int dot = lastDot;
        while (dot != -1) {
            String localKey = key.substring(0, dot + 1) + lastKeyPart;
            Object value = this.getAttribute1(localKey, defaultValue, class1);
            if (value != Appearance.INHERITED) {
                return value;
            }
            dot = key.lastIndexOf(46, dot - 1);
        }
        Object value = this.getAttribute1(lastKeyPart, defaultValue, class1);
        if (value == Appearance.INHERITED) {
            value = defaultValue;
        }
        return value;
    }

    private Object getAttribute1(String key, Object defaultValue, Class class1) {
        Object value = this.app.getAttribute(key, class1);
        if (value == Appearance.DEFAULT) {
            return defaultValue;
        }
        if (value != Appearance.INHERITED) {
            return value;
        }
        return this.parentApp == null ? Appearance.INHERITED : this.parentApp.getAttribute1(key, defaultValue, class1);
    }

    public double getAttribute(String key, double value) {
        return (Double)this.getAttribute(key, new Double(value));
    }

    public float getAttribute(String key, float value) {
        return ((Float)this.getAttribute(key, new Float(value))).floatValue();
    }

    public int getAttribute(String key, int value) {
        return (Integer)this.getAttribute(key, new Integer(value));
    }

    public long getAttribute(String key, long value) {
        return (Long)this.getAttribute(key, new Long(value));
    }

    public boolean getAttribute(String key, boolean value) {
        return (Boolean)this.getAttribute(key, (Object)value);
    }

    public char getAttribute(String key, char value) {
        return ((Character)this.getAttribute(key, new Character(value))).charValue();
    }

    public static boolean matches(EffectiveAppearance eap, SceneGraphPath p) {
        EffectiveAppearance ea = eap;
        Iterator<SceneGraphNode> li = p.reverseIterator();
        while (li.hasNext()) {
            SceneGraphComponent sgc;
            Appearance app;
            SceneGraphNode n = li.next();
            if (!(n instanceof SceneGraphComponent) || (app = (sgc = (SceneGraphComponent)n).getAppearance()) == null) continue;
            if (ea.app != app) {
                return false;
            }
            ea = ea.parentApp;
        }
        assert (ea != null);
        return ea.parentApp == null;
    }

    public List getAppearanceHierarchy() {
        Vector<Appearance> v = new Vector<Appearance>();
        EffectiveAppearance pa = this;
        if (pa.app != null) {
            v.add(pa.app);
        }
        while ((pa = pa.parentApp) != null) {
            if (pa.app == null) continue;
            v.add(pa.app);
        }
        return v;
    }
}

