/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.pick;

import de.jreality.math.Rn;
import de.jreality.scene.Camera;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.util.CameraUtility;
import java.awt.Component;

public class Graphics3D {
    double aspectRatio = 1.0;
    SceneGraphComponent theRoot;
    SceneGraphPath cameraPath;
    Camera camera;
    double[] objectToWorld;
    boolean fastAndDirty = false;
    SceneGraphPath currentPath;

    public Graphics3D(Viewer v) {
        this(v, null);
    }

    public Graphics3D(Viewer v, SceneGraphPath sgp) {
        this(v.getCameraPath(), sgp, CameraUtility.getAspectRatio(v));
    }

    public Graphics3D(SceneGraphPath cp, SceneGraphPath sgp, double ar) {
        if (sgp != null && sgp.getLength() > 0) {
            this.setRoot((SceneGraphComponent)sgp.getFirstElement());
        }
        this.setCameraPath(cp);
        this.setCurrentPath(sgp);
        this.setAspectRatio(ar);
    }

    public void setAspectRatio(double ar) {
        this.aspectRatio = ar;
    }

    private void setCameraPath(SceneGraphPath cameraPath2) {
        this.cameraPath = cameraPath2;
        if (this.cameraPath == null) {
            return;
        }
        SceneGraphNode obj = this.cameraPath.getLastElement();
        if (obj == null || !(obj instanceof Camera)) {
            throw new IllegalArgumentException("Not a camera path");
        }
        this.camera = (Camera)this.cameraPath.getLastElement();
    }

    private void setRoot(SceneGraphComponent sceneRoot) {
        if (sceneRoot == null) {
            throw new IllegalArgumentException("Root can't be null");
        }
        this.theRoot = sceneRoot;
    }

    public SceneGraphPath getCameraPath() {
        return this.cameraPath;
    }

    public SceneGraphComponent getRoot() {
        return this.theRoot;
    }

    public double[] getCameraToNDC() {
        if (this.cameraPath == null) {
            throw new IllegalStateException("No camera path set for this context");
        }
        return CameraUtility.getCameraToNDC(this.camera, this.aspectRatio);
    }

    public double[] getObjectToWorld() {
        if (this.objectToWorld != null) {
            return this.objectToWorld;
        }
        if (this.currentPath != null) {
            return this.currentPath.getMatrix(null);
        }
        return Rn.identityMatrix(4);
    }

    public double[] getWorldToObject() {
        return Rn.inverse(null, this.getObjectToWorld());
    }

    public double[] getWorldToCamera() {
        if (this.cameraPath == null) {
            throw new IllegalStateException("No camera path");
        }
        return this.cameraPath.getInverseMatrix(null);
    }

    public double[] getCameraToWorld() {
        if (this.cameraPath == null) {
            throw new IllegalStateException("No camera path");
        }
        return this.cameraPath.getMatrix(null);
    }

    public double[] getWorldToNDC() {
        return Rn.times(null, this.getCameraToNDC(), this.getWorldToCamera());
    }

    public void setObjectToWorld(double[] ds) {
        this.objectToWorld = (double[])ds.clone();
    }

    public double[] getObjectToCamera() {
        return Rn.times(null, this.getWorldToCamera(), this.getObjectToWorld());
    }

    public double[] getCameraToObject() {
        return Rn.inverse(null, this.getObjectToCamera());
    }

    public double[] getObjectToNDC() {
        if (this.camera == null) {
            throw new IllegalStateException("No camera for this context");
        }
        return Rn.times(null, CameraUtility.getCameraToNDC(this.camera, this.aspectRatio), this.getObjectToCamera());
    }

    public double[] getNDCToObject() {
        if (this.camera == null) {
            throw new IllegalStateException("No camera for this context");
        }
        return Rn.inverse(null, Rn.times(null, CameraUtility.getCameraToNDC(this.camera, this.aspectRatio), this.getObjectToCamera()));
    }

    public double[] getObjectToScreen(Component dr) {
        return Rn.times(null, Graphics3D.getNDCToScreen(dr), this.getObjectToNDC());
    }

    public static double[] getNDCToScreen(Component dr) {
        double[] NDCToScreen = Rn.identityMatrix(4);
        NDCToScreen[0] = 0.5 * (double)dr.getWidth();
        NDCToScreen[5] = 0.5 * (double)dr.getHeight();
        NDCToScreen[3] = 0.5 * (double)dr.getWidth();
        NDCToScreen[7] = 0.5 * (double)dr.getHeight();
        return NDCToScreen;
    }

    public SceneGraphPath getCurrentPath() {
        return this.currentPath;
    }

    public void setCurrentPath(SceneGraphPath path) {
        this.currentPath = path;
    }

    public double[] getNDCToWorld() {
        return Rn.inverse(null, this.getWorldToNDC());
    }
}

