/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.event;

import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.event.SceneEvent;

public class SceneGraphComponentEvent
extends SceneEvent {
    public static final int CHILD_TYPE_APPEARANCE = 1;
    public static final int CHILD_TYPE_CAMERA = 2;
    public static final int CHILD_TYPE_COMPONENT = 3;
    public static final int CHILD_TYPE_GEOMETRY = 4;
    public static final int CHILD_TYPE_LIGHT = 5;
    public static final int CHILD_TYPE_TRANSFORMATION = 7;
    public static final int CHILD_TYPE_AUDIONODE = 9;
    public static final int CHILD_TYPE_NONE = 8;
    public static final int EVENT_TYPE_ADDED = 21;
    public static final int EVENT_TYPE_REMOVED = 22;
    public static final int EVENT_TYPE_REPLACED = 23;
    public static final int EVENT_TYPE_VISIBILITY_CHANGED = 24;
    public static final int EVENT_TYPE_PICKABILITY_CHANGED = 25;
    private final SceneGraphComponent component;
    private final SceneGraphNode oldChildElement;
    private final SceneGraphNode newChildElement;
    private final int childIndex;
    private final int childType;
    private final int eventType;

    public SceneGraphComponentEvent(SceneGraphComponent source, int evType, int childNodeType, SceneGraphNode oldChild, SceneGraphNode newChild, int index) {
        super(source);
        this.component = source;
        this.oldChildElement = oldChild;
        this.newChildElement = newChild;
        this.childIndex = index;
        switch (evType) {
            case 21: 
            case 22: 
            case 23: {
                this.eventType = evType;
                break;
            }
            default: {
                throw new IllegalArgumentException("evType " + evType);
            }
        }
        this.childType = this.nodeType(childNodeType);
    }

    public SceneGraphComponentEvent(SceneGraphComponent source, int childNodeType, SceneGraphNode oldChild, SceneGraphNode newChild) {
        super(source);
        this.component = source;
        this.oldChildElement = oldChild;
        this.newChildElement = newChild;
        this.childIndex = 0;
        this.eventType = oldChild == null ? 21 : (newChild == null ? 22 : 23);
        this.childType = this.nodeType(childNodeType);
    }

    public SceneGraphComponentEvent(SceneGraphComponent source, int type) {
        super(source);
        this.component = source;
        this.oldChildElement = null;
        this.newChildElement = null;
        this.childIndex = 0;
        this.eventType = type;
        this.childType = 8;
    }

    private int nodeType(int childNodeType) {
        switch (childNodeType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                return childNodeType;
            }
        }
        throw new IllegalArgumentException("childNodeType " + childNodeType);
    }

    public int getChildIndex() {
        return this.childIndex;
    }

    public SceneGraphComponent getSceneGraphComponent() {
        return this.component;
    }

    public int getChildType() {
        return this.childType;
    }

    public int getEventType() {
        return this.eventType;
    }

    public SceneGraphNode getNewChildElement() {
        return this.newChildElement;
    }

    public SceneGraphNode getOldChildElement() {
        return this.oldChildElement;
    }
}

