/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.DataList;
import de.jreality.scene.data.StorageModel;

public class StringArray
extends DataList {
    final transient String[] data;
    final transient int offset;
    final transient int length;

    public StringArray(String[] data) {
        this(data, 0, data.length);
    }

    public StringArray(String[] data, int offset, int length) {
        super(StorageModel.STRING_ARRAY, data, offset, length);
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public StringArray toStringArray() {
        return this;
    }

    public final String[] toStringArray(String[] target) {
        if (target == null) {
            target = new String[this.length];
        }
        int src = this.offset;
        int n = this.length;
        for (int dst = 0; dst < n; ++dst) {
            target[dst] = this.data[src];
            ++src;
        }
        return target;
    }

    public final String getValueAt(int n) {
        if (n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[n + this.offset];
    }

    public final int getLength() {
        return this.length;
    }
}

