/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StorageModel;
import de.jreality.scene.data.StringArray;
import de.jreality.scene.data.StringArrayArray;
import de.jreality.scene.data.WritableDataList;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public abstract class DataItem
extends AbstractList {
    static final boolean DEBUG_USAGE = false;
    final Object data;
    final int offset;
    static final HashMap USAGE = new HashMap();

    DataItem() {
        this.data = null;
        this.offset = 0;
    }

    public DataItem(Object source, int srcOffset) {
        this.data = source;
        this.offset = srcOffset;
    }

    public abstract StorageModel getStorageModel();

    public IntArray toIntArray() {
        return this.getStorageModel().toIntArray(this);
    }

    public IntArrayArray toIntArrayArray() {
        return this.getStorageModel().toIntArrayArray(this);
    }

    public DoubleArray toDoubleArray() {
        return this.getStorageModel().toDoubleArray(this);
    }

    public double[] toDoubleArray(double[] target) {
        return (double[])this.copyTo(StorageModel.DOUBLE_ARRAY, target);
    }

    public double[][] toDoubleArrayArray(double[][] target) {
        return (double[][])this.copyTo(StorageModel.DOUBLE_ARRAY.array(), target);
    }

    public int[] toIntArray(int[] target) {
        return (int[])this.copyTo(StorageModel.INT_ARRAY, target);
    }

    public int[][] toIntArrayArray(int[][] target) {
        return (int[][])this.copyTo(StorageModel.INT_ARRAY_ARRAY, target);
    }

    public StringArray toStringArray() {
        return this.getStorageModel().toStringArray(this);
    }

    public StringArrayArray toStringArrayArray() {
        return this.getStorageModel().toStringArrayArray(this);
    }

    public String[] toStringArray(String[] target) {
        return (String[])this.copyTo(StorageModel.STRING_ARRAY, target);
    }

    public String[][] toStringArrayArray(String[][] target) {
        return (String[][])this.copyTo(StorageModel.STRING_ARRAY_ARRAY, target);
    }

    public Object copyTo(StorageModel which, Object target) {
        return this.getStorageModel().copy((DataList)this, which, target);
    }

    public Object copyTo(WritableDataList target) {
        return this.getStorageModel().copy((DataList)this, target.getStorageModel(), target.getData(), target.size());
    }

    private final void notifyNewInstance() {
        Class<?> cl = this.getClass();
        int[] count = (int[])USAGE.get(cl);
        if (count == null) {
            count = new int[1];
            USAGE.put(cl, count);
        }
        count[0] = count[0] + 1;
    }

    public static void printUsage() {
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((Class)o1).getName();
                String s2 = ((Class)o2).getName();
                return s1.compareTo(s2);
            }
        };
        TreeMap ts = new TreeMap(c);
        ts.putAll(USAGE);
        for (Map.Entry e : ts.entrySet()) {
            Class cl = (Class)e.getKey();
            int v = ((int[])e.getValue())[0];
            String name = cl.getName();
            if (name.startsWith("de.jreality.scene.data.")) {
                name = name.substring("de.jreality.scene.data.".length());
            }
            name = name.replace('$', '.');
            System.out.println(name + ": " + v);
        }
    }
}

