/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.ByteBufferListSet;
import de.jreality.scene.data.ByteBufferStorage;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DataListSet;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StorageModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class ByteBufferList
extends DataList
implements Serializable {
    StorageModel coveredModel;
    int coveredLength;
    int entryLength = -1;
    int int_not_double = -1;
    public static LinkedList<ByteBufferList> usedDataLists = new LinkedList();

    ByteBufferList(ByteBuffer bb, int offset, int length) {
        super(ByteBufferStorage.MODEL, bb, offset, length);
    }

    public int getCoveredLength() {
        return this.coveredLength;
    }

    public void setCoveredLength(int coveredLength) {
        this.coveredLength = coveredLength;
    }

    public StorageModel getCoveredModel() {
        return this.coveredModel;
    }

    public void setCoveredModel(StorageModel coveredModel) {
        this.coveredModel = coveredModel;
    }

    public static void freeDataList(ByteBufferList wdl) {
        BufferPool.release((ByteBuffer)wdl.data);
    }

    public static ByteBufferList createByteBufferCopy(DataList dl) {
        int len = ByteBufferStorage.numBytes(dl.getStorageModel(), dl.data, dl.length);
        ByteBuffer bb = BufferPool.getBuffer(len);
        ByteBufferList wdl = new ByteBufferList(bb, 0, len);
        ByteBufferStorage.MODEL.copy(dl.format, dl.data, dl.offset, (Object)bb, 0, dl.length);
        wdl.setCoveredLength(dl.length);
        wdl.setCoveredModel(dl.getStorageModel());
        if (dl instanceof IntArrayArray) {
            wdl.setEntryLength(((IntArrayArray)dl).getLengthAt(0));
        }
        if (dl instanceof DoubleArrayArray) {
            wdl.setEntryLength(((DoubleArrayArray)dl).getLengthAt(0));
        }
        usedDataLists.add(wdl);
        return wdl;
    }

    public String toString() {
        return "ByteBufferList: " + this.data + " covered:" + this.getCoveredModel() + " length=" + this.getCoveredLength() + " entrySize=" + this.getEntryLength();
    }

    public int getEntryLength() {
        return this.entryLength;
    }

    public void setEntryLength(int entryLength) {
        this.entryLength = entryLength;
    }

    public Object createFittingDataObject() {
        if (this.getCoveredModel() == StorageModel.DOUBLE_ARRAY) {
            return new double[this.getCoveredLength()];
        }
        if (this.getCoveredModel() == StorageModel.INT_ARRAY) {
            return new int[this.getCoveredLength()];
        }
        if (this.getCoveredModel() instanceof StorageModel.DAA) {
            return new double[this.getCoveredLength()][this.getEntryLength()];
        }
        if (this.getCoveredModel() instanceof StorageModel.DAI) {
            return new double[this.getCoveredLength() * this.getEntryLength()];
        }
        if (this.getCoveredModel() instanceof StorageModel.IAA) {
            return new int[this.getCoveredLength()][this.getEntryLength()];
        }
        if (this.getCoveredModel() instanceof StorageModel.IAI) {
            return new int[this.getCoveredLength() * this.getEntryLength()];
        }
        throw new IllegalStateException("unsupported storage model: " + this.getCoveredModel());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getCoveredModel());
        out.writeInt(this.getCoveredLength());
        out.writeInt(this.getEntryLength());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object obj = ((IdentityHashMap)pendingIO.get()).get(this);
        ByteBufferList dl = (ByteBufferList)obj;
        dl.setCoveredModel((StorageModel)in.readObject());
        dl.setCoveredLength(in.readInt());
        dl.setEntryLength(in.readInt());
    }

    public static DataListSet prepareDataListSet(DataListSet attributes) {
        ByteBufferListSet ret = new ByteBufferListSet(attributes.getListLength());
        for (Attribute a : attributes.storedAttributes()) {
            DataList dl = attributes.getList(a);
            if (dl.getStorageModel() != ByteBufferStorage.MODEL && ByteBufferList.canCopy(dl)) {
                dl = ByteBufferList.createByteBufferCopy(dl);
            }
            ret.addReadOnlyList(a, dl);
        }
        return ret;
    }

    public static void releaseDataListSet(DataListSet attributes) {
        Iterator<Attribute> i = attributes.storedAttributes().iterator();
        while (i.hasNext()) {
            DataList dl = attributes.getList(i.next());
            if (!(dl instanceof ByteBufferList)) continue;
            ByteBufferList.freeDataList((ByteBufferList)dl);
        }
    }

    public static boolean canCopy(DataList dl) {
        try {
            ByteBufferStorage.numBytes(dl.getStorageModel(), dl.data, dl.length);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void releaseList(ByteBufferList copy) {
        BufferPool.release((ByteBuffer)copy.data);
    }

    public static final class BufferPool {
        static final LinkedList<ByteBuffer> free = new LinkedList();
        static final LinkedList<ByteBuffer> used = new LinkedList();
        static final boolean debug = false;

        private static void dumpUsage(String str) {
        }

        public static ByteBuffer getBuffer(int length) {
            Iterator i = free.iterator();
            while (i.hasNext()) {
                ByteBuffer bb = (ByteBuffer)i.next();
                if (bb.capacity() < length) continue;
                i.remove();
                used.add(bb);
                return (ByteBuffer)bb.position(0).limit(length);
            }
            ByteBuffer bb = ByteBuffer.allocateDirect(length);
            used.add(bb);
            BufferPool.dumpUsage("getBuffer");
            return bb;
        }

        public static void release(ByteBuffer bb) {
            bb.clear();
            used.remove(bb);
            free.add(bb);
            BufferPool.dumpUsage("release");
        }

        public static void releaseAll() {
            Iterator i = used.iterator();
            while (i.hasNext()) {
                ByteBuffer bb = (ByteBuffer)i.next();
                bb.clear();
                free.add(bb);
                i.remove();
            }
            BufferPool.dumpUsage("releaseAll");
        }
    }
}

