/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene;

import de.jreality.geometry.GeometryFactory;
import de.jreality.scene.SceneGraphNode;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;

public class Scene {
    private static final ThreadLocal ownedReadLocks = new ThreadLocal(){

        protected Object initialValue() {
            return new HashSet();
        }
    };
    private static final Comparator CANONICAL = new Comparator(){

        public int compare(Object o1, Object o2) {
            return System.identityHashCode(o1) - System.identityHashCode(o2);
        }
    };

    private Scene() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeReader(SceneGraphNode toRead, Runnable reader) {
        toRead.startReader();
        try {
            reader.run();
        }
        finally {
            toRead.finishReader();
        }
    }

    public static void executeReader(Collection toRead, Runnable reader) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeWriter(SceneGraphNode toWriteIn, Runnable writer) {
        toWriteIn.startWriter();
        try {
            writer.run();
        }
        finally {
            toWriteIn.finishWriter();
        }
    }

    public static void executeWriter(Collection toRead, Runnable writer) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateFactories(GeometryFactory ... factories) {
        for (GeometryFactory factory : factories) {
            factory.getGeometry().startWriter();
        }
        try {
            for (GeometryFactory factory : factories) {
                factory.update();
            }
        }
        finally {
            for (GeometryFactory factory : factories) {
                factory.getGeometry().finishWriter();
            }
        }
    }
}

