/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene;

import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.event.LightEvent;
import de.jreality.scene.event.LightEventMulticaster;
import de.jreality.scene.event.LightListener;
import java.awt.Color;

public abstract class Light
extends SceneGraphNode {
    private transient LightListener lightListener;
    private transient boolean lightChanged;
    private Color color = new Color(1.0f, 1.0f, 1.0f);
    private double intensity = 0.75;
    private boolean global = true;
    private boolean ambientFake;

    public Light(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getColor() {
        this.startReader();
        try {
            Color color = this.color;
            return color;
        }
        finally {
            this.finishReader();
        }
    }

    public void setColor(Color color) {
        this.startWriter();
        if (this.color != color) {
            this.fireLightChanged();
        }
        this.color = color;
        this.finishWriter();
    }

    public float[] getScaledColorAsFloat() {
        float[] cc = this.getColor().getRGBColorComponents(null);
        int i = 0;
        while (i < 3) {
            int n = i++;
            cc[n] = (float)((double)cc[n] * this.intensity);
        }
        return cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getIntensity() {
        this.startReader();
        try {
            double d = this.intensity;
            return d;
        }
        finally {
            this.finishReader();
        }
    }

    public void setIntensity(double intensity) {
        this.startWriter();
        if (this.intensity != intensity) {
            this.fireLightChanged();
        }
        this.intensity = intensity;
        this.finishWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGlobal() {
        this.startReader();
        try {
            boolean bl = this.global;
            return bl;
        }
        finally {
            this.finishReader();
        }
    }

    public void setGlobal(boolean global) {
        this.startWriter();
        if (this.global != global) {
            this.fireLightChanged();
        }
        this.global = global;
        this.finishWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAmbientFake() {
        this.startReader();
        try {
            boolean bl = this.ambientFake;
            return bl;
        }
        finally {
            this.finishReader();
        }
    }

    public void setAmbientFake(boolean b) {
        this.startWriter();
        if (this.ambientFake != b) {
            this.fireLightChanged();
        }
        this.ambientFake = b;
        this.finishWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(SceneGraphVisitor v) {
        this.startReader();
        try {
            v.visit(this);
        }
        finally {
            this.finishReader();
        }
    }

    static void superAccept(Light l, SceneGraphVisitor v) {
        l.superAccept(v);
    }

    private void superAccept(SceneGraphVisitor v) {
        super.accept(v);
    }

    public void addLightListener(LightListener listener) {
        this.startReader();
        this.lightListener = LightEventMulticaster.add(this.lightListener, listener);
        this.finishReader();
    }

    public void removeLightListener(LightListener listener) {
        this.startReader();
        this.lightListener = LightEventMulticaster.remove(this.lightListener, listener);
        this.finishReader();
    }

    protected void fireLightChanged() {
        this.lightChanged = true;
    }

    protected void fireLightChangedImpl() {
        if (this.lightListener != null) {
            this.lightListener.lightChanged(new LightEvent(this));
        }
    }

    protected void writingFinished() {
        if (this.lightChanged) {
            this.fireLightChangedImpl();
        }
        this.lightChanged = false;
    }
}

