/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene;

import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.data.AttributeEntity;
import de.jreality.scene.event.AppearanceEvent;
import de.jreality.scene.event.AppearanceEventMulticaster;
import de.jreality.scene.event.AppearanceListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Appearance
extends SceneGraphNode {
    public static final Object DEFAULT = new Object();
    public static final Object INHERITED = new Object();
    private transient AppearanceListener appearanceListener;
    private HashMap<String, Object> attributes = new HashMap();
    private Set<String> storedAttributes = Collections.unmodifiableSet(this.attributes.keySet());
    private transient HashMap<String, Object> changedAttributes = new HashMap();
    private static int UNNAMED_ID;

    public Appearance(String name) {
        super(name);
    }

    public Appearance() {
        super("app " + UNNAMED_ID++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String key) {
        this.startReader();
        try {
            Object aa = this.attributes.get(key);
            Object object = aa != null ? aa : INHERITED;
            return object;
        }
        finally {
            this.finishReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String key, Class type) {
        this.startReader();
        try {
            Object val = this.getAttribute(key);
            if (val == DEFAULT || type.isInstance(val)) {
                Object object = val;
                return object;
            }
            Object object = INHERITED;
            return object;
        }
        finally {
            this.finishReader();
        }
    }

    public void setAttribute(String key, Object value) {
        this.setAttribute(key, value, value.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String key, Object value, Class declaredType) {
        this.checkReadOnly();
        this.startWriter();
        try {
            Object old = null;
            if (declaredType == null || value == null) {
                throw new NullPointerException();
            }
            if (value == INHERITED) {
                old = this.attributes.remove(key);
            } else {
                if (AttributeEntity.class.isAssignableFrom(value.getClass())) {
                    throw new IllegalArgumentException("no proxies allowed");
                }
                old = this.attributes.put(key, value);
            }
            if (old != value) {
                this.fireAppearanceChanged(key, old);
            }
        }
        finally {
            this.finishWriter();
        }
    }

    public void setAttribute(String key, double value) {
        this.setAttribute(key, new Double(value));
    }

    public void setAttribute(String key, float value) {
        this.setAttribute(key, new Float(value));
    }

    public void setAttribute(String key, int value) {
        this.setAttribute(key, new Integer(value));
    }

    public void setAttribute(String key, long value) {
        this.setAttribute(key, new Long(value));
    }

    public void setAttribute(String key, boolean value) {
        this.setAttribute(key, (Object)value);
    }

    public void setAttribute(String key, char value) {
        this.setAttribute(key, new Character(value));
    }

    public void addAppearanceListener(AppearanceListener listener) {
        this.startReader();
        this.appearanceListener = AppearanceEventMulticaster.add(this.appearanceListener, listener);
        this.finishReader();
    }

    public void removeAppearanceListener(AppearanceListener listener) {
        this.startReader();
        this.appearanceListener = AppearanceEventMulticaster.remove(this.appearanceListener, listener);
        this.finishReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writingFinished() {
        try {
            for (Map.Entry<String, Object> e : this.changedAttributes.entrySet()) {
                this.appearanceListener.appearanceChanged(new AppearanceEvent(this, e.getKey(), e.getValue()));
            }
        }
        finally {
            this.changedAttributes.clear();
        }
    }

    protected void fireAppearanceChanged(String key, Object old) {
        if (this.appearanceListener != null) {
            this.changedAttributes.put(key, old);
        }
    }

    public Set getStoredAttributes() {
        return this.storedAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(SceneGraphVisitor v) {
        this.startReader();
        try {
            v.visit(this);
        }
        finally {
            this.finishReader();
        }
    }

    static void superAccept(Appearance a, SceneGraphVisitor v) {
        a.superAccept(v);
    }

    private void superAccept(SceneGraphVisitor v) {
        super.accept(v);
    }
}

