/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.renderman;

import de.jreality.renderman.RIBHelper;
import de.jreality.renderman.shader.RendermanShader;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public class Ri {
    public static final int BEZIER_BASIS = 0;
    public static final int BSPLINE_BASIS = 1;
    public static final int CATMULL_ROM_BASIS = 2;
    public static final int HERMITE_BASIS = 3;
    public static final int POWER_BASIS = 4;
    private PrintWriter w;
    private int lightCount;

    public void begin(String name) {
        try {
            this.w = new PrintWriter(new FileWriter(new File(name)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.lightCount = 0;
    }

    public void begin(File file) {
        try {
            this.w = new PrintWriter(new FileWriter(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.lightCount = 0;
    }

    public void end() {
        this.w.close();
    }

    public void verbatim(String s) {
        this.w.println(s);
    }

    public void comment(String s) {
        String[] ss = s.split("\\n");
        for (int i = 0; i < ss.length; ++i) {
            this.w.println("# " + ss[i]);
        }
    }

    public String quote(String s) {
        return "\"" + s + "\"";
    }

    public void declare(String name, String type) {
        this.w.println("Declare " + RIBHelper.str(name) + " " + RIBHelper.str(type));
    }

    public void option(String name, Map map) {
        this.w.print("Option " + RIBHelper.str(name) + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public void attribute(String name, Map map) {
        this.w.print("Attribute " + RIBHelper.str(name) + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public void display(String name, String type, String mode, Map map) {
        this.w.print("Display " + RIBHelper.str(name) + " " + RIBHelper.str(type) + " " + RIBHelper.str(mode) + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public void format(int xresolution, int yresolution, float pixelaspectratio) {
        this.w.println("Format " + xresolution + " " + yresolution + " " + pixelaspectratio);
    }

    public void shadingRate(float rate) {
        this.w.println("ShadingRate " + rate);
    }

    public void clipping(double near, double far) {
        this.w.println("Clipping " + near + " " + far);
    }

    public void depthOfField(double fstop, double flength, double fdistance) {
        if (fstop < 0.0) {
            return;
        }
        this.w.println("DepthOfField " + fstop + " " + flength + " " + fdistance);
    }

    public void screenWindow(Rectangle2D sw) {
        this.w.println("ScreenWindow [" + sw.getMinX() + " " + sw.getMaxX() + " " + sw.getMinY() + " " + sw.getMaxY() + "]");
    }

    public void projection(String name, Map map) {
        this.w.print("Projection " + RIBHelper.str(name) + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public int lightSource(String name, Map map) {
        ++this.lightCount;
        this.w.print("LightSource " + RIBHelper.str(name) + " " + this.lightCount + " ");
        RIBHelper.writeMap(this.w, map);
        return this.lightCount;
    }

    public void worldBegin() {
        this.w.println("WorldBegin");
    }

    public void worldEnd() {
        this.w.println("WorldEnd");
    }

    public void frameBegin(int n) {
        this.w.println("FrameBegin " + n);
    }

    public void frameEnd() {
        this.w.println("FrameEnd");
    }

    public void attributeBegin() {
        this.w.println("AttributeBegin");
    }

    public void attributeBegin(String name) {
        this.w.println("AttributeBegin # " + name);
    }

    public void attributeEnd() {
        this.w.println("AttributeEnd");
    }

    public void attributeEnd(String name) {
        this.w.println("AttributeEnd # " + name);
    }

    public void transformBegin() {
        this.w.println("TransformBegin");
    }

    public void transformEnd() {
        this.w.println("TransformEnd");
    }

    public void archiveBegin(String name) {
        this.w.println("ArchiveBegin " + RIBHelper.str(name));
    }

    public void archiveEnd() {
        this.w.println("ArchiveEnd");
    }

    public void readArchive(String foo) {
        this.w.println("ReadArchive " + RIBHelper.str(foo));
    }

    public void surface(String name, Map map) {
        this.w.print("Surface " + RIBHelper.str(name) + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public void displacement(String name, Map map) {
        this.w.print("Displacement " + RIBHelper.str(name) + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public void interior(String name, Map map) {
        this.w.print("Interior " + RIBHelper.str(name) + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public void exterior(String name, Map map) {
        this.w.print("Exterior " + RIBHelper.str(name) + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public void atmosphere(String name, Map map) {
        this.w.print("Atmosphere " + RIBHelper.str(name) + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public void imager(String name, Map map) {
        this.w.print("Imager " + RIBHelper.str(name) + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public void color(Color color) {
        float[] cc = color.getRGBComponents(null);
        this.color(cc[0], cc[1], cc[2]);
        if (cc.length == 4) {
            this.opacity(cc[3]);
        }
    }

    public void color(double[] color) {
        this.color((float)color[0], (float)color[1], (float)color[2]);
        if (color.length == 4) {
            this.opacity((float)color[3]);
        }
    }

    public void color(float r, float g, float b) {
        this.color(new float[]{r, g, b});
    }

    public void color(float[] color) {
        this.w.print("Color ");
        if (color.length == 3) {
            RIBHelper.writeObject(this.w, color);
        } else {
            RIBHelper.writeObject(this.w, new float[]{color[0], color[1], color[2]});
        }
        this.w.println("");
        if (color.length == 4) {
            this.opacity(color[3]);
        }
    }

    public void opacity(float[] color) {
        this.w.print("Opacity ");
        RIBHelper.writeObject(this.w, color);
        this.w.println("");
    }

    public void opacity(float color) {
        this.w.print("Opacity ");
        float[] opa = new float[]{color, color, color};
        RIBHelper.writeObject(this.w, opa);
        this.w.println("");
    }

    public void concatTransform(float[] transform) {
        this.w.print("ConcatTransform ");
        RIBHelper.writeObject(this.w, transform);
        this.w.println("");
    }

    public void transform(float[] transform) {
        this.w.print("Transform ");
        RIBHelper.writeObject(this.w, transform);
        this.w.println("");
    }

    public void identity() {
        this.w.println("Identity");
    }

    public void sphere(float radius, float zmin, float zmax, float thetamax, Map map) {
        this.w.print("Sphere " + radius + " " + zmin + " " + zmax + " " + thetamax + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public void cylinder(float radius, float zmin, float zmax, float thetamax, Map map) {
        this.w.print("Cylinder " + radius + " " + zmin + " " + zmax + " " + thetamax + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public void disk(float z, float radius, float thetamax, Map map) {
        this.w.print("Disk " + z + " " + radius + " " + thetamax + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public void clippingPlane(float x, float y, float z, float nx, float ny, float nz) {
        this.w.print("ClippingPlane " + x + " " + y + " " + z + " " + nx + " " + ny + " " + nz + "\n");
    }

    public void points(int npoints, Map map) {
        this.w.print("Points ");
        RIBHelper.writeMap(this.w, map);
    }

    public void pointsPolygons(int npolys, int[] nvertices, int[] vertices, Map map) {
        this.w.print("PointsPolygons ");
        RIBHelper.writeObject(this.w, nvertices);
        this.w.print(" ");
        RIBHelper.writeObject(this.w, vertices);
        this.w.print(" ");
        RIBHelper.writeMap(this.w, map);
    }

    public void patchMesh(String type, int nu, boolean uwrap, int nv, boolean vwrap, Map map) {
        this.w.print("PatchMesh " + this.quote(type) + " " + nu + " " + this.quote(uwrap ? "periodic" : "nonperiodic") + " " + nv + " " + this.quote(uwrap ? "periodic" : "nonperiodic"));
        map.remove("uniform normal N");
        RIBHelper.writeMap(this.w, map);
    }

    public void patch(String type, Map map) {
        this.w.print("Patch ");
        this.w.print(RIBHelper.str(type) + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public void curves(String type, int[] nvertices, String wrap, Map map) {
        this.w.print("Curves " + RIBHelper.str(type) + " ");
        RIBHelper.writeObject(this.w, nvertices);
        this.w.print(" " + RIBHelper.str(wrap) + " ");
        RIBHelper.writeMap(this.w, map);
    }

    public void basis(int ubasis, int ustep, int vbasis, int vstep) {
        this.w.print("Basis " + ubasis + " " + ustep + " " + vbasis + " " + vstep);
    }

    public void shader(RendermanShader sh) {
        this.w.print(sh.getType() + " " + RIBHelper.str(sh.getName()) + " ");
        RIBHelper.writeMap(this.w, sh.getAttributes());
    }
}

