/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.renderman;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashSet;

class RenderScript {
    private boolean display = true;
    private boolean execute = false;
    private boolean writeToFile = true;
    final File dir;
    final String ribFileName;
    final String texCmd;
    final String shaderCmd;
    final String refMapCmd;
    final String renderer;
    final String texSuffix;
    final String refMapSuffix;
    final int type;
    HashSet<String> ribFiles = new HashSet();
    HashSet<String> shaders = new HashSet();
    HashSet<String[]> textures = new HashSet();
    HashSet<String[]> reflectionMaps = new HashSet();

    protected RenderScript(File dir, String ribFileName, int type) {
        this.dir = dir;
        this.ribFileName = ribFileName;
        this.type = type;
        switch (type) {
            case 3: {
                this.texCmd = "teqser ";
                this.shaderCmd = "aqsl ";
                this.refMapCmd = "teqser -envcube ";
                this.renderer = "aqsis ";
                this.texSuffix = ".tex";
                this.refMapSuffix = ".env";
                break;
            }
            case 2: {
                this.texCmd = "tdlmake ";
                this.shaderCmd = "shaderdl ";
                this.refMapCmd = "tdlmake -envcube ";
                this.renderer = "renderdl ";
                this.texSuffix = ".tex";
                this.refMapSuffix = ".env";
                break;
            }
            case 4: {
                this.texCmd = "texmake ";
                this.shaderCmd = "sdrc ";
                this.refMapCmd = "texmake -envcube ";
                this.renderer = "rndr ";
                this.texSuffix = ".tex";
                this.refMapSuffix = ".env";
                break;
            }
            default: {
                this.texCmd = "txmake -resize 'up-' ";
                this.shaderCmd = "shader ";
                this.refMapCmd = "txmake -envcube ";
                this.renderer = "prman ";
                this.texSuffix = ".tex";
                this.refMapSuffix = ".env";
            }
        }
    }

    void addTexture(String tex, int smode, int tmode) {
        String repeatS = this.type == 3 ? "-swrap " : "-smode ";
        switch (smode) {
            case 10497: {
                repeatS = repeatS + "'periodic' ";
                break;
            }
            case 10496: {
                repeatS = repeatS + "'clamp' ";
                break;
            }
            case 33071: {
                repeatS = repeatS + "'clamp' ";
                break;
            }
            default: {
                repeatS = repeatS + "'periodic' ";
            }
        }
        String repeatT = this.type == 3 ? "-twrap " : "-tmode ";
        switch (tmode) {
            case 10497: {
                repeatT = repeatT + "'periodic' ";
                break;
            }
            case 10496: {
                repeatT = repeatT + "'clamp' ";
                break;
            }
            case 33071: {
                repeatT = repeatT + "'clamp' ";
                break;
            }
            default: {
                repeatT = repeatT + "'periodic' ";
            }
        }
        this.textures.add(new String[]{tex, repeatS, repeatT});
    }

    void addReflectionMap(String ... reflectionMap) {
        this.reflectionMaps.add(reflectionMap);
    }

    void addShader(String shader) {
        this.shaders.add(shader);
    }

    void addRibFile(String ribFile) {
        this.ribFiles.add(ribFile);
    }

    void finishScript() {
        String cmd;
        String script = "";
        String separator = "\n";
        for (String[] texName : this.textures) {
            cmd = this.texCmd + texName[1] + texName[2] + this.ribFileName + texName[0] + ".tiff " + this.ribFileName + texName[0] + this.texSuffix;
            script = script + "\n" + cmd;
            this.exec(cmd, true);
        }
        for (String shaderName : this.shaders) {
            cmd = this.shaderCmd + shaderName;
            script = script + "\n" + cmd;
            this.exec(cmd, true);
        }
        for (String[] refMap : this.reflectionMaps) {
            cmd = this.refMapCmd + refMap[1] + " " + refMap[2] + " " + refMap[3] + " " + refMap[4] + " " + refMap[5] + " " + refMap[6] + " " + this.ribFileName + refMap[0] + this.refMapSuffix;
            script = script + "\n" + cmd;
            this.exec(cmd, true);
        }
        cmd = this.renderer + this.ribFileName;
        if (this.display && this.type != 1 && this.type != 4) {
            cmd = this.renderer + "-d " + this.ribFileName + " &";
        }
        script = script + "\n" + cmd;
        this.exec(cmd, false);
        if (this.display && (this.type == 1 || this.type == 4)) {
            String fileName = this.ribFileName.substring(0, this.ribFileName.length() - 4);
            cmd = "display " + fileName + ".tif &";
            script = script + "\n" + cmd;
            this.exec(cmd, false);
        }
        if (this.writeToFile) {
            this.writeToFile(script);
        } else {
            this.dumpScript(script);
        }
    }

    private void writeToFile(String script) {
        String scriptName = this.ribFileName + "_renderScript.bat";
        try {
            FileWriter f1 = new FileWriter(this.dir.getAbsolutePath() + "/" + scriptName);
            BufferedWriter f2 = new BufferedWriter(f1);
            f2.write(script);
            f2.close();
            ((Writer)f1).close();
        }
        catch (IOException e) {
            System.err.println("can't write " + scriptName);
        }
    }

    private void dumpScript(String script) {
        System.out.println("========= render script ==========\n\n");
        System.out.println("cd " + this.dir.getAbsolutePath());
        System.out.println(script);
        System.out.println("\n\n========= render script ==========\n\n");
    }

    private void exec(String cmd, boolean wait) {
        if (!this.execute) {
            return;
        }
        ProcessBuilder pb = new ProcessBuilder(cmd.split(" "));
        pb.directory(this.dir);
        pb.redirectErrorStream(true);
        try {
            final Process proc = pb.start();
            Thread t = new Thread(new Runnable(){

                public void run() {
                    BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    String line = null;
                    try {
                        while ((line = br.readLine()) != null) {
                            System.out.println(line);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            t.start();
            if (wait) {
                proc.waitFor();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

