/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.renderman;

import de.jreality.renderman.RIBVisitor;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import java.awt.Dimension;

public class RIBViewer
implements Viewer {
    private SceneGraphPath cameraPath;
    private SceneGraphComponent sceneRoot;
    private int width = 100;
    private int height = 100;
    private String fileName = "test.rib";
    private int maximumEyeSplits = 10;
    private int rendererType = 1;
    public static final int TYPE_PIXAR = 1;
    public static final int TYPE_3DELIGHT = 2;
    public static final int TYPE_AQSIS = 3;
    public static final int TYPE_PIXIE = 4;

    public Object getViewingComponent() {
        return null;
    }

    public void setSceneRoot(SceneGraphComponent c) {
        this.sceneRoot = c;
    }

    public SceneGraphComponent getSceneRoot() {
        return this.sceneRoot;
    }

    public void render() {
        RIBVisitor rv = new RIBVisitor();
        rv.setRendererType(this.rendererType);
        rv.setWidth(this.width);
        rv.setHeight(this.height);
        rv.setMaximumEyeSplits(this.maximumEyeSplits);
        System.out.print(" Rendering renderman RIB into " + this.fileName + "..");
        rv.visit(this, this.fileName);
    }

    public SceneGraphPath getCameraPath() {
        return this.cameraPath;
    }

    public void setCameraPath(SceneGraphPath p) {
        this.cameraPath = p;
    }

    public boolean hasViewingComponent() {
        return false;
    }

    public void initializeFrom(Viewer v) {
        this.cameraPath = v.getCameraPath();
        this.sceneRoot = v.getSceneRoot();
        if (v.hasViewingComponent()) {
            this.setHeight((int)v.getViewingComponentSize().getHeight());
            this.setWidth((int)v.getViewingComponentSize().getWidth());
            System.out.println(" w " + v.getViewingComponentSize().getWidth() + " h " + v.getViewingComponentSize().getHeight());
        }
    }

    public int getMetric() {
        return 0;
    }

    public void setMetric(int sig) {
    }

    public void setAuxiliaryRoot(SceneGraphComponent ar) {
        throw new UnsupportedOperationException("not implemented");
    }

    public SceneGraphComponent getAuxiliaryRoot() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void setRendererType(int type) {
        this.rendererType = type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Dimension getViewingComponentSize() {
        return null;
    }

    public boolean canRenderAsync() {
        return false;
    }

    public void renderAsync() {
        throw new UnsupportedOperationException();
    }
}

