/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.renderman;

import de.jreality.backends.label.LabelUtility;
import de.jreality.geometry.Primitives;
import de.jreality.math.Matrix;
import de.jreality.math.Rn;
import de.jreality.renderman.RIBVisitor;
import de.jreality.renderman.shader.AbstractRendermanShader;
import de.jreality.renderman.shader.CustomPolygonShader;
import de.jreality.renderman.shader.DefaultPolygonShader;
import de.jreality.renderman.shader.RendermanShader;
import de.jreality.renderman.shader.SLShader;
import de.jreality.renderman.shader.TwoSidePolygonShader;
import de.jreality.scene.Appearance;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.AttributeCollection;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.shader.CubeMap;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ImageData;
import de.jreality.shader.LineShader;
import de.jreality.shader.PointShader;
import de.jreality.shader.PolygonShader;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.TextureUtility;
import de.jreality.util.ImageUtility;
import de.jreality.util.LoggingSystem;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.beans.Statement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;

public class RIBHelper {
    private static IndexedFaceSet bb = Primitives.texturedQuadrilateral(new double[]{0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0});

    public static RendermanShader processShader(AttributeCollection shader, RIBVisitor ribv, String name) {
        if (shader instanceof PolygonShader) {
            return RIBHelper.processPolygonShader((PolygonShader)shader, ribv, name);
        }
        if (shader instanceof LineShader) {
            return RIBHelper.processLineShader((LineShader)shader, ribv, name);
        }
        if (shader instanceof PointShader) {
            return RIBHelper.processPointShader((PointShader)shader, ribv, name);
        }
        return null;
    }

    private static RendermanShader processPolygonShader(PolygonShader ps, RIBVisitor ribv, String name) {
        AbstractRendermanShader rdps;
        PolygonShader dps;
        AbstractRendermanShader rs = null;
        Color Cs = null;
        double transparency = 0.0;
        if (ps instanceof de.jreality.shader.DefaultPolygonShader) {
            dps = (de.jreality.shader.DefaultPolygonShader)ps;
            rdps = new DefaultPolygonShader((de.jreality.shader.DefaultPolygonShader)dps);
            ((DefaultPolygonShader)rdps).setFromEffectiveAppearance(ribv, ribv.eAppearance, name);
            rs = rdps;
            Cs = dps.getDiffuseColor();
            transparency = dps.getTransparency();
            if (ribv.useOldTransparency) {
                double alpha = (double)Cs.getAlpha() / 255.0;
                transparency = (1.0 - alpha) * transparency;
            }
            ribv.cs = dps.getDiffuseColor();
            ribv.smooth = dps.getSmoothShading();
        } else if (ps instanceof de.jreality.shader.TwoSidePolygonShader) {
            dps = (de.jreality.shader.TwoSidePolygonShader)ps;
            rdps = new TwoSidePolygonShader((de.jreality.shader.TwoSidePolygonShader)dps);
            ((TwoSidePolygonShader)rdps).setFromEffectiveAppearance(ribv, ribv.eAppearance, name);
            rs = rdps;
            de.jreality.shader.DefaultPolygonShader dpss = (de.jreality.shader.DefaultPolygonShader)dps.getFront();
            Cs = dpss.getDiffuseColor();
            transparency = dpss.getTransparency();
            if (ribv.useOldTransparency) {
                double alpha = (double)Cs.getAlpha() / 255.0;
                transparency = (1.0 - alpha) * transparency;
            }
            ribv.cs = dpss.getDiffuseColor();
            ribv.smooth = dpss.getSmoothShading();
        } else {
            LoggingSystem.getLogger(ShaderUtility.class).warning("Unknown shader class " + ps.getClass());
        }
        SLShader orig = new SLShader("orig");
        Object foo = ribv.eAppearance.getAttribute(name + "." + "rendermanSurfaceShader", orig);
        if (foo != Appearance.DEFAULT && foo instanceof SLShader && foo != orig) {
            rs = new CustomPolygonShader();
            rs.setFromEffectiveAppearance(ribv, ribv.eAppearance, name);
        }
        float[] csos = RIBHelper.extractCsOs(Cs, (!ribv.handlingProxyGeometry || !ribv.opaqueTubes) && ribv.transparencyEnabled ? transparency : 0.0, ribv.useOldTransparency);
        ribv.ri.color(csos);
        ribv.ri.shader(rs);
        return rs;
    }

    private static RendermanShader processLineShader(LineShader ls, RIBVisitor ribv, String name) {
        CustomPolygonShader rs = null;
        Color Cs = null;
        double transparency = 0.0;
        if (ls instanceof DefaultLineShader) {
            DefaultLineShader dls = (DefaultLineShader)ls;
            ribv.drawTubes = dls.getTubeDraw();
            ribv.tubeRadius = new Float(dls.getTubeRadius()).floatValue();
            ribv.cs = dls.getDiffuseColor();
            if (dls.getTubeDraw().booleanValue()) {
                return RIBHelper.processPolygonShader(dls.getPolygonShader(), ribv, name + ".polygonShader");
            }
            Cs = dls.getDiffuseColor();
            Appearance slApp = new Appearance();
            SLShader sls = new SLShader("constant");
            slApp.setAttribute("lineShader.polygonShader", "free");
            slApp.setAttribute("lineShader.rendermanSurfaceShader", sls);
            EffectiveAppearance slEApp = EffectiveAppearance.create();
            slEApp = slEApp.create(slApp);
            rs = new CustomPolygonShader();
            rs.setFromEffectiveAppearance(ribv, slEApp, "lineShader");
        } else {
            LoggingSystem.getLogger(ShaderUtility.class).warning("Unknown shader class " + ls.getClass());
        }
        float[] csos = RIBHelper.extractCsOs(Cs, (!ribv.handlingProxyGeometry || !ribv.opaqueTubes) && ribv.transparencyEnabled ? transparency : 0.0, ribv.useOldTransparency);
        ribv.ri.color(csos);
        ribv.ri.shader(rs);
        return rs;
    }

    private static RendermanShader processPointShader(PointShader vs, RIBVisitor ribv, String name) {
        CustomPolygonShader rs = null;
        Color Cs = null;
        double transparency = 0.0;
        if (vs instanceof DefaultPointShader) {
            DefaultPointShader dvs = (DefaultPointShader)vs;
            ribv.drawSpheres = dvs.getSpheresDraw();
            double rad = dvs.getPointRadius();
            ribv.pointRadius = (float)rad;
            ribv.cs = dvs.getDiffuseColor();
            if (dvs.getSpheresDraw().booleanValue()) {
                return RIBHelper.processPolygonShader(dvs.getPolygonShader(), ribv, name + ".polygonShader");
            }
            Cs = dvs.getDiffuseColor();
            Appearance slApp = new Appearance();
            SLShader sls = new SLShader("constant");
            slApp.setAttribute("pointShader.polygonShader", "free");
            slApp.setAttribute("pointShader.rendermanSurfaceShader", sls);
            EffectiveAppearance slEApp = EffectiveAppearance.create();
            slEApp = slEApp.create(slApp);
            rs = new CustomPolygonShader();
            rs.setFromEffectiveAppearance(ribv, slEApp, "pointShader");
        } else {
            LoggingSystem.getLogger(ShaderUtility.class).warning("Unknown shader class " + vs.getClass());
        }
        float[] csos = RIBHelper.extractCsOs(Cs, (!ribv.handlingProxyGeometry || !ribv.opaqueTubes) && ribv.transparencyEnabled ? transparency : 0.0, ribv.useOldTransparency);
        ribv.ri.color(csos);
        ribv.ri.shader(rs);
        return rs;
    }

    protected static float[] extractCsOs(Color color, double transparency, boolean useOldTransparency) {
        float[] csos = new float[4];
        float colorAlpha = 1.0f;
        if (color != Appearance.INHERITED) {
            float[] c = color.getRGBComponents(null);
            if (c.length == 4) {
                colorAlpha = c[3];
            }
            csos[0] = c[0];
            csos[1] = c[1];
            csos[2] = c[2];
        }
        csos[3] = 1.0f - (float)transparency;
        if (useOldTransparency) {
            csos[3] = csos[3] * colorAlpha;
        }
        return csos;
    }

    public static void writeShader(String name, String shaderName) {
        try {
            File file = new File(name);
            LoggingSystem.getLogger(RIBHelper.class).fine("writing in  " + name);
            file = new File(file.getParent(), shaderName);
            LoggingSystem.getLogger(RIBHelper.class).fine("checking on " + file + " exists " + file.exists());
            if (!file.exists()) {
                FileOutputStream os = new FileOutputStream(file);
                InputStream is = DefaultPolygonShader.class.getResourceAsStream(shaderName);
                int c = 0;
                while ((c = is.read()) != -1) {
                    ((OutputStream)os).write(c);
                }
                ((OutputStream)os).close();
                is.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static float[] fTranspose(double[] mat) {
        float[] tmat = new float[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                tmat[i + 4 * j] = (float)mat[j + 4 * i];
            }
        }
        return tmat;
    }

    public static String str(String name) {
        return "\"" + name + "\"";
    }

    public static void writeMap(PrintWriter w2, Map map) {
        if (map != null) {
            Set keys = map.keySet();
            for (String element : keys) {
                w2.print("\"" + element + "\" ");
                RIBHelper.writeObject(w2, map.get(element));
            }
        }
        w2.println("");
    }

    public static void writeObject(PrintWriter w2, Object object) {
        if (object instanceof double[]) {
            object = Rn.convertDoubleToFloatArray((double[])object);
        }
        if (object instanceof float[]) {
            float[] f = (float[])object;
            w2.print("[");
            for (int i = 0; i < f.length; ++i) {
                w2.print(f[i] + " ");
            }
            w2.print("]");
            return;
        }
        if (object instanceof int[]) {
            int[] f = (int[])object;
            w2.print("[");
            for (int i = 0; i < f.length; ++i) {
                w2.print(f[i] + " ");
            }
            w2.print("]");
            return;
        }
        if (object instanceof Color) {
            w2.print("[");
            float[] rgb = ((Color)object).getRGBComponents(null);
            for (int i = 0; i < 3; ++i) {
                w2.print(rgb[i] + " ");
            }
            w2.print("]");
            return;
        }
        if (object instanceof String) {
            w2.print("\"" + object + "\"");
            return;
        }
        w2.print(" " + object + " ");
    }

    public static void writeTexture(ImageData data, String noSuffix) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByMIMEType("image/tiff");
        while (iter.hasNext()) {
            System.err.println("Writer: " + iter.next().getClass().getName());
        }
        BufferedImage img = ImageUtility.getValidBufferedImage(data);
        img.coerceData(true);
        boolean worked = true;
        try {
            Class<?> encParamClass = Class.forName("com.sun.media.jai.codec.TIFFEncodeParam");
            Object encodeParam = encParamClass.newInstance();
            Object compField = encParamClass.getField("COMPRESSION_DEFLATE").get(null);
            new Statement(encodeParam, "setCompression", new Object[]{compField}).execute();
            new Statement(encodeParam, "setDeflateLevel", new Object[]{9}).execute();
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(img);
            pb.add(new FileOutputStream(noSuffix + ".tiff"));
            pb.add("tiff");
            pb.add(encodeParam);
            new Statement(Class.forName("javax.media.jai.JAI"), "create", new Object[]{"encode", pb}).execute();
        }
        catch (Throwable e) {
            worked = false;
            LoggingSystem.getLogger(RIBVisitor.class).log(Level.CONFIG, "could not write TIFF: " + noSuffix + ".tiff", e);
        }
        if (!worked) {
            try {
                worked = ImageIO.write((RenderedImage)img, "PNG", new File(noSuffix + ".png"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!worked) {
                LoggingSystem.getLogger(RIBVisitor.class).log(Level.CONFIG, "could not write PNG: {0}.png", noSuffix);
            }
        }
    }

    public static void createRIBLabel(PointSet ps, DefaultTextShader ts, RIBVisitor ribv) {
        if (!ts.getShowLabels().booleanValue()) {
            return;
        }
        Font font = ts.getFont();
        Color c = ts.getDiffuseColor();
        double scale = ts.getScale();
        double[] offset = ts.getOffset();
        int alignment = ts.getAlignment();
        ImageData[] img = LabelUtility.createPointImages(ps, font, c);
        DoubleArrayArray coords = ps.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
        RIBHelper.writeLabel(ribv, img, coords, null, offset, alignment, scale);
    }

    public static void createRIBLabel(IndexedLineSet ils, DefaultTextShader ts, RIBVisitor ribv) {
        if (!ts.getShowLabels().booleanValue()) {
            return;
        }
        Font font = ts.getFont();
        Color c = ts.getDiffuseColor();
        double scale = ts.getScale();
        double[] offset = ts.getOffset();
        int alignment = ts.getAlignment();
        ImageData[] img = LabelUtility.createEdgeImages(ils, font, c);
        DoubleArrayArray coords = ils.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
        IntArrayArray inds = ils.getEdgeAttributes(Attribute.INDICES).toIntArrayArray();
        RIBHelper.writeLabel(ribv, img, coords, inds, offset, alignment, scale);
    }

    public static void createRIBLabel(IndexedFaceSet ifs, DefaultTextShader ts, RIBVisitor ribv) {
        if (!ts.getShowLabels().booleanValue()) {
            return;
        }
        Font font = ts.getFont();
        Color c = ts.getDiffuseColor();
        double scale = ts.getScale();
        double[] offset = ts.getOffset();
        int alignment = ts.getAlignment();
        ImageData[] img = LabelUtility.createFaceImages(ifs, font, c);
        DoubleArrayArray coords = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
        IntArrayArray inds = ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray();
        RIBHelper.writeLabel(ribv, img, coords, inds, offset, alignment, scale);
    }

    private static void writeLabel(RIBVisitor ribv, ImageData[] labels, DoubleArrayArray vertices, IntArrayArray indices, double[] offset, int alignment, double scale) {
        Matrix c2o = new Matrix(Rn.times(null, ribv.world2Camera, ribv.object2world.getMatrix(null))).getInverse();
        double[] bbm = new double[16];
        int n = labels.length;
        for (int i = 0; i < n; ++i) {
            ImageData img = labels[i];
            String labelName = new File(ribv.writeTexture(img, 10496, 10496)).getName();
            LabelUtility.calculateBillboardMatrix(bbm, (double)img.getWidth() * scale, (double)img.getHeight() * scale, offset, alignment, c2o.getArray(), LabelUtility.positionFor(i, vertices, indices), 0, 0);
            ribv.ri.transformBegin();
            ribv.ri.concatTransform(RIBHelper.fTranspose(bbm));
            HashMap<String, String> shaderMap = new HashMap<String, String>();
            shaderMap.put("string texturename", labelName);
            ribv.ri.surface("constantTexture", shaderMap);
            ribv.pointPolygon(bb, null);
            ribv.ri.transformEnd();
        }
    }

    public static Appearance shiftTubesAppearance(DefaultGeometryShader dgs) {
        Appearance ap = new Appearance();
        if (dgs.getLineShader() instanceof DefaultLineShader) {
            if (((DefaultLineShader)dgs.getLineShader()).getPolygonShader() instanceof de.jreality.shader.DefaultPolygonShader) {
                ap.setAttribute("polygonShader", de.jreality.shader.DefaultPolygonShader.class);
                de.jreality.shader.DefaultPolygonShader lsps = (de.jreality.shader.DefaultPolygonShader)((DefaultLineShader)dgs.getLineShader()).getPolygonShader();
                RIBHelper.evaluateShader(ap, lsps, "");
            } else if (((DefaultLineShader)dgs.getLineShader()).getPolygonShader() instanceof de.jreality.shader.TwoSidePolygonShader) {
                ap.setAttribute("polygonShader", de.jreality.shader.TwoSidePolygonShader.class);
                de.jreality.shader.DefaultPolygonShader lspsf = (de.jreality.shader.DefaultPolygonShader)((de.jreality.shader.TwoSidePolygonShader)((DefaultLineShader)dgs.getLineShader()).getPolygonShader()).getFront();
                de.jreality.shader.DefaultPolygonShader lspsb = (de.jreality.shader.DefaultPolygonShader)((de.jreality.shader.TwoSidePolygonShader)((DefaultLineShader)dgs.getLineShader()).getPolygonShader()).getBack();
                RIBHelper.evaluateShader(ap, lspsf, ".front");
                RIBHelper.evaluateShader(ap, lspsb, ".back");
            } else {
                LoggingSystem.getLogger(ShaderUtility.class).warning("the following instance of lineShader.polygonShader is not supported in RIBHelper.shiftTubesAppearance(DefaultGeometryShader):\n" + ((DefaultLineShader)dgs.getLineShader()).getPolygonShader());
            }
        } else {
            LoggingSystem.getLogger(ShaderUtility.class).warning("the following instance of lineShader is not supported in RIBHelper.shiftTubesAppearance(DefaultGeometryShader):\n" + dgs.getLineShader());
        }
        return ap;
    }

    private static Appearance evaluateShader(Appearance evalToApp, de.jreality.shader.DefaultPolygonShader shader, String side) {
        evalToApp.setAttribute("polygonShader" + side + ".diffuseColor", shader.getDiffuseColor());
        evalToApp.setAttribute("polygonShader" + side + ".ambientCoefficient", shader.getAmbientCoefficient());
        evalToApp.setAttribute("polygonShader" + side + ".ambientColor", shader.getAmbientColor());
        evalToApp.setAttribute("polygonShader" + side + ".diffuseCoefficient", shader.getDiffuseCoefficient());
        evalToApp.setAttribute("polygonShader" + side + ".specularCoefficient", shader.getSpecularCoefficient());
        evalToApp.setAttribute("polygonShader" + side + ".smoothShading", shader.getSmoothShading());
        evalToApp.setAttribute("polygonShader" + side + ".specularColor", shader.getSpecularColor());
        evalToApp.setAttribute("polygonShader" + side + ".specularExponent", shader.getSpecularExponent());
        evalToApp.setAttribute("polygonShader" + side + ".transparency", shader.getTransparency());
        if (shader.getTexture2d() == null) {
            evalToApp.setAttribute("polygonShader" + side + ".texture2d", Appearance.DEFAULT);
        } else {
            TextureUtility.createTexture(evalToApp, "polygonShader" + side, shader.getTexture2d().getImage(), false);
        }
        if (shader.getReflectionMap() == null) {
            evalToApp.setAttribute("polygonShader" + side + "." + "reflectionMap", Appearance.DEFAULT);
        } else {
            CubeMap lineCubeMap = TextureUtility.createReflectionMap(evalToApp, "polygonShader" + side, TextureUtility.getCubeMapImages(shader.getReflectionMap()));
            lineCubeMap.setBlendColor(shader.getReflectionMap().getBlendColor());
        }
        return evalToApp;
    }
}

