/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.renderman;

import de.jreality.math.Matrix;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.renderman.RIBHelper;
import de.jreality.renderman.RIBVisitor;
import de.jreality.renderman.Ri;
import de.jreality.scene.Appearance;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.Light;
import de.jreality.scene.PointLight;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.SpotLight;
import de.jreality.shader.EffectiveAppearance;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightCollector
extends SceneGraphVisitor {
    double[] initialTrafo;
    double[] currentTrafo;
    RIBVisitor ribv = null;
    float[] zdirection = new float[]{0.0f, 0.0f, -1.0f};
    float[] fCurrentTrafo = null;
    protected LightCollector reclaimableSubcontext;
    EffectiveAppearance eAppearance = null;
    boolean shadowEnabled = false;
    int metric = 0;
    SceneGraphPath currentPath = null;
    Ri ri = null;
    String lightname;
    private double[] dfrom;
    private double[] dto;

    public LightCollector(SceneGraphComponent root, RIBVisitor v) {
        this.ribv = v;
        this.ri = v.ri;
        this.currentTrafo = new double[16];
        this.eAppearance = EffectiveAppearance.create();
        this.currentPath = new SceneGraphPath();
        this.visit(root);
    }

    protected LightCollector(LightCollector parentContext) {
        this.initializeFromParentContext(parentContext);
    }

    LightCollector subContext() {
        if (this.reclaimableSubcontext != null) {
            this.reclaimableSubcontext.initializeFromParentContext(this);
            return this.reclaimableSubcontext;
        }
        this.reclaimableSubcontext = new LightCollector(this);
        return this.reclaimableSubcontext;
    }

    protected void initializeFromParentContext(LightCollector parentContext) {
        this.currentTrafo = parentContext.currentTrafo;
        this.ribv = parentContext.ribv;
    }

    @Override
    public void visit(SceneGraphComponent c) {
        EffectiveAppearance tmp = this.eAppearance;
        Appearance a = c.getAppearance();
        if (!c.isVisible()) {
            return;
        }
        if (a != null) {
            this.eAppearance = this.eAppearance.create(a);
        }
        this.currentPath.push(c);
        this.shadowEnabled = this.eAppearance.getAttribute("rendermanShadowsEnabled", false);
        this.metric = this.eAppearance.getAttribute("metric", 0);
        c.childrenAccept(this);
        this.eAppearance = tmp;
        this.currentPath.pop();
    }

    @Override
    public void visit(DirectionalLight l) {
        this.ri.transformBegin();
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.handleCommon(l, map);
        map.put("to", new float[]{(float)this.dto[0], (float)this.dto[1], (float)this.dto[2]});
        if (this.metric == 0) {
            this.lightname = this.shadowEnabled ? "shadowdistant" : "distantlight";
        }
        this.ri.lightSource(this.lightname, map);
        this.ri.transformEnd();
    }

    private void handleCommon(Light l, HashMap<String, Object> map) {
        this.currentPath.getMatrix(this.currentTrafo);
        Matrix mm = new Matrix(this.currentTrafo);
        mm.multiplyOnLeft(this.ribv.world2Camera);
        this.dfrom = mm.getColumn(3);
        Pn.dehomogenize(this.dfrom, this.dfrom);
        this.dto = mm.getColumn(2);
        Rn.times(this.dto, -1.0, this.dto);
        Pn.dehomogenize(this.dto, this.dto);
        this.fCurrentTrafo = RIBHelper.fTranspose(this.currentTrafo);
        map.put("intensity", new Float(l.getIntensity()));
        map.put("lightcolor", l.getColor().getRGBColorComponents(null));
        if (this.metric != 0) {
            map.put("signature", new Float(this.metric));
            this.lightname = "noneuclideanlight";
        } else if (this.shadowEnabled) {
            map.put("string shadowname", "raytrace");
        }
    }

    @Override
    public void visit(PointLight l) {
        this.ri.transformBegin();
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.handleCommon(l, map);
        map.put("from", new float[]{(float)this.dfrom[0], (float)this.dfrom[1], (float)this.dfrom[2]});
        if (this.metric == 0) {
            this.lightname = this.shadowEnabled ? "shadowpoint" : "pointlight";
        }
        this.ri.lightSource(this.lightname, map);
        this.ri.transformEnd();
    }

    @Override
    public void visit(SpotLight l) {
        this.ri.transformBegin();
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.handleCommon(l, map);
        map.put("from", new float[]{(float)this.dfrom[0], (float)this.dfrom[1], (float)this.dfrom[2]});
        map.put("to", new float[]{(float)this.dto[0], (float)this.dto[1], (float)this.dto[2]});
        map.put("coneangle", new Float(l.getConeAngle()));
        map.put("conedeltaangle", new Float(l.getConeDeltaAngle()));
        map.put("beamdistribution", new Float(l.getDistribution()));
        if (this.ribv.fullSpotLight) {
            map.put("float a0", new Float(l.getFalloffA0()));
            map.put("float a1", new Float(l.getFalloffA1()));
            map.put("float a2", new Float(l.getFalloffA2()));
            this.ri.lightSource("spotlightFalloff", map);
        } else if (this.metric == 0) {
            this.lightname = this.shadowEnabled ? "shadowspot" : "spotlight";
        }
        this.ri.lightSource(this.lightname, map);
        this.ri.transformEnd();
    }
}

