/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader.vrml;

import de.jreality.geometry.GeometryMergeFactory;
import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.geometry.Primitives;
import de.jreality.math.MatrixBuilder;
import de.jreality.reader.vrml.State;
import de.jreality.scene.Appearance;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DoubleArrayArray;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class VRMLHelper {
    public static boolean verbose = true;

    public static int[] listToIntArray(List l) {
        int[] foo = new int[l.size()];
        int count = 0;
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            foo[count++] = (Integer)iter.next();
        }
        return foo;
    }

    public static double[] listToDoubleArray(List l) {
        double[] foo = new double[l.size()];
        int count = 0;
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            foo[count++] = (Double)iter.next();
        }
        return foo;
    }

    public static double[][] listToDoubleArrayArray(List l) {
        double[][] foo = new double[l.size()][];
        int count = 0;
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            foo[count++] = (double[])iter.next();
        }
        return foo;
    }

    public static Color[] listToColorArray(List l) {
        Color[] foo = new Color[l.size()];
        int count = 0;
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            foo[count++] = (Color)iter.next();
        }
        return foo;
    }

    public static int[][] convertIndices(int[] input) {
        int count = 0;
        LinkedList<Integer> breakpoints = new LinkedList<Integer>();
        for (int i = 0; i < input.length; ++i) {
            if (input[i] >= 0) continue;
            breakpoints.add(new Integer(i));
        }
        count = breakpoints.size();
        int[][] output = new int[count][];
        int newIndex = -1;
        int faceCount = 0;
        for (Integer d : breakpoints) {
            int oldIndex = newIndex + 1;
            newIndex = d;
            output[faceCount] = new int[newIndex - oldIndex];
            for (int j = oldIndex; j < newIndex; ++j) {
                output[faceCount][j - oldIndex] = input[j];
                if (!verbose) continue;
                System.err.print(input[j] + " ");
            }
            ++faceCount;
            if (!verbose) continue;
            System.err.println("");
        }
        return output;
    }

    public static int[] reallocate(int[] array) {
        int n = array.length;
        int[] newarray = new int[n * 2];
        System.arraycopy(array, 0, newarray, 0, n);
        return newarray;
    }

    public static double[] reallocate(double[] array) {
        int n = array.length;
        double[] newarray = new double[n * 2];
        System.arraycopy(array, 0, newarray, 0, n);
        return newarray;
    }

    public static Color[] reallocate(Color[] array) {
        int n = array.length;
        Color[] newarray = new Color[n * 2];
        System.arraycopy(array, 0, newarray, 0, n);
        return newarray;
    }

    public static String[] reallocate(String[] array) {
        int n = array.length;
        String[] newarray = new String[n * 2];
        System.arraycopy(array, 0, newarray, 0, n);
        return newarray;
    }

    public static double[][] reallocate(double[][] array) {
        int n = array.length;
        double[][] newarray = new double[n * 2][];
        System.arraycopy(array, 0, newarray, 0, n);
        return newarray;
    }

    public static void checkFlag(String[] code, boolean[] mask, String key) {
        boolean hit = false;
        for (int i = 0; i < code.length; ++i) {
            if (!key.equals(code[i])) continue;
            mask[i] = true;
            hit = true;
            break;
        }
        if (!hit) {
            System.out.println("unknown AttributValue:" + key);
        }
    }

    public static int getEnum(String[] code, String key) {
        int n = 0;
        for (int i = 0; i < code.length; ++i) {
            if (!key.equals(code[i])) continue;
            n = i;
        }
        return n;
    }

    public static int[][] convertIndexList(int[] list) {
        int n = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != -1) continue;
            ++n;
        }
        if (list.length == 0) {
            return new int[0][];
        }
        if (list[list.length - 1] != -1) {
            ++n;
        }
        int[][] indices = new int[n][];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            LinkedList<Integer> v = new LinkedList<Integer>();
            while (k < list.length && list[k] != -1) {
                v.add(new Integer(list[k]));
                ++k;
            }
            indices[i] = new int[v.size()];
            int j = 0;
            for (Integer d : v) {
                indices[i][j] = d;
                ++j;
            }
            ++k;
        }
        return indices;
    }

    public static IndexedFaceSet cylinder(boolean side, boolean top, boolean bottom, int n) {
        SceneGraphComponent root = new SceneGraphComponent();
        SceneGraphComponent up = new SceneGraphComponent();
        SceneGraphComponent nappe = new SceneGraphComponent();
        SceneGraphComponent down = new SceneGraphComponent();
        root.addChild(up);
        root.addChild(nappe);
        root.addChild(down);
        if (side) {
            nappe.setGeometry(Primitives.cylinder(n));
        }
        if (top) {
            up.setGeometry(Primitives.regularPolygon(n, 0.0));
        }
        if (bottom) {
            down.setGeometry(Primitives.regularPolygon(n, 0.0));
        }
        MatrixBuilder.euclidean().scale(1.0, 0.5, 1.0).assignTo(root);
        MatrixBuilder.euclidean().rotate(1.5707963267948966, 1.0, 0.0, 0.0).assignTo(nappe);
        MatrixBuilder.euclidean().translate(0.0, 1.0, 0.0).rotate(1.5707963267948966, 1.0, 0.0, 0.0).assignTo(up);
        MatrixBuilder.euclidean().translate(0.0, -1.0, 0.0).rotate(1.5707963267948966, 1.0, 0.0, 0.0).assignTo(down);
        GeometryMergeFactory fac = new GeometryMergeFactory();
        IndexedFaceSet result = fac.mergeGeometrySets(root);
        result.setVertexAttributes(Attribute.COLORS, null);
        result.setFaceAttributes(Attribute.COLORS, null);
        return result;
    }

    public static IndexedFaceSet cone(boolean sidesdraw, boolean bottomdraw, int n) {
        SceneGraphComponent root = new SceneGraphComponent();
        SceneGraphComponent nappe = new SceneGraphComponent();
        SceneGraphComponent down = new SceneGraphComponent();
        root.addChild(nappe);
        root.addChild(down);
        if (sidesdraw) {
            nappe.setGeometry(Primitives.cone(n));
        }
        if (bottomdraw) {
            down.setGeometry(Primitives.regularPolygon(n, 0.0));
        }
        MatrixBuilder.euclidean().rotate(1.5707963267948966, -1.0, 0.0, 0.0).assignTo(nappe);
        MatrixBuilder.euclidean().rotate(1.5707963267948966, 1.0, 0.0, 0.0).assignTo(down);
        GeometryMergeFactory fac = new GeometryMergeFactory();
        IndexedFaceSet result = fac.mergeGeometrySets(root);
        result.setVertexAttributes(Attribute.COLORS, null);
        result.setFaceAttributes(Attribute.COLORS, null);
        return result;
    }

    public static String mergeStrings(String[] ss) {
        String s = ss[0];
        for (int i = 1; i < ss.length; ++i) {
            s = s + "   " + ss[i];
        }
        if (s.equals("")) {
            return " ";
        }
        return s;
    }

    public static void setNormals(IndexedFaceSetFactory ifsf, int[][] cIndex, int[][] nIndex, State state) {
        int i;
        int faceCount = cIndex.length;
        int VertexCount = state.coords.length;
        double[][] fNormals = new double[faceCount][3];
        double[][] vNormals = new double[VertexCount][3];
        State.Binding bind = state.normalBinding;
        if (bind == State.Binding.OVERALL) {
            for (i = 0; i < faceCount; ++i) {
                fNormals[i][0] = state.normals[0][0];
                fNormals[i][1] = state.normals[0][1];
                fNormals[i][2] = state.normals[0][2];
            }
            ifsf.setFaceNormals(fNormals);
        }
        if (bind == State.Binding.PER_PART | bind == State.Binding.PER_FACE) {
            System.arraycopy(state.normals, 0, fNormals, 0, faceCount);
            ifsf.setFaceNormals(fNormals);
        }
        if (bind == State.Binding.PER_PART_INDEXED | bind == State.Binding.PER_FACE_INDEXED) {
            for (i = 0; i < faceCount; ++i) {
                fNormals[i][0] = state.normals[nIndex[0][i]][0];
                fNormals[i][1] = state.normals[nIndex[0][i]][1];
                fNormals[i][2] = state.normals[nIndex[0][i]][2];
            }
            ifsf.setFaceNormals(fNormals);
        }
        if (bind == State.Binding.PER_VERTEX) {
            int m = 0;
            for (int i2 = 0; i2 < faceCount; ++i2) {
                int faceLength = cIndex[i2].length;
                for (int j = 0; j < faceLength; ++j) {
                    double[] n = state.normals[m];
                    vNormals[cIndex[i2][j]][0] = n[0];
                    vNormals[cIndex[i2][j]][1] = n[1];
                    vNormals[cIndex[i2][j]][2] = n[2];
                    ++m;
                }
            }
            ifsf.setVertexNormals(vNormals);
            ifsf.setGenerateFaceNormals(true);
        }
        if (bind == State.Binding.DEFAULT | bind == State.Binding.PER_VERTEX_INDEXED) {
            if (nIndex == null || nIndex.length != faceCount) {
                ifsf.setGenerateFaceNormals(true);
            } else {
                for (i = 0; i < faceCount; ++i) {
                    int faceLength = cIndex[i].length;
                    for (int j = 0; j < faceLength; ++j) {
                        double[] n = state.normals[nIndex[i][j]];
                        vNormals[cIndex[i][j]][0] = n[0];
                        vNormals[cIndex[i][j]][1] = n[1];
                        vNormals[cIndex[i][j]][2] = n[2];
                    }
                }
                ifsf.setVertexNormals(vNormals);
                ifsf.setGenerateFaceNormals(true);
            }
        }
    }

    public static void setColors(IndexedFaceSetFactory ifsf, int[][] coordIndex, int[][] colorIndex, State state) {
        int i;
        if (state.diffuse.length == 0) {
            return;
        }
        int faceCount = coordIndex.length;
        int VertexCount = state.coords.length;
        Color[] fColors = new Color[faceCount];
        Color[] vColors = new Color[VertexCount];
        State.Binding bind = state.materialBinding;
        if (bind == State.Binding.DEFAULT | bind == State.Binding.OVERALL | bind == State.Binding.NONE) {
            // empty if block
        }
        if (bind == State.Binding.PER_PART | bind == State.Binding.PER_FACE) {
            if (state.diffuse.length >= faceCount) {
                System.arraycopy(state.diffuse, 0, fColors, 0, faceCount);
                ifsf.setFaceColors(fColors);
            } else {
                System.err.println("wrong material Binding");
            }
        }
        if (bind == State.Binding.PER_PART_INDEXED | bind == State.Binding.PER_FACE_INDEXED) {
            for (i = 0; i < faceCount; ++i) {
                fColors[i] = state.diffuse[colorIndex[0][i]];
            }
            ifsf.setFaceColors(fColors);
        }
        if (bind == State.Binding.PER_VERTEX && state.diffuse.length >= faceCount) {
            int m = 0;
            for (int i2 = 0; i2 < faceCount; ++i2) {
                int faceLength = coordIndex[i2].length;
                for (int j = 0; j < faceLength; ++j) {
                    vColors[coordIndex[i2][j]] = state.diffuse[m];
                    ++m;
                }
            }
            ifsf.setVertexColors(vColors);
        }
        if (bind == State.Binding.PER_VERTEX_INDEXED) {
            for (i = 0; i < faceCount; ++i) {
                int faceLength = coordIndex[i].length;
                for (int j = 0; j < faceLength; ++j) {
                    vColors[coordIndex[i][j]] = state.diffuse[colorIndex[i][j]];
                }
            }
        }
    }

    public static void setColors(PointSet ps, State state, int start, int numP) {
        Color c;
        int i;
        if (state.diffuse.length == 0) {
            return;
        }
        double[][] vColors = new double[numP][3];
        State.Binding bind = state.materialBinding;
        if (bind == State.Binding.DEFAULT | bind == State.Binding.OVERALL | bind == State.Binding.NONE) {
            // empty if block
        }
        if (bind == State.Binding.PER_PART | bind == State.Binding.PER_FACE | bind == State.Binding.PER_VERTEX) {
            for (i = 0; i < numP; ++i) {
                c = state.diffuse[i];
                vColors[i][0] = (double)c.getRed() / 256.0;
                vColors[i][1] = (double)c.getGreen() / 256.0;
                vColors[i][2] = (double)c.getBlue() / 256.0;
            }
            ps.setVertexAttributes(Attribute.COLORS, new DoubleArrayArray.Array(vColors));
        }
        if (bind == State.Binding.PER_PART_INDEXED | bind == State.Binding.PER_FACE_INDEXED | bind == State.Binding.PER_VERTEX_INDEXED) {
            for (i = start; i < start + numP; ++i) {
                c = state.diffuse[i];
                vColors[i - start][0] = (double)c.getRed() / 256.0;
                vColors[i - start][1] = (double)c.getGreen() / 256.0;
                vColors[i - start][2] = (double)c.getBlue() / 256.0;
            }
            ps.setVertexAttributes(Attribute.COLORS, new DoubleArrayArray.Array(vColors));
        }
    }

    public static void setColors(IndexedLineSetFactory ilsf, int[][] coordIndex, int[][] colorIndex, State state) {
        int j;
        int edgeLength;
        int i;
        int j2;
        int edgeLength2;
        int i2;
        int m;
        int i3;
        if (state.diffuse.length == 0) {
            return;
        }
        int edgeCount = coordIndex.length;
        int VertexCount = state.coords.length;
        Color[] eColors = new Color[edgeCount];
        Color[] vColors = new Color[VertexCount];
        for (i3 = 0; i3 < VertexCount; ++i3) {
            vColors[i3] = Color.BLACK;
        }
        for (i3 = 0; i3 < edgeCount; ++i3) {
            eColors[i3] = Color.BLACK;
        }
        State.Binding bind = state.materialBinding;
        if (bind == State.Binding.DEFAULT | bind == State.Binding.OVERALL | bind == State.Binding.NONE) {
            // empty if block
        }
        if (bind == State.Binding.PER_PART) {
            System.arraycopy(state.diffuse, 0, eColors, 0, edgeCount);
            ilsf.setEdgeColors(eColors);
        }
        if (bind == State.Binding.PER_FACE) {
            m = 0;
            for (i2 = 0; i2 < edgeCount; ++i2) {
                edgeLength2 = coordIndex[i2].length;
                for (j2 = 0; j2 < edgeLength2; ++j2) {
                    vColors[coordIndex[i2][j2]] = j2 == edgeLength2 - 1 ? state.diffuse[m - 1] : state.diffuse[m];
                    ++m;
                }
            }
            ilsf.setVertexColors(vColors);
        }
        if (bind == State.Binding.PER_PART_INDEXED) {
            for (i = 0; i < edgeCount; ++i) {
                eColors[i] = state.diffuse[colorIndex[0][i]];
            }
            ilsf.setEdgeColors(eColors);
        }
        if (bind == State.Binding.PER_FACE_INDEXED) {
            for (i = 0; i < edgeCount; ++i) {
                edgeLength = coordIndex[i].length;
                for (j = 0; j < edgeLength; ++j) {
                    vColors[coordIndex[i][j]] = j == edgeLength - 1 ? state.diffuse[colorIndex[i][j - 1]] : state.diffuse[colorIndex[i][j]];
                }
            }
            ilsf.setVertexColors(vColors);
        }
        if (bind == State.Binding.PER_VERTEX) {
            m = 0;
            for (i2 = 0; i2 < edgeCount; ++i2) {
                edgeLength2 = coordIndex[i2].length;
                for (j2 = 0; j2 < edgeLength2; ++j2) {
                    vColors[coordIndex[i2][j2]] = state.diffuse[m];
                    ++m;
                }
            }
            ilsf.setVertexColors(vColors);
        }
        if (bind == State.Binding.PER_VERTEX_INDEXED) {
            for (i = 0; i < edgeCount; ++i) {
                edgeLength = coordIndex[i].length;
                for (j = 0; j < edgeLength; ++j) {
                    vColors[coordIndex[i][j]] = state.diffuse[colorIndex[i][j]];
                }
            }
            ilsf.setVertexColors(vColors);
        }
    }

    public static int[] decodeColorFromString(int dim, String s) {
        int[] c = new int[dim];
        long dec = Long.decode(s);
        for (int i = 0; i < dim; ++i) {
            int t;
            c[dim - i - 1] = t = (int)(dec % 256L);
            dec -= (long)t;
            dec /= 256L;
        }
        return c;
    }

    public static Color mergeColor(Color c1, Color c2) {
        float r = Math.max(c1.getRed(), c2.getRed());
        float g = Math.max(c1.getGreen(), c2.getGreen());
        float b = Math.max(c1.getBlue(), c2.getBlue());
        return new Color(r, g, b);
    }

    public static Appearance defaultApp() {
        Appearance a = new Appearance();
        a.setAttribute("tubeDraw", true);
        a.setAttribute("spheresDraw", true);
        return a;
    }

    public static int[] separateVerticesAndVNormals(int[][] faces, State state) {
        int faceC = faces.length;
        int totalVC = 0;
        for (int i = 0; i < faceC; ++i) {
            totalVC += faces[i].length;
        }
        double[][] newCoords = new double[totalVC][3];
        double[][] newTexCoords = new double[totalVC][2];
        double[][] newVNormals = new double[totalVC][3];
        int count = 0;
        int[] refferenceTable = new int[totalVC];
        for (int f = 0; f < faceC; ++f) {
            for (int v = 0; v < faces[f].length; ++v) {
                if (state.normalBinding == State.Binding.PER_VERTEX) {
                    newVNormals[count] = new double[]{state.normals[faces[f][v]][0], state.normals[faces[f][v]][1], state.normals[faces[f][v]][2]};
                }
                newCoords[count] = new double[]{state.coords[faces[f][v]][0], state.coords[faces[f][v]][1], state.coords[faces[f][v]][2]};
                if (state.textureCoords != null && state.textureCoords.length == state.coords.length) {
                    newTexCoords[count] = new double[]{state.textureCoords[faces[f][v]][0], state.textureCoords[faces[f][v]][1]};
                }
                refferenceTable[count] = faces[f][v];
                faces[f][v] = count++;
            }
        }
        if (state.textureCoords != null && state.textureCoords.length == state.coords.length) {
            state.textureCoords = newTexCoords;
        }
        state.coords = newCoords;
        if (state.normalBinding == State.Binding.PER_VERTEX) {
            state.normals = newVNormals;
        }
        return refferenceTable;
    }
}

