/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader.vrml;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.shader.ImageData;
import de.jreality.shader.Texture2D;
import de.jreality.shader.TextureUtility;
import de.jreality.util.Input;
import java.awt.Color;

public class State {
    public static final String[] VERTORDER = new String[]{"UNKNOWN_ORDERING", "CLOCKWISE", "COUNTERCLOCKWISE"};
    public static final String[] SHAPETYPE = new String[]{"UNKNOWN_SHAPE_TYPE", "SOLID"};
    public static final String[] FACETYPE = new String[]{"UNKNOWN_FACE_TYPE", "CONVEX"};
    String history = "";
    public Color[] ambient = new Color[0];
    public Color[] diffuse = new Color[0];
    public Color[] specular = new Color[0];
    public Color[] emissive = new Color[0];
    public double[] shininess = new double[0];
    public double[] transparency = new double[0];
    public Binding materialBinding = Binding.DEFAULT;
    public Binding normalBinding = Binding.DEFAULT;
    public SceneGraphPath camPath = new SceneGraphPath();
    public SceneGraphComponent currNode = null;
    public double[][] coords = new double[0][3];
    public double[][] normals = new double[0][3];
    public Transformation trafo = null;
    public Transformation extraGeoTrans = null;
    public String textureFile = "";
    public int[][][] textureData = new int[][][]{new int[][]{new int[0]}};
    public int wrapS = 0;
    public int wrapT = 0;
    public Matrix textureTrafo = MatrixBuilder.euclidean().getMatrix();
    public double[][] textureCoords = new double[][]{{0.0, 0.0}};
    public int vertexDraw = 0;
    public int edgeDraw = 0;
    public int faceDraw = 0;
    public int vertOrder = 0;
    public int shapeType = 0;
    public int faceType = 0;
    public double creaseAngle = 0.5;
    public int defTyp = -1;

    public State() {
    }

    public State(State orig) {
        int j;
        int i;
        int i2;
        double[] m;
        int i3;
        this.history = orig.history;
        int n = orig.ambient.length;
        this.ambient = new Color[n];
        for (i3 = 0; i3 < n; ++i3) {
            this.ambient[i3] = new Color(orig.ambient[i3].getRGB());
        }
        n = orig.diffuse.length;
        this.diffuse = new Color[n];
        for (i3 = 0; i3 < n; ++i3) {
            this.diffuse[i3] = new Color(orig.diffuse[i3].getRGB());
        }
        n = orig.emissive.length;
        this.emissive = new Color[n];
        for (i3 = 0; i3 < n; ++i3) {
            this.emissive[i3] = new Color(orig.emissive[i3].getRGB());
        }
        n = orig.specular.length;
        this.specular = new Color[n];
        for (i3 = 0; i3 < n; ++i3) {
            this.specular[i3] = new Color(orig.specular[i3].getRGB());
        }
        n = orig.shininess.length;
        this.shininess = new double[n];
        for (i3 = 0; i3 < n; ++i3) {
            this.shininess[i3] = orig.shininess[i3];
        }
        n = orig.transparency.length;
        this.transparency = new double[n];
        for (i3 = 0; i3 < n; ++i3) {
            this.transparency[i3] = orig.transparency[i3];
        }
        this.materialBinding = orig.materialBinding;
        this.normalBinding = orig.normalBinding;
        this.camPath = orig.camPath;
        this.currNode = orig.currNode;
        n = orig.coords.length;
        this.coords = new double[n][];
        for (i3 = 0; i3 < n; ++i3) {
            this.coords[i3] = new double[]{orig.coords[i3][0], orig.coords[i3][1], orig.coords[i3][2]};
        }
        n = orig.normals.length;
        this.normals = new double[n][];
        for (i3 = 0; i3 < n; ++i3) {
            this.normals[i3] = new double[]{orig.normals[i3][0], orig.normals[i3][1], orig.normals[i3][2]};
        }
        if (orig.trafo == null) {
            this.trafo = null;
        } else {
            double[] mOld = orig.trafo.getMatrix();
            m = new double[16];
            for (i2 = 0; i2 < 16; ++i2) {
                m[i2] = mOld[i2];
            }
            this.trafo = new Transformation(m);
        }
        if (orig.extraGeoTrans == null) {
            this.extraGeoTrans = null;
        } else {
            double[] mOld = orig.extraGeoTrans.getMatrix();
            m = new double[16];
            for (i2 = 0; i2 < 16; ++i2) {
                m[i2] = mOld[i2];
            }
            this.extraGeoTrans = new Transformation(m);
        }
        this.textureFile = orig.textureFile;
        this.textureData = new int[][][]{new int[][]{new int[0]}};
        if (orig.textureData.length > 0 && orig.textureData[0].length > 0 && orig.textureData[0][0].length > 0) {
            int a = orig.textureData.length;
            int b = orig.textureData[0].length;
            int c = orig.textureData[0][0].length;
            this.textureData = new int[a][b][c];
            for (i = 0; i < a; ++i) {
                for (j = 0; j < b; ++j) {
                    for (int k = 0; k < c; ++k) {
                        this.textureData[i][j][k] = orig.textureData[i][j][k];
                    }
                }
            }
        }
        this.wrapS = orig.wrapS;
        this.wrapT = orig.wrapT;
        double[] temp = new double[16];
        for (int i4 = 0; i4 < 16; ++i4) {
            temp[i4] = orig.textureTrafo.getArray()[i4];
        }
        this.textureTrafo = new Matrix(temp);
        if (orig.textureCoords.length > 0 && orig.textureCoords[0].length > 0) {
            int a = orig.textureCoords.length;
            int b = orig.textureCoords[0].length;
            this.textureCoords = new double[a][b];
            for (i = 0; i < a; ++i) {
                for (j = 0; j < b; ++j) {
                    this.textureCoords[i][j] = orig.textureCoords[i][j];
                }
            }
        }
        this.vertexDraw = orig.vertexDraw;
        this.edgeDraw = orig.edgeDraw;
        this.faceDraw = orig.faceDraw;
        this.vertOrder = orig.vertOrder;
        this.shapeType = orig.shapeType;
        this.faceType = orig.faceType;
        this.creaseAngle = orig.creaseAngle;
    }

    public int colorLength() {
        int n = Math.max(this.ambient.length, this.diffuse.length);
        int m = Math.max(this.specular.length, this.emissive.length);
        return Math.max(n, m);
    }

    public static Binding getBinding(String bind) {
        if (bind.equals("DEFAULT")) {
            return Binding.DEFAULT;
        }
        if (bind.equals("OVERALL")) {
            return Binding.OVERALL;
        }
        if (bind.equals("PER_PART")) {
            return Binding.PER_PART;
        }
        if (bind.equals("PER_PART_INDEXED")) {
            return Binding.PER_PART_INDEXED;
        }
        if (bind.equals("PER_FACE")) {
            return Binding.PER_FACE;
        }
        if (bind.equals("PER_FACE_INDEXED")) {
            return Binding.PER_FACE_INDEXED;
        }
        if (bind.equals("PER_VERTEX")) {
            return Binding.PER_VERTEX;
        }
        if (bind.equals("PER_VERTEX_INDEXED")) {
            return Binding.PER_VERTEX_INDEXED;
        }
        return Binding.NONE;
    }

    public void setColorApp(Appearance a, boolean useEmissive) {
        if (this.vertexDraw == 1) {
            a.setAttribute("showPoints", true);
        }
        if (this.vertexDraw == 2) {
            a.setAttribute("showPoints", false);
        }
        if (this.edgeDraw == 1) {
            a.setAttribute("showLines", true);
        }
        if (this.edgeDraw == 2) {
            a.setAttribute("showLines", false);
        }
        if (this.faceDraw == 1) {
            a.setAttribute("showFaces", true);
        }
        if (this.faceDraw == 2) {
            a.setAttribute("showFaces", false);
        }
        if (this.materialBinding != Binding.OVERALL && this.materialBinding != Binding.DEFAULT) {
            return;
        }
        if (this.ambient.length > 0) {
            a.setAttribute("polygonShader.ambientColor", this.ambient[0]);
            a.setAttribute("lineShader.ambientColor", this.ambient[0]);
            a.setAttribute("lineShader.polygonShader.ambientColor", this.ambient[0]);
            a.setAttribute("pointShader.ambientColor", this.ambient[0]);
            a.setAttribute("pointShader.polygonShader.ambientColor", this.ambient[0]);
        }
        if (this.specular.length > 0) {
            a.setAttribute("polygonShader.specularColor", this.specular[0]);
            a.setAttribute("lineShader.specularColor", this.specular[0]);
            a.setAttribute("lineShader.polygonShader.specularColor", this.specular[0]);
            a.setAttribute("pointShader.specularColor", this.specular[0]);
            a.setAttribute("pointShader.polygonShader.specularColor", this.specular[0]);
        }
        if (this.diffuse.length > 0) {
            a.setAttribute("polygonShader.diffuseColor", this.diffuse[0]);
            a.setAttribute("lineShader.diffuseColor", this.diffuse[0]);
            a.setAttribute("lineShader.polygonShader.diffuseColor", this.diffuse[0]);
            a.setAttribute("pointShader.diffuseColor", this.diffuse[0]);
            a.setAttribute("pointShader.polygonShader.diffuseColor", this.diffuse[0]);
        } else if (this.emissive.length > 0) {
            a.setAttribute("polygonShader.diffuseColor", this.emissive[0]);
            a.setAttribute("lineShader.diffuseColor", this.emissive[0]);
            a.setAttribute("lineShader.polygonShader.diffuseColor", this.emissive[0]);
            a.setAttribute("pointShader.diffuseColor", this.emissive[0]);
            a.setAttribute("pointShader.polygonShader.diffuseColor", this.emissive[0]);
        }
        if (this.transparency.length > 0 && this.transparency[0] != 1.0) {
            a.setAttribute("polygonShader.transparency", this.transparency[0]);
            a.setAttribute("lineShader.transparency", this.transparency[0]);
            a.setAttribute("lineShader.polygonShader.transparency", this.transparency[0]);
            a.setAttribute("pointShader.transparency", this.transparency[0]);
            a.setAttribute("pointShader.polygonShader.transparency", this.transparency[0]);
        }
    }

    public boolean haveToSeparateVertices() {
        if (this.normalBinding == Binding.PER_VERTEX && this.normals.length > 0) {
            return true;
        }
        if (this.normalBinding == Binding.PER_VERTEX_INDEXED && this.normals.length > 0) {
            return true;
        }
        if (this.materialBinding == Binding.PER_VERTEX && this.colorLength() > 0) {
            return true;
        }
        if (this.materialBinding == Binding.PER_VERTEX_INDEXED && this.colorLength() > 0) {
            return true;
        }
        if (!this.textureFile.equals("")) {
            return true;
        }
        return this.textureData.length != 0 && this.textureData[0].length != 0 && this.textureData[0][0].length != 0;
    }

    public void setTrafo(SceneGraphComponent sgc) {
        if (this.trafo != null | this.extraGeoTrans != null) {
            Transformation t = new Transformation();
            if (this.trafo != null) {
                t = this.trafo;
            } else {
                MatrixBuilder.euclidean().assignTo(t);
            }
            if (this.extraGeoTrans != null) {
                t.multiplyOnRight(this.extraGeoTrans.getMatrix());
            }
            sgc.setTransformation(t);
        }
    }

    public Appearance assignTexture(Appearance app, IndexedFaceSet f) {
        ImageData id;
        if (this.textureFile.equals("")) {
            if (this.textureData.length == 0 || this.textureData[0].length == 0 || this.textureData[0][0].length == 0) {
                return app;
            }
            int w = this.textureData.length;
            int h = this.textureData[0].length;
            int dim = this.textureData[0][0].length;
            byte[] cols = new byte[w * h * 4];
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    if (dim == 1) {
                        cols[i * h * 4 + j * 4 + 0] = (byte)this.textureData[i][j][0];
                        cols[i * h * 4 + j * 4 + 1] = (byte)this.textureData[i][j][0];
                        cols[i * h * 4 + j * 4 + 2] = (byte)this.textureData[i][j][0];
                        cols[i * h * 4 + j * 4 + 3] = -1;
                    }
                    if (dim == 2) {
                        cols[i * h * 4 + j * 4 + 0] = (byte)this.textureData[i][j][0];
                        cols[i * h * 4 + j * 4 + 1] = (byte)this.textureData[i][j][0];
                        cols[i * h * 4 + j * 4 + 2] = (byte)this.textureData[i][j][0];
                        cols[i * h * 4 + j * 4 + 3] = (byte)this.textureData[i][j][1];
                    }
                    if (dim == 3) {
                        cols[i * h * 4 + j * 4 + 0] = (byte)this.textureData[i][j][0];
                        cols[i * h * 4 + j * 4 + 1] = (byte)this.textureData[i][j][1];
                        cols[i * h * 4 + j * 4 + 2] = (byte)this.textureData[i][j][2];
                        cols[i * h * 4 + j * 4 + 3] = -1;
                    }
                    if (dim != 4) continue;
                    cols[i * h * 4 + j * 4 + 0] = (byte)this.textureData[i][j][0];
                    cols[i * h * 4 + j * 4 + 1] = (byte)this.textureData[i][j][1];
                    cols[i * h * 4 + j * 4 + 2] = (byte)this.textureData[i][j][2];
                    cols[i * h * 4 + j * 4 + 3] = (byte)this.textureData[i][j][3];
                }
            }
            id = new ImageData(cols, w, h);
        } else {
            id = null;
            try {
                id = ImageData.load(Input.getInput(this.textureFile));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (app == null) {
            app = new Appearance();
        }
        double[][] texCoord = new double[f.getNumPoints()][];
        if (this.textureCoords.length < f.getNumPoints()) {
            System.out.println("State.assignTexture() not enough Texturecoords");
        }
        System.arraycopy(this.textureCoords, 0, texCoord, 0, f.getNumPoints());
        f.setVertexAttributes(Attribute.TEXTURE_COORDINATES, new DoubleArrayArray.Array(texCoord));
        app.setAttribute("polygonShader.diffuseColor", new Color(1.0f, 1.0f, 1.0f));
        app.setAttribute("polygonShader.transparencyEnabled", false);
        Texture2D tex = TextureUtility.createTexture(app, "polygonShader", id);
        tex.setTextureMatrix(this.textureTrafo);
        if (this.wrapS == 0) {
            tex.setRepeatS(10497);
        } else {
            tex.setRepeatS(10496);
        }
        if (this.wrapT == 0) {
            tex.setRepeatT(10497);
        } else {
            tex.setRepeatT(10496);
        }
        tex.setApplyMode(8448);
        return app;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Binding {
        DEFAULT,
        OVERALL,
        PER_PART,
        PER_PART_INDEXED,
        PER_FACE,
        PER_FACE_INDEXED,
        PER_VERTEX,
        PER_VERTEX_INDEXED,
        NONE;

    }
}

