/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.math.MatrixBuilder;
import de.jreality.reader.AbstractReader;
import de.jreality.scene.Cylinder;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.StorageModel;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;

public class ReaderPOV
extends AbstractReader {
    private boolean useCylinders = false;
    private static int UNIT_DISK_DETAIL = 32;

    public void setUseCylinders(boolean useCylinders) {
        this.useCylinders = useCylinders;
    }

    public void setInput(Input input) throws IOException {
        super.setInput(input);
        this.root = this.load(input.getInputStream());
    }

    private SceneGraphComponent load(InputStream inputStream) {
        BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));
        SceneGraphComponent disk = new SceneGraphComponent();
        if (this.useCylinders) {
            disk.setGeometry(new Cylinder());
        } else {
            disk.setGeometry(new UnitDisk(UNIT_DISK_DETAIL));
        }
        MatrixBuilder.euclidean().scale(1.0, 1.0, 0.2).assignTo(disk);
        StreamTokenizer st = new StreamTokenizer(r);
        st.ordinaryChar(123);
        st.ordinaryChar(125);
        st.parseNumbers();
        SceneGraphComponent root = new SceneGraphComponent();
        SceneGraphComponent current = null;
        int bc = 0;
        int oc = 0;
        LoggingSystem.getLogger(this).fine("start.");
        try {
            while (st.ttype != -1) {
                st.nextToken();
                if (st.ttype == -3 && st.sval.equals("object")) {
                    while (st.ttype != 123) {
                        st.nextToken();
                    }
                    oc = bc;
                    current = new SceneGraphComponent();
                }
                if (st.ttype == 123) {
                    ++bc;
                }
                if (st.ttype == 125) {
                    --bc;
                }
                if (bc == oc && current != null) {
                    root.addChild(current);
                    current = null;
                }
                if (st.ttype == -3 && st.sval.equals("Disk") && current != null) {
                    current.addChild(disk);
                }
                if (st.ttype != -3 || !st.sval.equals("matrix") || current == null) continue;
                current.setTransformation(this.readMatrix(st));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LoggingSystem.getLogger(this).fine("made " + root.getChildComponentCount() + " components");
        LoggingSystem.getLogger(this).fine("done.");
        return root;
    }

    private Transformation readMatrix(StreamTokenizer st) throws IOException {
        double[] d = new double[12];
        double[] m = new double[16];
        for (int i = 0; i < 12; ++i) {
            int b;
            for (b = 0; st.ttype != -2 && b < 40; ++b) {
                st.nextToken();
            }
            if (b == 40) {
                LoggingSystem.getLogger(this).fine("Error number " + i + " was aborted due to recursion.");
            }
            d[i] = st.nval;
            st.nextToken();
            if (st.ttype != -3 || !st.sval.startsWith("E")) continue;
            int exp = Integer.parseInt(st.sval.substring(1));
            int n = i;
            d[n] = d[n] * Math.pow(10.0, exp);
            st.nextToken();
        }
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 3; ++i) {
                m[j + 4 * i] = d[i + 3 * j];
            }
        }
        m[15] = 1.0;
        Transformation t = new Transformation();
        t.setMatrix(m);
        return t;
    }

    private static class UnitDisk
    extends IndexedFaceSet {
        public UnitDisk(int detail) {
            double r = 1.0;
            double[] vertices = new double[detail * 3 + 3];
            double[] normals = new double[detail * 3 + 3];
            int[] faces = new int[detail * 3];
            this.compute(vertices, normals, faces);
            this.setVertexCountAndAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.inlined(3).createReadOnly(vertices));
            this.setFaceCountAndAttributes(Attribute.INDICES, StorageModel.INT_ARRAY.inlined(3).createReadOnly(faces));
            IndexedFaceSetUtility.calculateAndSetEdgesFromFaces(this);
            IndexedFaceSetUtility.calculateAndSetFaceNormals(this);
            IndexedFaceSetUtility.calculateAndSetVertexNormals(this);
        }

        private void compute(double[] vertices, double[] normals, int[] faces) {
            int k = UNIT_DISK_DETAIL;
            for (int i = 0; i < k; ++i) {
                faces[3 * i + 0] = i;
                faces[3 * i + 1] = (i + 1) % k;
                faces[3 * i + 2] = k;
                double theta = Math.PI * 2 * (double)i / (double)k;
                double cosT = Math.cos(theta);
                double sinT = Math.sin(theta);
                int pos = 3 * i;
                vertices[pos + 0] = cosT;
                vertices[pos + 1] = sinT;
                vertices[pos + 2] = 0.0;
                normals[pos + 0] = 0.0;
                normals[pos + 1] = 0.0;
                normals[pos + 2] = 1.0;
            }
            vertices[3 * k] = 0.0;
            vertices[3 * k + 1] = 0.0;
            vertices[3 * k + 2] = 0.0;
            normals[3 * k] = 0.0;
            normals[3 * k + 1] = 0.0;
            normals[3 * k + 2] = 1.0;
        }
    }
}

