/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.shader.Texture2D;
import de.jreality.shader.TextureUtility;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.List;
import java.util.Vector;

public class ParserMTL {
    public static Appearance defaultApp = ParserMTL.createDefault();
    Input input;

    static Appearance createDefault() {
        Appearance ret = new Appearance();
        return ret;
    }

    public ParserMTL(Input input) {
        this.input = input;
    }

    public static List readAppearences(Input mtlInput) throws IOException {
        return new ParserMTL(mtlInput).load();
    }

    public static Appearance getDefault() {
        return defaultApp;
    }

    public List load() {
        Reader r = this.input.getReader();
        SceneGraphComponent disk = new SceneGraphComponent();
        StreamTokenizer st = new StreamTokenizer(r);
        Vector<Appearance> ret = new Vector<Appearance>();
        try {
            while (st.ttype != -1) {
                ret.add(this.loadCurrent(st));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private StreamTokenizer globalSyntax(StreamTokenizer st) {
        st.resetSyntax();
        st.eolIsSignificant(true);
        st.wordChars(48, 57);
        st.wordChars(65, 90);
        st.wordChars(97, 122);
        st.wordChars(95, 95);
        st.wordChars(46, 46);
        st.wordChars(45, 45);
        st.wordChars(43, 43);
        st.wordChars(160, 255);
        st.whitespaceChars(0, 32);
        st.commentChar(35);
        st.ordinaryChar(47);
        st.parseNumbers();
        return st;
    }

    private Appearance loadCurrent(StreamTokenizer st) throws IOException {
        Appearance ret = ParserMTL.createDefault();
        this.globalSyntax(st);
        boolean started = false;
        while (st.nextToken() != -1) {
            if (st.ttype != -3) continue;
            String word = st.sval;
            if (word.equalsIgnoreCase("newmtl")) {
                if (started) {
                    st.pushBack();
                    return ret;
                }
                this.setName(st, ret);
                started = true;
                continue;
            }
            if (word.equalsIgnoreCase("Ka")) {
                ret.setAttribute("polygonShader.ambientColor", this.readColor(st));
                continue;
            }
            if (word.equalsIgnoreCase("Kd")) {
                ret.setAttribute("polygonShader.diffuseColor", this.readColor(st));
                continue;
            }
            if (word.equalsIgnoreCase("Ks")) {
                ret.setAttribute("polygonShader.specularColor", this.readColor(st));
                continue;
            }
            if (word.equalsIgnoreCase("d")) {
                st.nextToken();
                double val = st.nval;
                ret.setAttribute("polygonShader.transparency", 1.0 - val);
                if (val < 1.0) {
                    ret.setAttribute("polygonShader.transparencyEnabled", true);
                }
                while (st.nextToken() != 10) {
                }
                continue;
            }
            if (word.equalsIgnoreCase("Ns")) {
                this.ignoreToken(st);
                continue;
            }
            if (word.equalsIgnoreCase("illum")) {
                this.ignoreToken(st);
                continue;
            }
            if (word.equalsIgnoreCase("sharpness")) {
                this.ignoreToken(st);
                continue;
            }
            if (word.equalsIgnoreCase("bump")) {
                this.ignoreToken(st);
                continue;
            }
            if (word.equalsIgnoreCase("map_Ka")) {
                this.setTextureMap(st, ret);
                continue;
            }
            if (word.equalsIgnoreCase("map_Kd")) {
                this.setTextureMap(st, ret);
                continue;
            }
            if (word.equalsIgnoreCase("map_Ks")) {
                this.setTextureMap(st, ret);
                continue;
            }
            if (word.equalsIgnoreCase("map_Ns")) {
                this.ignoreToken(st);
                continue;
            }
            LoggingSystem.getLogger(this).fine("unknown tag: " + word);
            while (st.nextToken() != 10) {
                if (st.ttype != -2) continue;
                LoggingSystem.getLogger(this).fine("[" + st.nval + "," + st.sval + "," + st.ttype + "]");
            }
            LoggingSystem.getLogger(this).fine("unknown tag: " + word + " end");
        }
        return ret;
    }

    private void setTextureMap(StreamTokenizer st, Appearance ret) throws IOException {
        String texFile = this.readString(st);
        try {
            Texture2D tex = TextureUtility.createTexture(ret, "polygonShader", this.input.resolveInput(texFile), false);
        }
        catch (FileNotFoundException e) {
            LoggingSystem.getLogger(this).warning("couldn't find " + texFile);
        }
        catch (IOException e) {
            LoggingSystem.getLogger(this).warning("read error " + texFile);
        }
    }

    private void ignoreToken(StreamTokenizer st) throws IOException {
        while (st.nextToken() != 10) {
        }
    }

    private void setName(StreamTokenizer st, Appearance ret) throws IOException {
        ret.setName(this.readString(st));
    }

    private String readString(StreamTokenizer st) throws IOException {
        String ret = "";
        while (st.nextToken() != 10) {
            ret = ret + st.sval;
        }
        return ret;
    }

    private Color readColor(StreamTokenizer st) throws IOException {
        double[] coords = new double[3];
        int ix = 0;
        while (st.nextToken() != 10) {
            if (st.ttype != -2) {
                LoggingSystem.getLogger(this).fine("color ignoring token: " + st.sval);
                continue;
            }
            if (ix > 2) {
                LoggingSystem.getLogger(this).fine("ignoring " + (ix + 1) + "th color coord.");
                continue;
            }
            coords[ix++] = st.nval;
        }
        if (ix < 2) {
            LoggingSystem.getLogger(this).fine("Warning: only " + ix + " color vals read.");
        }
        Color ret = new Color((float)coords[0], (float)coords[1], (float)coords[2]);
        return ret;
    }
}

