/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRenderingState;
import de.jreality.jogl.shader.VertexShader;
import de.jreality.shader.CommonAttributes;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import java.awt.Color;
import java.util.logging.Level;
import javax.media.opengl.GL;

public class SimpleVertexShader
implements VertexShader {
    Color diffuseColor;
    double transparency;
    double diffuseCoefficient;
    float[] diffuseColorAsFloat;
    int frontBack = 1032;

    public Color getDiffuseColor() {
        return this.diffuseColor;
    }

    public float[] getDiffuseColorAsFloat() {
        return this.diffuseColorAsFloat;
    }

    public void setFrontBack(int f) {
        this.frontBack = f;
    }

    public void postRender(JOGLRenderingState jrs) {
    }

    public void render(JOGLRenderingState jrs) {
        JOGLRenderer jr = jrs.renderer;
        GL gl = jr.globalGL;
        if (jr.renderingState.frontBack != this.frontBack) {
            gl.glColorMaterial(this.frontBack, 4609);
            jr.renderingState.frontBack = this.frontBack;
        }
        if (jr.renderingState.transparencyEnabled || (double)this.diffuseColorAsFloat[3] == 0.0) {
            gl.glColor4fv(this.diffuseColorAsFloat, 0);
        } else {
            gl.glColor3fv(this.diffuseColorAsFloat, 0);
        }
    }

    public void setFromEffectiveAppearance(EffectiveAppearance eap, String name) {
        JOGLConfiguration.theLog.log(Level.FINER, "Setting simple vertex shader");
        this.diffuseCoefficient = eap.getAttribute(ShaderUtility.nameSpace(name, "diffuseCoefficient"), 1.0);
        this.diffuseColor = (Color)eap.getAttribute(ShaderUtility.nameSpace(name, "diffuseColor"), CommonAttributes.DIFFUSE_COLOR_DEFAULT);
        this.transparency = eap.getAttribute(ShaderUtility.nameSpace(name, "transparency"), 0.0);
        this.diffuseColor = ShaderUtility.combineDiffuseColorWithTransparency(this.diffuseColor, this.transparency, JOGLRenderingState.useOldTransparency);
        this.diffuseColorAsFloat = this.diffuseColor.getRGBComponents(null);
    }
}

