/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.math.Rn;
import de.jreality.shader.ImageData;
import java.awt.Color;

public class ShadedSphereImage {
    static byte[] sphereTex;
    static double[][] sphereVertices;
    static final double[] defaultLightDirection;
    static final Color defaultDiffuseColor;
    static final Color defaultSpecularColor;
    static int[] defaultChannels;

    public static ImageData shadedSphereImage(double[] lightDirection, Color diffuseColor, Color specularColor, double specularExponent, int textureSize, boolean lighting, int[] ch) {
        int I = 0;
        int II = 0;
        lightDirection = lightDirection == null ? defaultLightDirection : Rn.normalize(null, lightDirection);
        if (diffuseColor == null) {
            diffuseColor = defaultDiffuseColor;
        }
        if (specularColor == null) {
            specularColor = defaultSpecularColor;
        }
        if (ch == null) {
            ch = defaultChannels;
        }
        double[] reflected = new double[3];
        float[] diffuseColorAsFloat = diffuseColor.getRGBComponents(null);
        float[] specularColorAsFloat = specularColor.getRGBComponents(null);
        if (sphereTex == null || sphereTex.length != 4 * textureSize * textureSize) {
            sphereTex = new byte[textureSize * textureSize * 4];
        }
        if (sphereVertices == null || sphereVertices.length != textureSize * textureSize) {
            ShadedSphereImage.calculateSphereVertices(textureSize);
        }
        double alpha = diffuseColorAsFloat[3];
        for (int i = 0; i < textureSize; ++i) {
            for (int j = 0; j < textureSize; ++j) {
                if (sphereVertices[I][0] != -1.0) {
                    double diffuse = Rn.innerProduct(lightDirection, sphereVertices[I]);
                    if (diffuse < 0.0) {
                        diffuse = 0.0;
                    }
                    if (diffuse > 1.0) {
                        diffuse = 1.0;
                    }
                    double z = sphereVertices[I][2];
                    reflected[0] = 2.0 * sphereVertices[I][0] * z;
                    reflected[1] = 2.0 * sphereVertices[I][1] * z;
                    reflected[2] = 2.0 * z * z - 1.0;
                    double specular = Rn.innerProduct(lightDirection, reflected);
                    if (specular < 0.0) {
                        specular = 0.0;
                    }
                    if (specular > 1.0) {
                        specular = 1.0;
                    }
                    specular = Math.pow(specular, specularExponent);
                    for (int k = 0; k < 3; ++k) {
                        double f = diffuseColorAsFloat[k];
                        if (lighting) {
                            f = diffuse * f + specular * (double)specularColorAsFloat[k];
                        }
                        if (f < 0.0) {
                            f = 0.0;
                        }
                        if (f > 1.0) {
                            f = 1.0;
                        }
                        ShadedSphereImage.sphereTex[II + ch[k]] = (byte)(255.0 * f);
                    }
                    ShadedSphereImage.sphereTex[II + ch[3]] = (byte)(sphereVertices[I][2] < 0.1 ? (double)((byte)(alpha * 2550.0 * sphereVertices[I][2])) : alpha * 255.0);
                } else {
                    ShadedSphereImage.sphereTex[II + 3] = 0;
                    ShadedSphereImage.sphereTex[II + 2] = 0;
                    ShadedSphereImage.sphereTex[II + 1] = 0;
                    ShadedSphereImage.sphereTex[II] = 0;
                }
                II += 4;
                ++I;
            }
        }
        ImageData id = new ImageData(sphereTex, textureSize, textureSize);
        return id;
    }

    private static void calculateSphereVertices(int ts) {
        if (sphereVertices != null && ts * ts == sphereVertices.length) {
            return;
        }
        int I = 0;
        sphereVertices = new double[ts * ts][3];
        for (int i = 0; i < ts; ++i) {
            double y = 2.0 * ((double)i + 0.5) / (double)ts - 1.0;
            for (int j = 0; j < ts; ++j) {
                double x = 2.0 * ((double)j + 0.5) / (double)ts - 1.0;
                double dsq = x * x + y * y;
                if (dsq <= 1.0) {
                    double z = Math.sqrt(1.0 - dsq);
                    ShadedSphereImage.sphereVertices[I][0] = x;
                    ShadedSphereImage.sphereVertices[I][1] = y;
                    ShadedSphereImage.sphereVertices[I][2] = z;
                } else {
                    ShadedSphereImage.sphereVertices[I][2] = -1.0;
                    ShadedSphereImage.sphereVertices[I][1] = -1.0;
                    ShadedSphereImage.sphereVertices[I][0] = -1.0;
                }
                ++I;
            }
        }
    }

    static {
        defaultLightDirection = new double[]{0.0, 0.0, 1.0};
        defaultDiffuseColor = Color.red;
        defaultSpecularColor = Color.white;
        defaultChannels = new int[]{0, 1, 2, 3};
        ShadedSphereImage.calculateSphereVertices(128);
    }
}

