/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.jogl.JOGLRenderer;
import de.jreality.shader.GlslProgram;
import de.jreality.shader.GlslSource;
import java.beans.Statement;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.WeakHashMap;
import javax.media.opengl.GL;

public class GlslLoader {
    private static final WeakHashMap GL_TO_GLSL = new WeakHashMap();

    public static void render(GlslProgram prog, JOGLRenderer jr) {
        GL gl = jr.globalGL;
        GlslLoader.render(prog, gl);
    }

    public static void render(GlslProgram prog, GL gl) {
        ProgramContext context = GlslLoader.getContext(gl, prog);
        context.linkProgram(gl);
        context.activateProgram(gl);
        for (GlslSource.UniformParameter param : prog.getSource().getUniformParameters()) {
            Object value = prog.getUniform(param.getName());
            Object oldValue = context.getUniform(param);
            if (!GlslLoader.compare(oldValue, value, param.getPrimitiveType())) continue;
            context.writeValue(gl, param, value);
        }
        int k = 9;
        for (GlslSource.AttributeParameter param : prog.getSource().getAttributes()) {
            gl.glBindAttribLocation(context.progID.intValue(), k, param.getName());
            ++k;
        }
    }

    private static boolean compare(Object oldValue, Object value, Class primitive) {
        if (value == null) {
            return false;
        }
        if (oldValue == null) {
            return true;
        }
        if (primitive == Float.TYPE) {
            float[] old = (float[])oldValue;
            float[] newF = (float[])value;
            if (old.length != newF.length) {
                return true;
            }
            for (int i = 0; i < old.length; ++i) {
                if (old[i] == newF[i]) continue;
                return true;
            }
        } else {
            int[] old = (int[])oldValue;
            int[] newF = (int[])value;
            if (old.length != newF.length) {
                return true;
            }
            for (int i = 0; i < old.length; ++i) {
                if (old[i] == newF[i]) continue;
                return true;
            }
        }
        return false;
    }

    public static void postRender(GlslProgram prog, JOGLRenderer jr) {
        GL gl = jr.globalGL;
        GlslLoader.postRender(prog, gl);
    }

    public static void postRender(GlslProgram prog, GL gl) {
        ProgramContext context = GlslLoader.getContext(gl, prog);
        context.deactivateProgram(gl);
    }

    private static ProgramContext getContext(GL gl, GlslProgram prog) {
        ProgramContext context;
        WeakHashMap<GlslSource, ProgramContext> glContexts = (WeakHashMap<GlslSource, ProgramContext>)GL_TO_GLSL.get(gl);
        if (glContexts == null) {
            glContexts = new WeakHashMap<GlslSource, ProgramContext>();
            GL_TO_GLSL.put(gl, glContexts);
        }
        if ((context = (ProgramContext)glContexts.get(prog.getSource())) == null) {
            context = new ProgramContext(prog.getSource());
            glContexts.put(prog.getSource(), context);
        }
        return context;
    }

    public static void printInfoLog(String name, int objectHandle, GL gl) {
        int[] logLength = new int[1];
        int[] charsWritten = new int[1];
        gl.glGetObjectParameterivARB(objectHandle, 35716, IntBuffer.wrap(logLength));
        if (logLength[0] > 0) {
            byte[] infoLog = new byte[logLength[0]];
            gl.glGetInfoLogARB(objectHandle, logLength[0], IntBuffer.wrap(charsWritten), ByteBuffer.wrap(infoLog));
            StringBuffer foo = new StringBuffer(charsWritten[0]);
            for (int i = 0; i < charsWritten[0]; ++i) {
                foo.append((char)infoLog[i]);
            }
            if (foo.length() > 0) {
                System.out.println("[" + name + "] GLSL info log: " + foo.toString());
            }
        }
    }

    public static void dispose(GL gl, GlslProgram prog) {
        ProgramContext context = GlslLoader.getContext(gl, prog);
        if (context == null) {
            System.out.println("Context NULL while disposing!!!");
            return;
        }
        Integer id = context.progID;
        if (id == null) {
            System.out.println("id NULL while disposing!!!");
            return;
        }
        gl.glDeleteProgramsARB(1, new int[]{id}, 0);
        WeakHashMap glContexts = (WeakHashMap)GL_TO_GLSL.get(gl);
        glContexts.remove(prog.getSource());
    }

    private static class ProgramContext {
        final GlslSource source;
        final HashMap currentValues = new HashMap();
        boolean isLinked;
        Integer progID;

        ProgramContext(GlslSource source) {
            this.source = source;
        }

        public void activateProgram(GL gl) {
            gl.glUseProgramObjectARB(this.progID.intValue());
        }

        public void deactivateProgram(GL gl) {
            gl.glUseProgramObjectARB(0);
        }

        Object getUniform(GlslSource.UniformParameter parameter) {
            return this.currentValues.get(parameter);
        }

        void writeValue(GL gl, GlslSource.UniformParameter param, Object value) {
            String rep = param.getStringRep();
            Object[] params = new Object[param.isMatrix() ? 5 : 4];
            params[0] = this.uniLocation(param.getName(), gl);
            if ((Integer)params[0] == -1) {
                return;
            }
            params[1] = new Integer(param.isArray() ? param.getArrayLength() : 1);
            if (param.isMatrix()) {
                params[2] = Boolean.FALSE;
            }
            params[param.isMatrix() ? 3 : 2] = value;
            params[param.isMatrix() ? 4 : 3] = new Integer(0);
            Statement s = new Statement(gl, rep, params);
            try {
                s.execute();
            }
            catch (Exception e) {
                GlslLoader.printInfoLog(param.toString(), this.progID, gl);
                e.printStackTrace();
            }
            this.currentValues.put(param, value);
        }

        void linkProgram(GL gl) {
            if (this.isLinked) {
                return;
            }
            this.progID = new Integer(gl.glCreateProgramObjectARB());
            if (this.source.getVertexProgram() != null) {
                int vertexProgID = gl.glCreateShaderObjectARB(35633);
                gl.glShaderSource(vertexProgID, this.source.getVertexProgram().length, this.source.getVertexProgram(), (int[])null, 0);
                gl.glCompileShaderARB(vertexProgID);
                GlslLoader.printInfoLog("vert compile", vertexProgID, gl);
                gl.glAttachObjectARB(this.progID.intValue(), vertexProgID);
                GlslLoader.printInfoLog("vert attatch", vertexProgID, gl);
            }
            if (this.source.getFragmentProgram() != null) {
                int fragmentProgID = gl.glCreateShaderObjectARB(35632);
                gl.glShaderSourceARB(fragmentProgID, this.source.getFragmentProgram().length, this.source.getFragmentProgram(), (int[])null, 0);
                gl.glCompileShaderARB(fragmentProgID);
                GlslLoader.printInfoLog("frag compile", fragmentProgID, gl);
                gl.glAttachObjectARB(this.progID.intValue(), fragmentProgID);
                GlslLoader.printInfoLog("frag attatch", fragmentProgID, gl);
            }
            GlslLoader.printInfoLog("prog attatch", this.progID, gl);
            gl.glLinkProgramARB(this.progID.intValue());
            GlslLoader.printInfoLog("prog link", this.progID, gl);
            System.out.println("loaded program [" + this.progID + "]");
            this.isLinked = true;
        }

        private Integer uniLocation(String name, GL gl) {
            int loc = gl.glGetUniformLocationARB(this.progID.intValue(), name);
            if (loc == -1) {
                // empty if block
            }
            return new Integer(loc);
        }
    }
}

