/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.geometry.GeometryUtility;
import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRendererHelper;
import de.jreality.jogl.JOGLRenderingState;
import de.jreality.jogl.JOGLSphereHelper;
import de.jreality.jogl.shader.AbstractPrimitiveShader;
import de.jreality.jogl.shader.DefaultGeometryShader;
import de.jreality.jogl.shader.PointShader;
import de.jreality.jogl.shader.PolygonShader;
import de.jreality.jogl.shader.ShadedSphereImage;
import de.jreality.jogl.shader.Shader;
import de.jreality.jogl.shader.ShaderLookup;
import de.jreality.jogl.shader.Texture2DLoaderJOGL;
import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.PointSet;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.IntArray;
import de.jreality.shader.CommonAttributes;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import de.jreality.util.CameraUtility;
import de.jreality.util.LoggingSystem;
import java.awt.Color;
import javax.media.opengl.GL;

public class DefaultPointShader
extends AbstractPrimitiveShader
implements PointShader {
    double pointSize = 1.0;
    float[] pointAttenuation = new float[]{0.0f, 0.0f, 1.0f};
    float[] noPointAttentuation = new float[]{1.0f, 0.0f, 0.0f};
    double pointRadius = 0.1;
    Color diffuseColor = Color.RED;
    float[] diffuseColorAsFloat;
    float[] specularColorAsFloat = new float[]{0.0f, 1.0f, 1.0f, 1.0f};
    boolean sphereDraw = false;
    boolean lighting = true;
    boolean opaqueSpheres = true;
    boolean radiiWorldCoords = false;
    boolean attenuatePointSize = false;
    boolean useSrcAlphaBlending = false;
    PolygonShader polygonShader = null;
    Appearance a = new Appearance();
    Texture2D spriteTexture = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, "", this.a, true);
    Texture2D currentTex;
    double specularExponent = 60.0;
    int polygonCount = 0;
    boolean changedTransp;
    boolean changedLighting;
    boolean spriteNeedsUpdated;
    double[] lightDirection = new double[]{1.0, -1.0, 2.0};
    private Color specularColor;
    static int textureSize = 128;
    de.jreality.shader.DefaultPointShader templateShader;
    float[] oldDiffuseColorAsFloat = new float[4];

    public DefaultPointShader(de.jreality.shader.DefaultPointShader orig) {
        this.templateShader = orig;
    }

    public DefaultPointShader() {
    }

    public void setFromEffectiveAppearance(EffectiveAppearance eap, String name) {
        super.setFromEffectiveAppearance(eap, name);
        this.sphereDraw = eap.getAttribute(ShaderUtility.nameSpace(name, "spheresDraw"), true);
        this.opaqueSpheres = eap.getAttribute(ShaderUtility.nameSpace(name, "opaqueTubesAndSpheres"), false);
        this.lightDirection = (double[])eap.getAttribute(ShaderUtility.nameSpace(name, "lightDirection"), this.lightDirection);
        this.lighting = eap.getAttribute(ShaderUtility.nameSpace(name, "lightingEnabled"), true);
        this.pointSize = eap.getAttribute(ShaderUtility.nameSpace(name, "pointSize"), 30.0);
        this.useSrcAlphaBlending = eap.getAttribute(ShaderUtility.nameSpace(name, "sourceAlphaBlendOnly"), false);
        this.attenuatePointSize = eap.getAttribute(ShaderUtility.nameSpace(name, "attenuatePointSize"), false);
        this.pointRadius = eap.getAttribute(ShaderUtility.nameSpace(name, "pointRadius"), 0.025);
        this.radiiWorldCoords = eap.getAttribute(ShaderUtility.nameSpace(name, "radiiWorldCoordinates"), false);
        this.diffuseColor = (Color)eap.getAttribute(ShaderUtility.nameSpace(name, "diffuseColor"), CommonAttributes.POINT_DIFFUSE_COLOR_DEFAULT);
        double t = eap.getAttribute(ShaderUtility.nameSpace(name, "transparency"), 0.0);
        this.diffuseColor = ShaderUtility.combineDiffuseColorWithTransparency(this.diffuseColor, t, JOGLRenderingState.useOldTransparency);
        this.diffuseColorAsFloat = this.diffuseColor.getRGBComponents(null);
        if (this.templateShader != null) {
            this.polygonShader = DefaultGeometryShader.createFrom(this.templateShader.getPolygonShader());
            this.polygonShader.setFromEffectiveAppearance(eap, name + ".polygonShader");
        } else {
            this.polygonShader = (PolygonShader)ShaderLookup.getShaderAttr(eap, name, "polygonShader");
        }
        if (!this.sphereDraw) {
            if (AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "pointSprite.texture2d"), eap)) {
                this.currentTex = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "pointSprite.texture2d"), eap);
            } else {
                Rn.normalize(this.lightDirection, this.lightDirection);
                this.specularColor = (Color)eap.getAttribute(ShaderUtility.nameSpace(name, "polygonShader.specularColor"), CommonAttributes.SPECULAR_COLOR_DEFAULT);
                this.specularColorAsFloat = this.specularColor.getRGBComponents(null);
                this.specularExponent = eap.getAttribute(ShaderUtility.nameSpace(name, "polygonShader.specularExponent"), 60.0);
                this.spriteNeedsUpdated = true;
                this.currentTex = this.spriteTexture;
            }
        }
    }

    public Color getDiffuseColor() {
        return this.diffuseColor;
    }

    private void setupTexture() {
        float sum = 0.0f;
        for (int i = 0; i < 4; ++i) {
            float diff = this.diffuseColorAsFloat[i] - this.oldDiffuseColorAsFloat[i];
            this.oldDiffuseColorAsFloat[i] = this.diffuseColorAsFloat[i];
            sum += Math.abs(diff);
        }
        this.spriteTexture.setImage(ShadedSphereImage.shadedSphereImage(this.lightDirection, this.diffuseColor, this.specularColor, this.specularExponent, textureSize, this.lighting, null));
        this.spriteTexture.setApplyMode(8448);
        this.spriteTexture.setMinFilter(9728);
    }

    private void preRender(JOGLRenderingState jrs) {
        JOGLRenderer jr = jrs.renderer;
        GL gl = jrs.renderer.globalGL;
        gl.glMaterialfv(1028, 4609, this.diffuseColorAsFloat, 0);
        gl.glColor4fv(this.diffuseColorAsFloat, 0);
        System.arraycopy(this.diffuseColorAsFloat, 0, jr.renderingState.diffuseColor, 0, 4);
        if (!this.sphereDraw) {
            PointSet ps = (PointSet)jrs.currentGeometry;
            if (this.spriteNeedsUpdated && jrs.lighting) {
                this.lighting = jrs.lighting;
                if (ps.getVertexAttributes(Attribute.COLORS) != null) {
                    this.diffuseColor = Color.white;
                }
                this.setupTexture();
                this.spriteNeedsUpdated = false;
            }
            this.lighting = false;
            gl.glPointSize((float)this.pointSize);
            jrs.pointSize = this.pointSize;
            try {
                gl.glPointParameterfv(33065, this.attenuatePointSize ? this.pointAttenuation : this.noPointAttentuation, 0);
            }
            catch (Exception e) {
                // empty catch block
            }
            gl.glEnable(2832);
            if (jrs.lighting) {
                gl.glEnable(34913);
                gl.glTexEnvi(34913, 34914, 1);
                if (this.currentTex == this.spriteTexture && ps.getVertexAttributes(Attribute.COLORS) != null) {
                    this.spriteTexture.setApplyMode(8448);
                } else {
                    this.spriteTexture.setApplyMode(7681);
                }
                gl.glActiveTexture(33984);
                gl.glEnable(3553);
                Texture2DLoaderJOGL.render(gl, this.currentTex);
            }
        } else {
            Geometry g = jrs.currentGeometry;
            jrs.currentGeometry = null;
            this.polygonShader.render(jrs);
            jrs.currentGeometry = g;
        }
        this.changedLighting = false;
        if (this.lighting != jrs.lighting) {
            if (this.lighting) {
                gl.glEnable(2896);
            } else {
                gl.glDisable(2896);
            }
            this.changedLighting = true;
        }
        this.changedTransp = false;
        if (this.opaqueSpheres == jrs.transparencyEnabled) {
            if (this.opaqueSpheres) {
                gl.glDepthMask(true);
                gl.glDisable(3042);
            } else {
                gl.glEnable(3042);
                gl.glDepthMask(jrs.zbufferEnabled);
                JOGLConfiguration.glBlendFunc(gl, this.useSrcAlphaBlending);
            }
            this.changedTransp = true;
        }
        if (this.useSrcAlphaBlending) {
            JOGLConfiguration.glBlendFunc(gl, this.useSrcAlphaBlending);
        }
    }

    public void postRender(JOGLRenderingState jrs) {
        if (!jrs.shadeGeometry) {
            return;
        }
        JOGLRenderer jr = jrs.renderer;
        GL gl = jr.globalGL;
        if (!this.sphereDraw) {
            gl.glDisable(34913);
            gl.glActiveTexture(33984);
            gl.glTexEnvi(34913, 34914, 0);
            gl.glDisable(3553);
        } else {
            this.polygonShader.postRender(jrs);
        }
        if (this.changedTransp) {
            if (jrs.transparencyEnabled) {
                gl.glEnable(3042);
                gl.glDepthMask(jrs.zbufferEnabled);
                JOGLConfiguration.glBlendFunc(gl, false);
            } else {
                gl.glDepthMask(true);
                gl.glDisable(3042);
            }
        }
        if (this.changedLighting) {
            if (jrs.lighting) {
                gl.glEnable(2896);
            } else {
                gl.glDisable(2896);
            }
        }
    }

    public boolean providesProxyGeometry() {
        return this.sphereDraw;
    }

    public int proxyGeometryFor(JOGLRenderingState jrs) {
        Geometry original = jrs.currentGeometry;
        JOGLRenderer jr = jrs.renderer;
        int sig = jrs.currentMetric;
        boolean useDisplayLists = jrs.useDisplayLists;
        GL gl = jr.globalGL;
        PointSet ps = (PointSet)original;
        DataList vertices = ps.getVertexAttributes(Attribute.COORDINATES);
        if (vertices == null) {
            return -1;
        }
        DataList piDL = ps.getVertexAttributes(Attribute.INDICES);
        IntArray vind = null;
        if (piDL != null) {
            vind = piDL.toIntArray();
        }
        DataList vertexColors = ps.getVertexAttributes(Attribute.COLORS);
        DataList radii = ps.getVertexAttributes(Attribute.RELATIVE_RADII);
        DoubleArray da = null;
        DoubleArray ra = null;
        if (radii != null) {
            ra = radii.toDoubleArray();
        }
        double radiiFactor = 1.0;
        if (this.radiiWorldCoords) {
            double[] o2w = jr.renderingState.currentPath.getMatrix(null);
            radiiFactor = CameraUtility.getScalingFactor(o2w, jr.renderingState.currentMetric);
            radiiFactor = 1.0 / radiiFactor;
        }
        int colorLength = 0;
        if (vertexColors != null) {
            colorLength = GeometryUtility.getVectorLength(vertexColors);
        }
        int n = ps.getNumPoints();
        int resolution = 1;
        if (jr.renderingState.levelOfDetail == 0.0) {
            resolution = 0;
        }
        int dlist = JOGLSphereHelper.getSphereDLists(resolution, jr);
        this.polygonCount = n * 24 * resolution * (resolution + 1) + 6;
        int nextDL = -1;
        if (useDisplayLists) {
            nextDL = gl.glGenLists(1);
            gl.glNewList(nextDL, 4864);
        }
        double[] mat = Rn.identityMatrix(4);
        double[] scale = Rn.identityMatrix(4);
        scale[5] = scale[10] = radiiFactor * this.pointRadius;
        scale[0] = scale[10];
        int length = n;
        for (int i = 0; i < length; ++i) {
            int index;
            double[] transVec;
            if (vind != null && vind.getValueAt(i) == 0 || !Pn.isValidCoordinate(transVec = vertices.item(index = i).toDoubleArray(null), 3, sig) || !P3.isValidTranslationVector(transVec, sig)) continue;
            if (ra != null) {
                double radius = ra.getValueAt(i);
                scale[5] = scale[10] = this.pointRadius * radius;
                scale[0] = scale[10];
            }
            gl.glPushMatrix();
            P3.makeTranslationMatrix(mat, transVec, sig);
            Rn.times(mat, mat, scale);
            gl.glMultTransposeMatrixd(mat, 0);
            if (vertexColors != null) {
                da = vertexColors.item(index).toDoubleArray();
                if (colorLength == 3) {
                    gl.glColor3d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2));
                } else if (colorLength == 4) {
                    gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), da.getValueAt(3));
                }
            }
            gl.glCallList(dlist);
            gl.glPopMatrix();
        }
        if (useDisplayLists) {
            gl.glEndList();
        }
        return nextDL;
    }

    public Shader getPolygonShader() {
        return this.polygonShader;
    }

    public void render(JOGLRenderingState jrs) {
        Geometry g = jrs.currentGeometry;
        JOGLRenderer jr = jrs.renderer;
        boolean useDisplayLists = jrs.useDisplayLists;
        if (!(g instanceof PointSet)) {
            throw new IllegalArgumentException("Must be PointSet");
        }
        if (jrs.shadeGeometry) {
            this.preRender(jrs);
        }
        if (g != null) {
            if (this.providesProxyGeometry()) {
                if (!useDisplayLists || this.dListProxy == -1) {
                    this.dListProxy = this.proxyGeometryFor(jrs);
                    this.displayListsDirty = false;
                }
                jr.globalGL.glCallList(this.dListProxy);
                jr.renderingState.polygonCount += this.polygonCount;
            } else if (!useDisplayLists) {
                JOGLRendererHelper.drawVertices(jr, (PointSet)g, jr.renderingState.diffuseColor[3]);
            } else {
                if (useDisplayLists && this.dList == -1) {
                    this.dList = jr.globalGL.glGenLists(1);
                    jr.globalGL.glNewList(this.dList, 4864);
                    JOGLRendererHelper.drawVertices(jr, (PointSet)g, jr.renderingState.diffuseColor[3]);
                    jr.globalGL.glEndList();
                    this.displayListsDirty = false;
                }
                jr.globalGL.glCallList(this.dList);
            }
        }
    }

    public void flushCachedState(JOGLRenderer jr) {
        LoggingSystem.getLogger(this).fine("PointShader: Flushing display lists " + this.dList + " : " + this.dListProxy);
        if (this.dList != -1) {
            jr.globalGL.glDeleteLists(this.dList, 1);
        }
        this.dListProxy = -1;
        this.dList = -1;
        this.displayListsDirty = true;
    }
}

