/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.geometry.FrameFieldType;
import de.jreality.geometry.IndexedLineSetUtility;
import de.jreality.geometry.PolygonalTubeFactory;
import de.jreality.geometry.TubeUtility;
import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRendererHelper;
import de.jreality.jogl.JOGLRenderingState;
import de.jreality.jogl.shader.AbstractPrimitiveShader;
import de.jreality.jogl.shader.DefaultGeometryShader;
import de.jreality.jogl.shader.GlslLoader;
import de.jreality.jogl.shader.LineShader;
import de.jreality.jogl.shader.NoneuclideanGLSLShader;
import de.jreality.jogl.shader.PolygonShader;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.Scene;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.IntArray;
import de.jreality.shader.CommonAttributes;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.GlslProgram;
import de.jreality.shader.ShaderUtility;
import de.jreality.util.CameraUtility;
import de.jreality.util.LoggingSystem;
import java.awt.Color;
import javax.media.opengl.GL;

public class DefaultLineShader
extends AbstractPrimitiveShader
implements LineShader {
    protected de.jreality.shader.DefaultLineShader templateShader = null;
    FrameFieldType tubeStyle = FrameFieldType.PARALLEL;
    double tubeRadius = 0.05;
    double lineWidth = 1.0;
    boolean lineStipple = false;
    int lineFactor = 1;
    int lineStipplePattern = 7239;
    boolean tubeDraw = false;
    boolean lineLighting = false;
    boolean opaqueTubes = false;
    boolean vertexColors = false;
    boolean radiiWorldCoords = false;
    Color diffuseColor = Color.BLACK;
    double[][] crossSection;
    double[][] defaultCrossSection = TubeUtility.octagonalCrossSection;
    private PolygonShader polygonShader;
    transient boolean changedTransp;
    transient boolean changedLighting;
    transient float[] diffuseColorAsFloat;
    transient int faceCount = 0;
    NoneuclideanGLSLShader noneuc = new NoneuclideanGLSLShader();
    boolean useGLSL;
    boolean hasNoneuc = false;
    GlslProgram glslProgram;
    int[] tubeDL = null;
    boolean testQMS = true;

    public DefaultLineShader(de.jreality.shader.DefaultLineShader orig) {
        this.templateShader = orig;
    }

    public DefaultLineShader() {
    }

    public void setFromEffectiveAppearance(EffectiveAppearance eap, String name) {
        super.setFromEffectiveAppearance(eap, name);
        this.useGLSL = eap.getAttribute(ShaderUtility.nameSpace(name, "useGLSL"), false);
        this.tubeDraw = eap.getAttribute(ShaderUtility.nameSpace(name, "tubeDraw"), true);
        this.tubeRadius = eap.getAttribute(ShaderUtility.nameSpace(name, "tubeRadius"), 0.025);
        this.opaqueTubes = eap.getAttribute(ShaderUtility.nameSpace(name, "opaqueTubesAndSpheres"), false);
        this.tubeStyle = (FrameFieldType)((Object)eap.getAttribute(ShaderUtility.nameSpace(name, "tubeStyle"), (Object)CommonAttributes.TUBE_STYLE_DEFAULT));
        this.lineLighting = eap.getAttribute(ShaderUtility.nameSpace(name, "lineLighting"), false);
        this.vertexColors = eap.getAttribute(ShaderUtility.nameSpace(name, "vertexColors"), false);
        this.radiiWorldCoords = eap.getAttribute(ShaderUtility.nameSpace(name, "radiiWorldCoordinates"), false);
        this.lineStipple = eap.getAttribute(ShaderUtility.nameSpace(name, "lineStipple"), this.lineStipple);
        this.lineWidth = eap.getAttribute(ShaderUtility.nameSpace(name, "lineWidth"), 1.0);
        this.lineFactor = eap.getAttribute(ShaderUtility.nameSpace(name, "lineFactor"), this.lineFactor);
        this.lineStipplePattern = eap.getAttribute(ShaderUtility.nameSpace(name, "lineStipplePattern"), this.lineStipplePattern);
        this.diffuseColor = (Color)eap.getAttribute(ShaderUtility.nameSpace(name, "diffuseColor"), CommonAttributes.LINE_DIFFUSE_COLOR_DEFAULT);
        double transp = eap.getAttribute(ShaderUtility.nameSpace(name, "transparency"), 0.0);
        this.diffuseColor = ShaderUtility.combineDiffuseColorWithTransparency(this.diffuseColor, transp, JOGLRenderingState.useOldTransparency);
        this.diffuseColorAsFloat = this.diffuseColor.getRGBComponents(null);
        this.crossSection = (double[][])eap.getAttribute(ShaderUtility.nameSpace(name, "crossSection"), this.defaultCrossSection);
        if (this.templateShader == null) {
            throw new IllegalStateException("Not from a template!");
        }
        this.polygonShader = DefaultGeometryShader.createFrom(this.templateShader.getPolygonShader());
        this.polygonShader.setFromEffectiveAppearance(eap, name + ".polygonShader");
        if (this.useGLSL) {
            if (GlslProgram.hasGlslProgram(eap, name)) {
                Appearance app = new Appearance();
                this.glslProgram = new GlslProgram(app, eap, name);
                this.hasNoneuc = false;
            } else {
                this.noneuc.setFromEffectiveAppearance(eap, name);
                this.glslProgram = this.noneuc.getNoneuclideanShader();
                this.hasNoneuc = true;
            }
        } else {
            this.hasNoneuc = false;
        }
    }

    public void preRender(JOGLRenderingState jrs) {
        JOGLRenderer jr = jrs.renderer;
        GL gl = jrs.renderer.globalGL;
        gl.glMaterialfv(1028, 4609, this.diffuseColorAsFloat, 0);
        gl.glColor4fv(this.diffuseColorAsFloat, 0);
        System.arraycopy(this.diffuseColorAsFloat, 0, jr.renderingState.diffuseColor, 0, 4);
        gl.glLineWidth((float)this.lineWidth);
        jrs.lineWidth = this.lineWidth;
        if (this.lineStipple) {
            gl.glEnable(2852);
            gl.glLineStipple(this.lineFactor, (short)this.lineStipplePattern);
        } else {
            gl.glDisable(2852);
        }
        this.changedLighting = false;
        if (this.tubeDraw) {
            Geometry g = jrs.currentGeometry;
            jrs.currentGeometry = null;
            this.polygonShader.render(jrs);
            jrs.currentGeometry = g;
        } else {
            if (this.lineLighting != jrs.lighting) {
                if (this.lineLighting) {
                    gl.glEnable(2896);
                } else {
                    gl.glDisable(2896);
                }
                this.changedLighting = true;
            }
            if (this.lineLighting) {
                this.polygonShader.render(jrs);
            }
        }
        this.changedTransp = false;
        if (this.tubeDraw) {
            if (this.opaqueTubes) {
                gl.glDepthMask(true);
                gl.glDisable(3042);
                jrs.currentAlpha = 1.0;
            } else {
                gl.glEnable(3042);
                gl.glDepthMask(jrs.zbufferEnabled);
                JOGLConfiguration.glBlendFunc(gl, false);
            }
            this.changedTransp = true;
        }
        if (!this.tubeDraw) {
            gl.glDepthRange(0.0, jrs.depthFudgeFactor);
        }
        if (this.useGLSL) {
            if (this.hasNoneuc) {
                this.noneuc.render(jr);
            }
            GlslLoader.render(this.glslProgram, jr);
        }
    }

    public void postRender(JOGLRenderingState jrs) {
        if (!jrs.shadeGeometry) {
            return;
        }
        JOGLRenderer jr = jrs.renderer;
        GL gl = jr.globalGL;
        if (this.useGLSL) {
            GlslLoader.postRender(this.glslProgram, gl);
        }
        if (!this.tubeDraw) {
            jr.globalGL.glDepthRange(0.0, 1.0);
        } else {
            this.polygonShader.postRender(jrs);
        }
        if (this.changedTransp) {
            if (jrs.transparencyEnabled) {
                gl.glEnable(3042);
                gl.glDepthMask(jrs.zbufferEnabled);
                JOGLConfiguration.glBlendFunc(gl, false);
            } else {
                gl.glDepthMask(true);
                gl.glDisable(3042);
            }
        }
        if (this.changedLighting) {
            if (jrs.lighting) {
                gl.glEnable(2896);
            } else {
                gl.glDisable(2896);
            }
        }
    }

    public boolean providesProxyGeometry() {
        return this.tubeDraw;
    }

    public int proxyGeometryFor(JOGLRenderingState jrs) {
        final Geometry original = jrs.currentGeometry;
        final JOGLRenderer jr = jrs.renderer;
        final boolean useDisplayLists = jrs.useDisplayLists;
        double factor = 1.0;
        if (this.radiiWorldCoords) {
            double[] o2w = jr.renderingState.currentPath.getMatrix(null);
            factor = CameraUtility.getScalingFactor(o2w, jr.renderingState.currentMetric);
            factor = 1.0 / factor;
        }
        final double radiusFactor = factor;
        if (this.tubeDraw && original instanceof IndexedLineSet) {
            final int[] dlist = new int[1];
            Scene.executeReader(original, new Runnable(){

                public void run() {
                    dlist[0] = DefaultLineShader.this.createTubesOnEdgesAsDL((IndexedLineSet)original, radiusFactor * DefaultLineShader.this.tubeRadius, jr, false, useDisplayLists);
                }
            });
            return dlist[0];
        }
        return -1;
    }

    public int createTubesOnEdgesAsDL(IndexedLineSet ils, double rad, JOGLRenderer jr, boolean pickMode, boolean useDisplayLists) {
        GL gl = jr.globalGL;
        double[] p1 = new double[4];
        double[] p2 = new double[4];
        p2[3] = 1.0;
        p1[3] = 1.0;
        double[][] oneCurve = null;
        int sig = jr.renderingState.currentMetric;
        DataList vertices = ils.getVertexAttributes(Attribute.COORDINATES);
        DataList radiidl = ils.getEdgeAttributes(Attribute.RELATIVE_RADII);
        DoubleArray radii = null;
        if (radiidl != null) {
            radii = radiidl.toDoubleArray();
        }
        if (ils.getNumPoints() <= 1) {
            return -1;
        }
        if (this.tubeDL == null) {
            this.tubeDL = new int[3];
        }
        if (this.tubeDL[sig + 1] == 0) {
            this.tubeDL[sig + 1] = gl.glGenLists(1);
            gl.glNewList(this.tubeDL[sig + 1], 4864);
            JOGLRendererHelper.drawFaces(jr, TubeUtility.urTube[sig + 1]);
            gl.glEndList();
        }
        this.faceCount = 0;
        int tubeFaces = TubeUtility.urTube[sig + 1].getNumFaces();
        int nextDL = -1;
        if (useDisplayLists) {
            nextDL = gl.glGenLists(1);
            gl.glNewList(nextDL, 4864);
        }
        double[] mat = new double[16];
        DataList edgec = ils.getEdgeAttributes(Attribute.COLORS);
        int n = ils.getNumEdges();
        for (int i = 0; i < n; ++i) {
            IntArray ia = ils.getEdgeAttributes(Attribute.INDICES).item(i).toIntArray();
            int m = ia.size();
            double effectiveRadius = rad;
            if (radii != null) {
                effectiveRadius = rad * radii.getValueAt(i);
            }
            if (pickMode) {
                gl.glPushName(i);
            }
            DoubleArray edgecolor = null;
            int clength = 3;
            if (edgec != null) {
                edgecolor = edgec.item(i).toDoubleArray();
                clength = edgecolor.size();
                if (clength == 3) {
                    gl.glColor3d(edgecolor.getValueAt(0), edgecolor.getValueAt(1), edgecolor.getValueAt(2));
                } else {
                    gl.glColor4d(edgecolor.getValueAt(0), edgecolor.getValueAt(1), edgecolor.getValueAt(2), edgecolor.getValueAt(3));
                }
            }
            if (m == 2 && !this.vertexColors || pickMode) {
                this.faceCount += (m - 1) * tubeFaces;
                for (int j = 0; j < m - 1; ++j) {
                    int xx;
                    int k = ia.getValueAt(j);
                    DoubleArray da = vertices.item(k).toDoubleArray();
                    int l = da.size();
                    for (xx = 0; xx < l; ++xx) {
                        p1[xx] = da.getValueAt(xx);
                    }
                    k = ia.getValueAt(j + 1);
                    da = vertices.item(k).toDoubleArray();
                    l = da.size();
                    for (xx = 0; xx < l; ++xx) {
                        p2[xx] = da.getValueAt(xx);
                    }
                    SceneGraphComponent cc = TubeUtility.tubeOneEdge(p1, p2, effectiveRadius, this.crossSection, sig);
                    if (cc.getGeometry() == null) continue;
                    if (pickMode) {
                        gl.glPushName(j);
                    }
                    gl.glPushMatrix();
                    gl.glMultTransposeMatrixd(cc.getTransformation().getMatrix(mat), 0);
                    gl.glCallList(this.tubeDL[sig + 1]);
                    gl.glPopMatrix();
                    if (!pickMode) continue;
                    gl.glPopName();
                }
            } else {
                oneCurve = IndexedLineSetUtility.extractCurve(oneCurve, ils, i);
                double[][] clrs = null;
                if (this.vertexColors) {
                    clrs = IndexedLineSetUtility.extractCurveColors(clrs, ils, i);
                }
                DataList dl = ils.getVertexAttributes(Attribute.RELATIVE_RADII);
                PolygonalTubeFactory ptf = new PolygonalTubeFactory(oneCurve);
                ptf.setClosed(false);
                if (clrs != null) {
                    ptf.setVertexColors(clrs);
                    ptf.setVertexColorsEnabled(true);
                }
                ptf.setCrossSection(this.crossSection);
                ptf.setFrameFieldType(this.tubeStyle);
                ptf.setMetric(sig);
                ptf.setRadius(effectiveRadius);
                if (dl != null) {
                    double[] relrad = IndexedLineSetUtility.extractRadii(null, ils, i);
                    double[] relrad2 = Rn.times(null, rad, relrad);
                    ptf.setRadii(relrad2);
                }
                ptf.update();
                IndexedFaceSet tube = ptf.getTube();
                if (tube != null) {
                    JOGLRendererHelper.drawFaces(jr, tube, jr.renderingState.smoothShading, jr.renderingState.diffuseColor[3]);
                    this.faceCount += tube.getNumFaces();
                }
            }
            if (!pickMode) continue;
            gl.glPopName();
        }
        if (useDisplayLists) {
            gl.glEndList();
        }
        return nextDL;
    }

    public void render(JOGLRenderingState jrs) {
        Geometry g = jrs.currentGeometry;
        JOGLRenderer jr = jrs.renderer;
        boolean useDisplayLists = jrs.useDisplayLists;
        if (!(g instanceof IndexedLineSet)) {
            throw new IllegalArgumentException("Must be IndexedLineSet");
        }
        if (jrs.shadeGeometry) {
            this.preRender(jrs);
        }
        if (g != null) {
            if (this.providesProxyGeometry()) {
                if (!useDisplayLists || this.dListProxy == -1) {
                    this.dListProxy = this.proxyGeometryFor(jrs);
                    this.displayListsDirty = false;
                }
                jr.globalGL.glCallList(this.dListProxy);
                jr.renderingState.polygonCount += this.faceCount;
            } else if (!useDisplayLists) {
                JOGLRendererHelper.drawLines(jr, (IndexedLineSet)g, this.vertexColors, jr.renderingState.diffuseColor[3]);
            } else {
                if (useDisplayLists && this.dList == -1) {
                    this.dList = jr.globalGL.glGenLists(1);
                    jr.globalGL.glNewList(this.dList, 4864);
                    JOGLRendererHelper.drawLines(jr, (IndexedLineSet)g, this.vertexColors, jr.renderingState.diffuseColor[3]);
                    jr.globalGL.glEndList();
                    this.displayListsDirty = false;
                }
                jr.globalGL.glCallList(this.dList);
            }
        }
    }

    public void flushCachedState(JOGLRenderer jr) {
        LoggingSystem.getLogger(this).fine("LineShader: Flushing display lists " + this.dList + " : " + this.dListProxy);
        if (this.dList != -1) {
            jr.globalGL.glDeleteLists(this.dList, 1);
        }
        if (this.dListProxy != -1) {
            jr.globalGL.glDeleteLists(this.dListProxy, 1);
        }
        this.dListProxy = -1;
        this.dList = -1;
        this.displayListsDirty = true;
        if (this.tubeDL != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.tubeDL[i] == 0) continue;
                jr.globalGL.glDeleteLists(this.tubeDL[i], 1);
                this.tubeDL[i] = 0;
            }
            this.tubeDL = null;
        }
    }
}

