/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.AbstractViewer;
import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.util.SceneGraphUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import javax.swing.JPanel;

public class ViewerAwt
extends AbstractViewer {
    protected GLCanvas canvas;
    private JPanel component;
    KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            ViewerAwt.this.component.dispatchEvent(e);
        }

        public void keyReleased(KeyEvent e) {
            ViewerAwt.this.component.dispatchEvent(e);
        }

        public void keyTyped(KeyEvent e) {
            ViewerAwt.this.component.dispatchEvent(e);
        }
    };
    MouseListener mouseListener = new MouseListener(){

        public void mouseClicked(MouseEvent e) {
            ViewerAwt.this.component.dispatchEvent(e);
        }

        public void mouseEntered(MouseEvent e) {
            ViewerAwt.this.component.dispatchEvent(e);
        }

        public void mouseExited(MouseEvent e) {
            ViewerAwt.this.component.dispatchEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            ViewerAwt.this.component.dispatchEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            ViewerAwt.this.component.dispatchEvent(e);
        }
    };
    MouseWheelListener mouseWheelListener = new MouseWheelListener(){

        public void mouseWheelMoved(MouseWheelEvent e) {
            ViewerAwt.this.component.dispatchEvent(e);
        }
    };
    MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        public void mouseDragged(MouseEvent e) {
            ViewerAwt.this.component.dispatchEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
            ViewerAwt.this.component.dispatchEvent(e);
        }
    };
    final Runnable bufferSwapper = new Runnable(){

        public void run() {
            ViewerAwt.this.drawable.swapBuffers();
        }
    };

    public ViewerAwt() {
        this(null, null);
    }

    public ViewerAwt(SceneGraphPath camPath, SceneGraphComponent root) {
        this.setAuxiliaryRoot(SceneGraphUtility.createFullSceneGraphComponent("AuxiliaryRoot"));
        this.initializeFrom(root, camPath);
    }

    protected void initializeFrom(SceneGraphComponent r, SceneGraphPath p) {
        this.setSceneRoot(r);
        this.setCameraPath(p);
        GLCapabilities caps = new GLCapabilities();
        caps.setAlphaBits(8);
        caps.setStereo(JOGLConfiguration.quadBufferedStereo);
        caps.setDoubleBuffered(true);
        GLContext sharedContext = (GLContext)firstOne.get();
        if (JOGLConfiguration.multiSample) {
            AbstractViewer.MultisampleChooser chooser = new AbstractViewer.MultisampleChooser();
            caps.setSampleBuffers(true);
            caps.setNumSamples(4);
            caps.setStereo(JOGLConfiguration.quadBufferedStereo);
            this.canvas = new GLCanvas(caps, (GLCapabilitiesChooser)chooser, sharedContext, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
        } else {
            this.canvas = new GLCanvas(caps);
        }
        this.drawable = this.canvas;
        JOGLConfiguration.getLogger().log(Level.INFO, "Caps is " + caps.toString());
        this.drawable.addGLEventListener((GLEventListener)this);
        if (JOGLConfiguration.quadBufferedStereo) {
            this.setStereoType(4);
        }
        if (JOGLConfiguration.sharedContexts && sharedContext == null) {
            firstOne = new WeakReference<GLContext>(this.drawable.getContext());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.component != null) {
            ((Component)this.drawable).removeKeyListener(this.keyListener);
            ((Component)this.drawable).removeMouseListener(this.mouseListener);
            ((Component)this.drawable).removeMouseMotionListener(this.mouseMotionListener);
            ((Component)this.drawable).removeMouseWheelListener(this.mouseWheelListener);
            this.component.removeAll();
            this.component = null;
        }
        if (this.drawable != null) {
            this.drawable.removeGLEventListener((GLEventListener)this);
        }
        this.drawable = null;
        this.canvas = null;
    }

    public Dimension getViewingComponentSize() {
        return ((Component)this.getViewingComponent()).getSize();
    }

    public Object getViewingComponent() {
        if (this.component == null) {
            this.component = new JPanel();
            this.component.setLayout(new BorderLayout());
            this.component.setMaximumSize(new Dimension(32768, 32768));
            this.component.setMinimumSize(new Dimension(10, 10));
            if (this.drawable == null) {
                return this.component;
            }
            this.component.add("Center", (Component)this.drawable);
            ((Component)this.drawable).addKeyListener(this.keyListener);
            ((Component)this.drawable).addMouseListener(this.mouseListener);
            ((Component)this.drawable).addMouseMotionListener(this.mouseMotionListener);
            ((Component)this.drawable).addMouseWheelListener(this.mouseWheelListener);
        }
        return this.component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAsync() {
        if (this.disposed) {
            return;
        }
        Object object = this.renderLock;
        synchronized (object) {
            if (!this.pendingUpdate) {
                if (this.debug) {
                    JOGLConfiguration.theLog.log(Level.INFO, "Render: invoke later");
                }
                EventQueue.invokeLater(this);
                this.pendingUpdate = true;
            }
        }
    }

    public GLAutoDrawable getDrawable() {
        return this.drawable;
    }

    public boolean hasViewingComponent() {
        return true;
    }

    public void display(GLAutoDrawable arg0) {
        this.renderer.display(arg0);
    }

    public void displayChanged(GLAutoDrawable arg0, boolean arg1, boolean arg2) {
        this.renderer.displayChanged(arg0, arg1, arg2);
    }

    public void reshape(GLAutoDrawable arg0, int arg1, int arg2, int arg3, int arg4) {
        this.renderer.reshape(arg0, arg1, arg2, arg3, arg4);
    }

    public void init(GLAutoDrawable arg0) {
        JOGLConfiguration.theLog.log(Level.INFO, "JOGL Context initialization, creating new renderer");
        this.renderer = new JOGLRenderer(this);
        this.renderer.init(arg0);
        this.renderer.setStereoType(this.stereoType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException();
        }
        Object object = this.renderLock;
        synchronized (object) {
            this.pendingUpdate = false;
            this.drawable.display();
            if (this.listeners != null) {
                this.broadcastChange();
            }
            this.renderLock.notifyAll();
        }
        if (this.debug) {
            JOGLConfiguration.theLog.log(Level.INFO, "Render: calling display");
        }
    }

    public void setAutoSwapMode(boolean autoSwap) {
        this.autoSwapBuffers = autoSwap;
        this.drawable.setAutoSwapBufferMode(autoSwap);
    }

    public void swapBuffers() {
        if (EventQueue.isDispatchThread()) {
            this.drawable.swapBuffers();
        } else {
            try {
                EventQueue.invokeAndWait(this.bufferSwapper);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean canRenderAsync() {
        return true;
    }

    public void render() {
        if (this.disposed) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.run();
        } else {
            try {
                EventQueue.invokeAndWait(this);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public BufferedImage renderOffscreen(int w, int h) {
        if (this.renderer != null) {
            return this.renderer.offscreenRenderer.renderOffscreen(w, h, this.drawable);
        }
        JOGLConfiguration.getLogger().log(Level.WARNING, "Renderer not initialized");
        return null;
    }

    public void renderOffscreen(int w, int h, File file) {
        if (this.renderer != null) {
            this.renderer.offscreenRenderer.renderOffscreen(w, h, file, this.drawable);
        } else {
            JOGLConfiguration.getLogger().log(Level.WARNING, "Renderer not initialized");
        }
    }
}

