/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.GoBetween;
import de.jreality.jogl.JOGLPeerComponent;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.util.LoggingSystem;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructPeerGraphVisitor
extends SceneGraphVisitor {
    SceneGraphComponent myRoot;
    JOGLPeerComponent thePeerRoot;
    JOGLPeerComponent myParent;
    SceneGraphPath sgp;
    boolean topLevel = true;
    JOGLRenderer jr;
    boolean singlePeer = false;
    static Class<? extends JOGLPeerComponent> peerClass = JOGLPeerComponent.class;

    public static void setPeerClass(Class<? extends JOGLPeerComponent> c) {
        peerClass = c;
    }

    public static void setPeerClass(String name) throws ClassNotFoundException {
        peerClass = Class.forName(name);
    }

    public ConstructPeerGraphVisitor(SceneGraphComponent r, JOGLPeerComponent p, JOGLRenderer jr) {
        this.myRoot = r;
        this.sgp = new SceneGraphPath();
        this.myParent = p;
        this.jr = jr;
    }

    private ConstructPeerGraphVisitor(ConstructPeerGraphVisitor pv, JOGLPeerComponent p) {
        this.sgp = new SceneGraphPath(pv.sgp);
        this.myParent = p;
        this.topLevel = false;
        this.jr = pv.jr;
    }

    protected static JOGLPeerComponent constructPeerForSceneGraphComponent(SceneGraphComponent sgc, JOGLPeerComponent p, JOGLRenderer jr) {
        if (sgc == null) {
            return null;
        }
        ConstructPeerGraphVisitor constructPeer = new ConstructPeerGraphVisitor(sgc, p, jr);
        JOGLPeerComponent peer = (JOGLPeerComponent)constructPeer.visit();
        return peer;
    }

    @Override
    public void visit(SceneGraphComponent c) {
        Object foo;
        boolean oldSinglePeer = this.singlePeer;
        if (c.getAppearance() != null && (foo = c.getAppearance().getAttribute("singlePeer", Boolean.class)) != null && foo instanceof Boolean) {
            this.singlePeer = (Boolean)foo;
        }
        this.sgp.push(c);
        GoBetween gb = GoBetween.goBetweenFor(this.jr, c, this.singlePeer);
        JOGLPeerComponent peer = null;
        boolean alreadySinglePeer = false;
        if (gb.isSinglePeer() && gb.getSinglePeer() != null) {
            peer = gb.getSinglePeer();
            alreadySinglePeer = true;
        } else {
            try {
                try {
                    peer = peerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (SecurityException se) {
                LoggingSystem.getLogger(this).warning("Security exception in setting configuration options");
            }
            peer.init(gb, this.sgp, this.myParent, this.jr);
        }
        if (this.topLevel) {
            this.thePeerRoot = peer;
        } else if (this.myParent != null) {
            int n = this.myParent.children.size();
            this.myParent.children.add(peer);
            peer.childIndex = n;
            this.myParent.childCount = n + 1;
        }
        if (!alreadySinglePeer) {
            c.childrenAccept(new ConstructPeerGraphVisitor(this, peer));
            this.sgp.pop();
            this.singlePeer = oldSinglePeer;
        }
    }

    public Object visit() {
        this.visit(this.myRoot);
        return this.thePeerRoot;
    }
}

