/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.io.jrs;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import de.jreality.io.JrScene;
import de.jreality.io.jrs.DataListConverter;
import de.jreality.io.jrs.DataListSetConverter;
import de.jreality.io.jrs.DoubleArrayConverter;
import de.jreality.io.jrs.FontConverter;
import de.jreality.io.jrs.ImageDataConverter;
import de.jreality.io.jrs.InputSlotConverter;
import de.jreality.io.jrs.IntArrayConverter;
import de.jreality.io.jrs.JrSceneConverter;
import de.jreality.io.jrs.MatrixConverter;
import de.jreality.io.jrs.SceneGraphNodeConverter;
import de.jreality.io.jrs.SceneGraphPathConverter;
import de.jreality.io.jrs.StringArrayConverter;
import de.jreality.math.FactoredMatrix;
import de.jreality.math.Matrix;
import de.jreality.math.Quaternion;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.Cylinder;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.Light;
import de.jreality.scene.PointLight;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Sphere;
import de.jreality.scene.SpotLight;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DataListSet;
import de.jreality.scene.data.StorageModel;
import de.jreality.scene.tool.InputSlot;
import de.jreality.shader.CubeMap;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.ImageData;
import de.jreality.shader.Texture2D;
import de.jreality.tools.DraggingTool;
import de.jreality.tools.EncompassTool;
import de.jreality.tools.FlyTool;
import de.jreality.tools.HeadTransformationTool;
import de.jreality.tools.PickShowTool;
import de.jreality.tools.RotateTool;
import de.jreality.tools.ShipNavigationTool;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.HashSet;

public class XStreamFactory {
    private static HashSet<Class<?>> knownClasses = new HashSet();

    public static XStream forVersion(double version) {
        if (version < 1.0) {
            return XStreamFactory.simpleXStream(version);
        }
        throw new IllegalArgumentException("no such version");
    }

    static XStream simpleXStream(double version) {
        XStream ret = new XStream((ReflectionProvider)new PureJavaReflectionProvider());
        ret.alias("Appearance", Appearance.class);
        ret.alias("Camera", Camera.class);
        ret.alias("ClippingPlane", ClippingPlane.class);
        ret.alias("Cylinder", Cylinder.class);
        ret.alias("DirectionalLight", DirectionalLight.class);
        ret.alias("IndexedFaceSet", IndexedFaceSet.class);
        ret.alias("IndexedLineSet", IndexedLineSet.class);
        ret.alias("Light", Light.class);
        ret.alias("PointLight", PointLight.class);
        ret.alias("PointSet", PointSet.class);
        ret.alias("SceneGraphComponent", SceneGraphComponent.class);
        ret.alias("Sphere", Sphere.class);
        ret.alias("SpotLight", SpotLight.class);
        ret.alias("Transformation", Transformation.class);
        ret.alias("Attribute", Attribute.class);
        ret.alias("DataList", DataList.class);
        ret.alias("DataListSet", DataListSet.class);
        ret.alias("StorageModel", StorageModel.class);
        ret.alias("DefaultPolygonShader", DefaultPolygonShader.class);
        ret.alias("DefaultLineShader", DefaultLineShader.class);
        ret.alias("DefaultPointShader", DefaultPointShader.class);
        ret.alias("Texture2D", Texture2D.class);
        ret.alias("CubeMap", CubeMap.class);
        ret.alias("ImageData", ImageData.class);
        ret.alias("scene", JrScene.class);
        ret.alias("Matrix", Matrix.class);
        ret.alias("FactoredMatrix", FactoredMatrix.class);
        ret.alias("Quaternion", Quaternion.class);
        ret.addImmutableType(InputSlot.class);
        ret.addImmutableType(Attribute.class);
        ret.addImmutableType(ImageData.class);
        ret.registerConverter((Converter)new JrSceneConverter(ret.getMapper()));
        ret.registerConverter((Converter)new SceneGraphNodeConverter(ret.getMapper()));
        ret.registerConverter((Converter)new SceneGraphPathConverter(ret.getMapper()));
        ret.registerConverter((Converter)new DataListSetConverter(ret.getMapper()));
        ret.registerConverter((Converter)new DataListConverter(ret.getMapper(), version));
        ret.registerConverter((Converter)new DoubleArrayConverter(ret.getMapper()));
        ret.registerConverter((Converter)new IntArrayConverter(ret.getMapper()));
        ret.registerConverter((Converter)new StringArrayConverter(ret.getMapper()));
        ret.registerConverter((Converter)new InputSlotConverter());
        ret.registerConverter((Converter)new MatrixConverter(ret.getMapper()));
        ret.registerConverter((Converter)new FontConverter(ret.getMapper()));
        ret.registerConverter((Converter)new ImageDataConverter(ret.getMapper()));
        return ret;
    }

    static Object readUnknown(HierarchicalStreamReader reader, UnmarshallingContext context, Mapper mapper) {
        Object ret = null;
        reader.moveDown();
        try {
            Class type = mapper.realClass(reader.getNodeName());
            ret = context.convertAnother(null, type);
        }
        catch (Exception e) {
            // empty catch block
        }
        reader.moveUp();
        return ret;
    }

    static void writeUnknown(Object src, HierarchicalStreamWriter writer, MarshallingContext context, Mapper mapper) {
        if (!XStreamFactory.canWrite(src)) {
            throw new IllegalArgumentException("cannot write: [" + src.getClass() + "]");
        }
        writer.startNode(mapper.serializedClass(src.getClass()));
        if (src != null) {
            context.convertAnother(src);
        }
        writer.endNode();
    }

    static boolean canWrite(Object val) {
        Class<?> clazz = val.getClass();
        if (clazz.isArray()) {
            return XStreamFactory.canWrite(clazz.getComponentType());
        }
        return clazz.isPrimitive() || knownClasses.contains(clazz);
    }

    static {
        knownClasses.add(Boolean.class);
        knownClasses.add(Byte.class);
        knownClasses.add(Double.class);
        knownClasses.add(Integer.class);
        knownClasses.add(Character.class);
        knownClasses.add(Float.class);
        knownClasses.add(Short.class);
        knownClasses.add(String.class);
        knownClasses.add(Class.class);
        knownClasses.add(Color.class);
        knownClasses.add(Font.class);
        knownClasses.add(Matrix.class);
        knownClasses.add(FactoredMatrix.class);
        knownClasses.add(Quaternion.class);
        knownClasses.add(ImageData.class);
        knownClasses.add(RotateTool.class);
        knownClasses.add(EncompassTool.class);
        knownClasses.add(DraggingTool.class);
        knownClasses.add(ShipNavigationTool.class);
        knownClasses.add(HeadTransformationTool.class);
        knownClasses.add(PickShowTool.class);
        knownClasses.add(FlyTool.class);
        knownClasses.add(HashMap.class);
        try {
            knownClasses.add(Class.forName("de.jreality.tools.PortalHeadMoveTool"));
        }
        catch (ClassNotFoundException e) {
            System.out.println("portal head move tool not found");
        }
    }
}

