/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.io.jrs;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import de.jreality.io.jrs.NodeReader;
import de.jreality.io.jrs.NodeWriter;
import de.jreality.scene.Scene;
import de.jreality.scene.SceneGraphNode;

class SceneGraphNodeConverter
implements Converter {
    Mapper mapper;
    NodeWriter nodeWriter = new NodeWriter();
    NodeReader nodeReader = new NodeReader();

    public SceneGraphNodeConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public boolean canConvert(Class type) {
        return SceneGraphNode.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        SceneGraphNode n = (SceneGraphNode)source;
        this.nodeWriter.setUp(writer, context, this.mapper);
        n.accept(this.nodeWriter);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class type;
        SceneGraphNode node = null;
        Class clazz = type = reader.getAttribute("type") == null ? context.getRequiredType() : this.mapper.realClass(reader.getAttribute("type"));
        if (!reader.hasMoreChildren()) {
            return null;
        }
        try {
            node = (SceneGraphNode)type.newInstance();
        }
        catch (Exception e) {
            return null;
        }
        this.nodeReader.setUp(reader, context, this.mapper);
        final SceneGraphNode fn = node;
        Scene.executeWriter(node, new Runnable(){

            public void run() {
                fn.accept(SceneGraphNodeConverter.this.nodeReader);
            }
        });
        return node;
    }
}

