/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.FrameFieldType;
import de.jreality.geometry.QuadMeshFactory;
import de.jreality.geometry.TubeFactory;
import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.StorageModel;
import de.jreality.util.LoggingSystem;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TubeUtility {
    static int debug;
    static Logger theLogger;
    static TubeUtility tubeUtilityInstance;
    public static double[][] diamondCrossSection;
    public static double[][] octagonalCrossSection;
    static double[] px1;
    static double[] px2;
    protected static double[] e1;
    public static IndexedFaceSet[] urTube;
    private static double[][] urTubeVerts;
    public static double[][] canonicalTranslation;
    private static double[] translation;
    private static int[] metrics;
    static int urTubeLength;

    private TubeUtility() {
        theLogger = LoggingSystem.getLogger(TubeUtility.class);
    }

    protected static double[] getInitialBinormal(double[][] polygon, int metric) {
        int n = polygon.length;
        double[] B = new double[4];
        for (int i = 1; i < n - 1; ++i) {
            Pn.polarize(B, P3.planeFromPoints(null, polygon[i - 1], polygon[i], polygon[i + 1]), metric);
            if (!(Rn.euclideanNormSquared(B) > 1.0E-15)) continue;
            return B;
        }
        B = new double[]{Math.random(), Math.random(), Math.random(), 1.0};
        return Pn.polarizePlane(null, P3.planeFromPoints(null, B, polygon[1], polygon[2]), metric);
    }

    public static SceneGraphComponent tubeOneEdge(double[] ip1, double[] ip2, double rad, double[][] crossSection, int metric) {
        return TubeUtility.tubeOneEdge(null, ip1, ip2, rad, crossSection, metric);
    }

    public static SceneGraphComponent tubeOneEdge(SceneGraphComponent sgc, double[] ip1, double[] ip2, double rad, double[][] crossSection, int metric) {
        if (ip1.length < 3 || ip1.length > 4 || ip2.length < 3 || ip2.length > 4) {
            throw new IllegalArgumentException("Invalid dimension");
        }
        double[] p1 = new double[4];
        double[] p2 = new double[4];
        if (ip1.length == 3) {
            Pn.homogenize(p1, ip1);
        } else {
            p1 = ip1;
        }
        if (ip2.length == 3) {
            Pn.homogenize(p2, ip2);
        } else {
            p2 = ip2;
        }
        boolean isValid1 = Pn.isValidCoordinate(p1, 3, metric);
        boolean isValid2 = Pn.isValidCoordinate(p2, 3, metric);
        if (!isValid1 && !isValid2) {
            return new SceneGraphComponent();
        }
        if (!isValid1) {
            Rn.linearCombination(p1, 0.99, p1, 0.01, p2);
        } else if (!isValid2) {
            Rn.linearCombination(p2, 0.99, p2, 0.01, p1);
        }
        Pn.normalize(p1, p1, metric);
        Pn.normalize(p2, p2, metric);
        if ((debug & 2) != 0) {
            theLogger.log(Level.FINE, "p1 is " + Rn.toString(p1));
        }
        if ((debug & 2) != 0) {
            theLogger.log(Level.FINE, "p2 is " + Rn.toString(p2));
        }
        double[] polarPlane = Pn.polarizePoint(null, p1, metric);
        if ((debug & 2) != 0) {
            theLogger.log(Level.FINE, "Polar plane is " + Rn.toString(polarPlane));
        }
        double[] tangent = P3.lineIntersectPlane(null, p1, p2, polarPlane);
        double[] diff = Rn.subtract(null, p2, p1);
        if (Rn.innerProduct(diff, tangent) < 0.0) {
            Rn.times(tangent, -1.0, tangent);
        }
        Pn.setToLength(tangent, tangent, 1.0, metric);
        double[] normal = Pn.polarizePlane(null, P3.planeFromPoints(null, p1, tangent, e1), metric);
        double[] binormal = Pn.polarizePlane(null, P3.planeFromPoints(null, p1, tangent, normal), metric);
        Pn.setToLength(normal, normal, 1.0, metric);
        Pn.setToLength(binormal, binormal, 1.0, metric);
        double[] frame = new double[16];
        System.arraycopy(binormal, 0, frame, 0, 4);
        System.arraycopy(normal, 0, frame, 4, 4);
        System.arraycopy(tangent, 0, frame, 8, 4);
        System.arraycopy(p1, 0, frame, 12, 4);
        if ((debug & 0x10) != 0) {
            theLogger.log(Level.FINE, "Frame is " + Rn.matrixToString(frame));
            theLogger.log(Level.FINE, "Det is " + Rn.determinant(frame));
        }
        Rn.transpose(frame, frame);
        double[] scaler = Rn.identityMatrix(4);
        double dist = Pn.distanceBetween(p1, p2, metric);
        double coord = dist / 2.0;
        if (Double.isNaN(coord)) {
            LoggingSystem.getLogger(TubeUtility.class).warning("bad coord");
            return new SceneGraphComponent();
        }
        if (metric == -1) {
            coord = Pn.tanh(dist / 2.0);
        } else if (metric == 1) {
            coord = Math.tan(dist / 2.0);
        }
        scaler[10] = 2.0 * coord;
        double radcoord = rad;
        if (metric == -1) {
            radcoord = Math.sqrt(1.0 - coord * coord) * Pn.tanh(rad);
        } else if (metric == 1) {
            radcoord = Math.sqrt(1.0 + coord * coord) * Math.tan(rad);
        }
        scaler[0] = scaler[5] = radcoord;
        if ((debug & 1) != 0) {
            theLogger.log(Level.FINE, "distance is \t" + dist + " scaler is \t" + coord + " and radius factor is \t" + radcoord);
        }
        double[] translate = new double[]{0.0, 0.0, coord, 1.0};
        double[] translateM = P3.makeTranslationMatrix(null, translate, metric);
        double[] net = Rn.times(null, frame, Rn.times(null, translateM, scaler));
        if ((debug & 0x40) != 0) {
            theLogger.log(Level.FINE, "net is \n" + Rn.matrixToString(net));
        }
        if (sgc == null) {
            sgc = new SceneGraphComponent();
        }
        sgc.setGeometry(urTube[metric + 1]);
        if (sgc.getTransformation() == null) {
            sgc.setTransformation(new Transformation());
        }
        sgc.getTransformation().setMatrix(net);
        return sgc;
    }

    public static void calculateAndSetNormalVectorsForCurve(IndexedLineSet ils) {
        double[][] polygon = ils.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        int n = polygon.length;
        double[][] normals = new double[n][4];
        if (n <= 1) {
            throw new IllegalArgumentException("Can't tube a vertex list of length less than 2");
        }
        double[][] polygon2 = new double[n + 2][];
        for (int i = 0; i < n; ++i) {
            polygon2[i + 1] = polygon[i];
            polygon2[0] = Rn.add(null, polygon[0], Rn.subtract(null, polygon[0], polygon[1]));
            polygon2[n + 1] = Rn.add(null, polygon[n - 1], Rn.subtract(null, polygon[n - 1], polygon[n - 2]));
        }
        FrameInfo[] frames = new TubeFactory().makeFrameField(polygon2, FrameFieldType.FRENET, 0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 4; ++j) {
                normals[i][j] = frames[i].frame[4 * j];
            }
            double[] dArray = normals[i];
            dArray[3] = dArray[3] * -1.0;
            Pn.normalize(normals[i], normals[i], 0);
        }
        ils.setVertexAttributes(Attribute.NORMALS, StorageModel.DOUBLE_ARRAY.array(4).createReadOnly(normals));
    }

    static {
        int n;
        debug = 0;
        theLogger = null;
        tubeUtilityInstance = null;
        tubeUtilityInstance = new TubeUtility();
        diamondCrossSection = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {-1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {1.0, 0.0, 0.0}};
        octagonalCrossSection = new double[][]{{1.0, 0.0, 0.0}, {0.707, 0.707, 0.0}, {0.0, 1.0, 0.0}, {-0.707, 0.707, 0.0}, {-1.0, 0.0, 0.0}, {-0.707, -0.707, 0.0}, {0.0, -1.0, 0.0}, {0.707, -0.707, 0.0}, {1.0, 0.0, 0.0}};
        px1 = new double[]{0.0, 0.0, -0.5, 1.0};
        px2 = new double[]{0.0, 0.0, 0.5, 1.0};
        e1 = new double[]{Math.random(), Math.random(), Math.random(), 1.0};
        urTube = new IndexedFaceSet[3];
        canonicalTranslation = new double[3][];
        translation = new double[]{0.0, 0.0, 0.5, 1.0};
        metrics = new int[]{-1, 0, 1};
        urTubeLength = n = octagonalCrossSection.length;
        urTubeVerts = new double[2 * n][3];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < n; ++j) {
                int q = n - j - 1;
                System.arraycopy(octagonalCrossSection[j], 0, urTubeVerts[i * n + q], 0, 3);
                TubeUtility.urTubeVerts[i * n + q][2] = i == 0 ? -0.5 : 0.5;
            }
        }
        DataList verts = StorageModel.DOUBLE_ARRAY.array(urTubeVerts[0].length).createReadOnly(urTubeVerts);
        for (int k = 0; k < 3; ++k) {
            TubeUtility.canonicalTranslation[k] = P3.makeTranslationMatrix(null, translation, metrics[k]);
            QuadMeshFactory qmf = new QuadMeshFactory();
            qmf.setMetric(0);
            qmf.setULineCount(n);
            qmf.setVLineCount(2);
            qmf.setClosedInUDirection(true);
            qmf.setVertexCoordinates(verts);
            qmf.setGenerateEdgesFromFaces(true);
            qmf.setEdgeFromQuadMesh(true);
            qmf.setGenerateFaceNormals(true);
            qmf.setGenerateVertexNormals(true);
            qmf.setGenerateTextureCoordinates(true);
            qmf.update();
            TubeUtility.urTube[k] = qmf.getIndexedFaceSet();
            urTube[k].setName("urTube" + k);
            if (k != 1) continue;
            urTube[k].setGeometryAttributes("rendermanProxyCommand", "Cylinder 1.0 -.5 .5 360");
        }
    }

    public static class FrameInfo {
        public double[] frame;
        double length;
        public double theta;
        public double phi;

        public FrameInfo(double[] f, double l, double t, double p) {
            this.frame = f;
            this.length = l;
            this.theta = t;
            this.phi = p;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Frame is\n" + Rn.matrixToString(this.frame));
            sb.append("Length is: " + this.length + "\n");
            sb.append("Theta is: " + this.theta + "\n");
            sb.append("Phi is: " + this.phi + "\n");
            return new String(sb);
        }
    }
}

