/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThickenedSurfaceFactory {
    IndexedFaceSet theSurface;
    IndexedFaceSet thickSurface;
    double thickness;
    boolean makeHoles = false;
    boolean curvedEdges = false;
    boolean linearHole = false;
    boolean thickenAlongFaceNormals = false;
    boolean mergeDuplicateBoundaryVerts = false;
    double holeFactor = 1.0;
    double shiftAlongNormal = 0.5;
    int stepsPerEdge = 3;
    int metric = 0;
    boolean keepFaceColors = false;
    double[][] profileCurve = new double[][]{{0.0, 0.0}, {0.5, 1.0}, {1.0, 0.0}};
    boolean getGoodTextureCoordinates = true;
    private IndexedFaceSetFactory thickSurfaceIFSF;
    private HashMap<SharedEdge, Integer> sharedVertices;
    private int[][] newIndices;
    private int[][] origIndices;
    private int[] faceOffsets;
    private List<Pair> edgelist;
    private List<SharedEdge> dupEdgeList;
    private int profileCurveSize;
    private double[][] origVertices;
    private double tolerance = 0.001;
    private double[][] allVertices;

    public ThickenedSurfaceFactory(IndexedFaceSet ifs) {
        this.theSurface = ifs;
    }

    public IndexedFaceSet getSurface() {
        return this.theSurface;
    }

    public boolean isMakeHoles() {
        return this.makeHoles;
    }

    public void setMakeHoles(boolean makeHoles) {
        this.makeHoles = makeHoles;
    }

    public double[][] getProfileCurve() {
        return this.profileCurve;
    }

    public void setProfileCurve(double[][] profileCurve) {
        this.profileCurve = profileCurve;
    }

    public int getStepsPerEdge() {
        return this.stepsPerEdge;
    }

    public void setStepsPerEdge(int stepsPerEdge) {
        this.stepsPerEdge = stepsPerEdge;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public double getHoleFactor() {
        return this.holeFactor;
    }

    public void setHoleFactor(double holeFactor) {
        this.holeFactor = holeFactor;
    }

    public boolean isKeepFaceColors() {
        return this.keepFaceColors;
    }

    public int getMetric() {
        return this.metric;
    }

    public void setMetric(int metric) {
        this.metric = metric;
    }

    public void setKeepFaceColors(boolean keepFaceColors) {
        this.keepFaceColors = keepFaceColors;
        if (keepFaceColors && this.theSurface.getFaceAttributes(Attribute.COLORS) == null) {
            this.keepFaceColors = false;
        }
    }

    public boolean isCurvedEdges() {
        return this.curvedEdges;
    }

    public void setCurvedEdges(boolean curvedEdges) {
        this.curvedEdges = curvedEdges;
    }

    public boolean isLinearHole() {
        return this.linearHole;
    }

    public void setLinearHole(boolean linearHole) {
        this.linearHole = linearHole;
    }

    public double getShiftAlongNormal() {
        return this.shiftAlongNormal;
    }

    public void setShiftAlongNormal(double shiftAlongNormal) {
        this.shiftAlongNormal = shiftAlongNormal;
    }

    public boolean isThickenAlongFaceNormals() {
        return this.thickenAlongFaceNormals;
    }

    public void setThickenAlongFaceNormals(boolean thickedAlongFaceNormals) {
        this.thickenAlongFaceNormals = thickedAlongFaceNormals;
    }

    public IndexedFaceSet getThickenedSurface() {
        if (this.thickSurfaceIFSF == null) {
            this.thickSurfaceIFSF = new IndexedFaceSetFactory();
        }
        return this.thickSurface;
    }

    public void update() {
        int i;
        int i2;
        if (this.thickSurfaceIFSF == null) {
            this.thickSurfaceIFSF = new IndexedFaceSetFactory();
        }
        this.origVertices = this.theSurface.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        double[][] oldVN = this.theSurface.getVertexAttributes(Attribute.NORMALS) == null ? IndexedFaceSetUtility.calculateVertexNormals(this.theSurface) : this.theSurface.getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray(null);
        this.origIndices = this.theSurface.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null);
        this.processBoundary();
        int originalVertexCount = this.origVertices.length;
        int fiberlength = this.origVertices[0].length;
        double[][] newVertices = new double[originalVertexCount * 2][4];
        if (oldVN[0].length == 3) {
            oldVN = Pn.homogenize((double[][])null, oldVN);
            for (int i3 = 0; i3 < oldVN.length; ++i3) {
                oldVN[i3][3] = 0.0;
            }
        }
        double[][] newVN = ThickenedSurfaceFactory.doubleIt(oldVN);
        for (int i4 = 0; i4 < originalVertexCount; ++i4) {
            System.arraycopy(this.origVertices[i4], 0, newVertices[i4], 0, fiberlength);
            if (fiberlength == 3) {
                newVertices[i4][3] = 1.0;
            }
            double[] tmp = Rn.linearCombination(null, 1.0, newVertices[i4], this.shiftAlongNormal * this.thickness, oldVN[i4]);
            Rn.linearCombination(newVertices[i4 + originalVertexCount], 1.0, newVertices[i4], (this.shiftAlongNormal - 1.0) * this.thickness, oldVN[i4]);
            System.arraycopy(tmp, 0, newVertices[i4], 0, tmp.length);
        }
        int numFaces = this.origIndices.length;
        int numBoundaryEdges = this.edgelist.size();
        this.newIndices = new int[numFaces * 2 + numBoundaryEdges][];
        for (i2 = 0; i2 < numFaces; ++i2) {
            this.newIndices[i2] = this.origIndices[i2];
            int k = this.origIndices[i2].length;
            this.newIndices[i2 + numFaces] = new int[k];
            for (int j = 0; j < k; ++j) {
                this.newIndices[i2 + numFaces][j] = this.makeHoles ? this.origIndices[i2][j] + originalVertexCount : this.origIndices[i2][k - 1 - j] + originalVertexCount;
            }
        }
        for (i2 = 0; i2 < numBoundaryEdges; ++i2) {
            this.newIndices[2 * numFaces + i2] = new int[4];
            Pair p = this.edgelist.get(i2);
            int h = p.h;
            int l = p.l;
            this.newIndices[2 * numFaces + i2][0] = h;
            this.newIndices[2 * numFaces + i2][1] = l;
            this.newIndices[2 * numFaces + i2][2] = l + originalVertexCount;
            this.newIndices[2 * numFaces + i2][3] = h + originalVertexCount;
        }
        ArrayList alreadyDone = new ArrayList();
        for (SharedEdge se : this.dupEdgeList) {
            Pair p1 = se.p1;
            Pair p2 = se.p2;
            System.err.println("handling duplicate edge");
            int fsize1 = this.origIndices[p1.face].length;
            int diff = originalVertexCount;
            int ul1 = this.origIndices[p1.face][p1.edge];
            int ur1 = this.origIndices[p1.face][(p1.edge + 1) % fsize1];
            int ll1 = ul1 + diff;
            int lr1 = ur1 + diff;
            int fsize2 = this.origIndices[p2.face].length;
            int ul2 = this.origIndices[p2.face][p2.edge];
            int ur2 = this.origIndices[p2.face][(p2.edge + 1) % fsize2];
            int ll2 = ul2 + diff;
            int lr2 = ur2 + diff;
            if (se.flipped) {
                int tmp = ul2;
                ul2 = ur2;
                ur2 = tmp;
                tmp = ll2;
                ll2 = lr2;
                lr2 = tmp;
            }
            boolean normalflip = false;
            double d1 = Rn.euclideanDistance(newVertices[ul1], newVertices[ul2]);
            double d2 = Rn.euclideanDistance(newVertices[ul1], newVertices[ll2]);
            if (d2 < d1) {
                normalflip = true;
            }
            if (normalflip) {
                int tmp = ul2;
                ul2 = ll2;
                ll2 = tmp;
                tmp = ur2;
                ur2 = lr2;
                lr2 = tmp;
            }
            System.err.println("leftright flip = " + se.flipped + "\tup-down flip = " + normalflip);
            this.mergeVertices(newVertices, ul1, ul2);
            this.mergeVertices(newVertices, ur1, ur2);
            this.mergeVertices(newVertices, ll1, ll2);
            this.mergeVertices(newVertices, lr1, lr2);
        }
        if (!this.makeHoles) {
            this.thickSurfaceIFSF.setVertexCount(2 * originalVertexCount);
            this.thickSurfaceIFSF.setFaceCount(2 * numFaces + numBoundaryEdges);
            this.thickSurfaceIFSF.setVertexCoordinates(newVertices);
            if (this.theSurface.getVertexAttributes(Attribute.COLORS) != null) {
                this.thickSurfaceIFSF.setVertexColors(ThickenedSurfaceFactory.doubleIt(this.theSurface.getVertexAttributes(Attribute.COLORS).toDoubleArray(null)));
            }
            if (this.theSurface.getVertexAttributes(Attribute.NORMALS) != null) {
                this.thickSurfaceIFSF.setGenerateVertexNormals(false);
                this.thickSurfaceIFSF.setVertexNormals(newVN);
            }
            if (this.theSurface.getVertexAttributes(Attribute.TEXTURE_COORDINATES) != null) {
                this.thickSurfaceIFSF.setVertexTextureCoordinates(ThickenedSurfaceFactory.doubleIt(this.theSurface.getVertexAttributes(Attribute.TEXTURE_COORDINATES).toDoubleArray(null)));
            }
            if (this.theSurface.getFaceAttributes(Attribute.COLORS) != null) {
                this.thickSurfaceIFSF.setFaceColors(ThickenedSurfaceFactory.doubleIt(this.theSurface.getFaceAttributes(Attribute.COLORS).toDoubleArrayArray(null), this.edgelist));
            }
            if (this.theSurface.getFaceAttributes(Attribute.NORMALS) != null) {
                this.thickSurfaceIFSF.setGenerateFaceNormals(true);
            }
            if (this.theSurface.getEdgeAttributes(Attribute.INDICES) != null) {
                this.thickSurfaceIFSF.setGenerateEdgesFromFaces(true);
            }
            this.thickSurfaceIFSF.setFaceIndices(this.newIndices);
            this.thickSurfaceIFSF.update();
            this.thickSurface = this.thickSurfaceIFSF.getIndexedFaceSet();
            return;
        }
        this.profileCurveSize = this.profileCurve.length;
        int totalEdges = 0;
        int allVerts = 0;
        for (int i5 = 0; i5 < numFaces; ++i5) {
            totalEdges += this.origIndices[i5].length;
            allVerts += (this.origIndices[i5].length * this.stepsPerEdge + 1) * this.profileCurveSize;
        }
        System.err.println("Found " + totalEdges + " edges");
        int allFaces = totalEdges * this.stepsPerEdge * (this.profileCurveSize - 1) + this.stepsPerEdge * numBoundaryEdges;
        System.err.println("Vert, face # = " + allVerts + " " + allFaces);
        this.allVertices = new double[allVerts][4];
        double[][] allTexCoords = new double[allVerts][2];
        int[][] allIndices = new int[allFaces][4];
        DoubleArrayArray oldFaceColors = null;
        Object newFaceColors = null;
        double[][] faceColorsWithoutHoles = null;
        if (this.keepFaceColors) {
            oldFaceColors = this.theSurface.getFaceAttributes(Attribute.COLORS).toDoubleArrayArray();
            newFaceColors = new double[allFaces][];
            faceColorsWithoutHoles = ThickenedSurfaceFactory.doubleIt(this.theSurface.getFaceAttributes(Attribute.COLORS).toDoubleArrayArray(null), this.edgelist);
        }
        int allVertCount = 0;
        int allFaceCount = 0;
        this.faceOffsets = new int[numFaces];
        for (i = 0; i < numFaces; ++i) {
            this.faceOffsets[i] = allVertCount;
            int[] bottomface = this.newIndices[i];
            int[] topface = this.newIndices[i + numFaces];
            double[] cb = ThickenedSurfaceFactory.centroid(bottomface, newVertices);
            double[] ct = ThickenedSurfaceFactory.centroid(topface, newVertices);
            int fsize = bottomface.length;
            int vertexCount = 0;
            int totalVerticesPerLoop = this.stepsPerEdge * fsize + 1;
            int totalVertsThisFace = this.profileCurveSize * totalVerticesPerLoop;
            double[][] borderBottom = this.linearHole(bottomface, newVertices, newVN, this.stepsPerEdge, this.curvedEdges);
            double[][] borderTop = this.linearHole(topface, newVertices, newVN, this.stepsPerEdge, this.curvedEdges);
            double[][] tangentQuadricBottom = null;
            double[][] tangentQuadricTop = null;
            if (this.linearHole) {
                tangentQuadricBottom = borderBottom;
                tangentQuadricTop = borderTop;
            } else if (this.curvedEdges) {
                double[][] controlpoints = this.linearHole(bottomface, newVertices, newVN, 2 * this.stepsPerEdge, this.curvedEdges);
                tangentQuadricBottom = ThickenedSurfaceFactory.quadraticCurvedHole(bottomface, this.stepsPerEdge, controlpoints);
                controlpoints = this.linearHole(topface, newVertices, newVN, 2 * this.stepsPerEdge, this.curvedEdges);
                tangentQuadricTop = ThickenedSurfaceFactory.quadraticCurvedHole(topface, this.stepsPerEdge, controlpoints);
            } else {
                tangentQuadricBottom = this.linearHole ? borderBottom : ThickenedSurfaceFactory.quadraticHole(bottomface, newVertices, this.stepsPerEdge);
                tangentQuadricTop = this.linearHole ? borderTop : ThickenedSurfaceFactory.quadraticHole(topface, newVertices, this.stepsPerEdge);
            }
            int[] nonDuplicateVertexIndicesForThisHole = new int[totalVertsThisFace];
            for (int k = 0; k < this.profileCurveSize; ++k) {
                double tu = (double)k / ((double)this.profileCurveSize - 1.0);
                if (tu > 1.0) {
                    tu = 1.0;
                }
                double u = this.profileCurve[k][0];
                double v = this.profileCurve[k][1] * this.holeFactor;
                for (int j = 0; j < totalVerticesPerLoop; ++j) {
                    double tv = (double)j / ((double)totalVerticesPerLoop - 1.0);
                    if (tv > 1.0) {
                        tv = 1.0;
                    }
                    double[] vb = null;
                    double[] vt = null;
                    if (k == 0 || k == this.profileCurveSize - 1) {
                        vb = borderBottom[j];
                        vt = borderTop[j];
                    } else {
                        vb = tangentQuadricBottom[j];
                        vt = tangentQuadricTop[j];
                    }
                    Rn.bilinearInterpolation(this.allVertices[allVertCount + vertexCount], u, v, vb, vt, cb, ct);
                    allTexCoords[allVertCount + vertexCount][0] = tu;
                    allTexCoords[allVertCount + vertexCount][1] = tv;
                    nonDuplicateVertexIndicesForThisHole[vertexCount] = allVertCount + vertexCount;
                    ++vertexCount;
                }
            }
            double[] oldFaceColor = null;
            if (this.keepFaceColors) {
                oldFaceColor = oldFaceColors.item(i).toDoubleArray(null);
            }
            int[] ndvi = nonDuplicateVertexIndicesForThisHole;
            for (int k = 0; k < this.profileCurveSize - 1; ++k) {
                for (int j = 0; j < totalVerticesPerLoop - 1; ++j) {
                    int[] thisF = allIndices[allFaceCount];
                    thisF[0] = ndvi[k * totalVerticesPerLoop + j];
                    thisF[1] = ndvi[k * totalVerticesPerLoop + (j + 1) % totalVerticesPerLoop];
                    thisF[2] = ndvi[(k + 1) * totalVerticesPerLoop + (j + 1) % totalVerticesPerLoop];
                    thisF[3] = ndvi[(k + 1) * totalVerticesPerLoop + j];
                    if (this.keepFaceColors) {
                        newFaceColors[allFaceCount] = oldFaceColor;
                    }
                    ++allFaceCount;
                }
            }
            allVertCount += totalVertsThisFace;
        }
        for (i = 0; i < this.edgelist.size(); ++i) {
            Pair p = this.edgelist.get(i);
            int offset = this.faceOffsets[p.face] + this.stepsPerEdge * p.edge;
            int fsize = this.origIndices[p.face].length;
            int diff = (this.profileCurveSize - 1) * (fsize * this.stepsPerEdge + 1);
            for (int i1 = 0; i1 < this.stepsPerEdge; ++i1) {
                int[] thisF = allIndices[allFaceCount];
                thisF[0] = offset + diff + i1;
                thisF[1] = offset + diff + 1 + i1;
                thisF[2] = offset + 1 + i1;
                thisF[3] = offset + i1;
                ++allFaceCount;
            }
        }
        this.thickSurfaceIFSF.setVertexCount(allVerts);
        this.thickSurfaceIFSF.setFaceCount(allFaces);
        this.thickSurfaceIFSF.setVertexCoordinates(this.allVertices);
        this.thickSurfaceIFSF.setVertexTextureCoordinates(allTexCoords);
        this.thickSurfaceIFSF.setFaceIndices(allIndices);
        if (this.keepFaceColors && newFaceColors != null) {
            this.thickSurfaceIFSF.setFaceColors((double[][])newFaceColors);
        }
        this.thickSurfaceIFSF.setGenerateEdgesFromFaces(true);
        this.thickSurfaceIFSF.setGenerateFaceNormals(true);
        this.thickSurfaceIFSF.setGenerateVertexNormals(true);
        this.thickSurfaceIFSF.update();
        this.thickSurface = this.thickSurfaceIFSF.getIndexedFaceSet();
    }

    private void mergeVertices(double[][] newVertices, int ul1, int ul2) {
        double[] v1 = newVertices[ul1];
        double[] v2 = newVertices[ul2];
        System.err.println("redefining vertices " + Rn.toString(v1));
        System.err.println("redefining vertices " + Rn.toString(v2));
        double[] vv = Rn.times(null, 0.5, Rn.add(null, v1, v2));
        newVertices[ul2] = vv;
        newVertices[ul1] = vv;
    }

    private void setVertex(int ii, double[] vv) {
        System.err.println("setting index " + ii);
        this.allVertices[ii] = vv;
    }

    private double[][] linearHole(int[] face, double[][] vv, double[][] nv, int stepsPerEdge, boolean curvedEdges) {
        double[][] values = new double[face.length * stepsPerEdge + 1][vv[0].length];
        int fsize = face.length;
        for (int j = 0; j < fsize; ++j) {
            double[] vb1 = vv[face[j]];
            double[] vb2 = vv[face[(j + 1) % fsize]];
            if (!curvedEdges) {
                for (int jj = 0; jj < stepsPerEdge; ++jj) {
                    double t = (double)jj / ((double)stepsPerEdge * 1.0);
                    Rn.linearCombination(values[j * stepsPerEdge + jj], 1.0 - t, vb1, t, vb2);
                }
                continue;
            }
            if (vb1.length == 3) {
                vb1 = Pn.homogenize(vb1, vb1);
                vb2 = Pn.homogenize(vb2, vb2);
            }
            double[] dv = Rn.subtract(null, vb2, vb1);
            double length = Pn.norm(dv, this.metric);
            double[] t1 = Pn.projectOntoComplement(null, nv[face[j]], dv, this.metric);
            Pn.setToLength(t1, t1, length / 3.0, this.metric);
            dv = Rn.subtract(null, vb1, vb2);
            double[] t2 = Pn.projectOntoComplement(null, nv[face[(j + 1) % fsize]], dv, this.metric);
            Pn.setToLength(t2, t2, length / 3.0, this.metric);
            double[] m1 = Rn.add(null, vb1, t1);
            double[] m2 = Rn.add(null, vb2, t2);
            for (int jj = 0; jj < stepsPerEdge; ++jj) {
                double t = (double)jj / ((double)stepsPerEdge * 1.0);
                Rn.bezierCombination(values[j * stepsPerEdge + jj], t, vb1, m1, m2, vb2);
            }
        }
        System.arraycopy(values[0], 0, values[values.length - 1], 0, values[0].length);
        return values;
    }

    private static double[][] quadraticHole(int[] face, double[][] vv, int stepsPerEdge) {
        int fsize = face.length;
        double[][] controlpoints = new double[2 * fsize][vv[0].length];
        for (int j = 0; j < fsize; ++j) {
            controlpoints[2 * j] = vv[face[j]];
            Rn.linearCombination(controlpoints[2 * j + 1], 0.5, vv[face[j]], 0.5, vv[face[(j + 1) % fsize]]);
        }
        return ThickenedSurfaceFactory.quadraticHole(face, stepsPerEdge, controlpoints);
    }

    private static double[][] quadraticHole(int[] face, int stepsPerEdge, double[][] controlpoints) {
        double[][] values = new double[face.length * stepsPerEdge + 1][controlpoints[0].length];
        int fsize = face.length;
        for (int j = 0; j < fsize; ++j) {
            int i0 = (2 * j + 1) % (2 * fsize);
            int i1 = (2 * j + 2) % (2 * fsize);
            int i2 = (2 * j + 3) % (2 * fsize);
            boolean even = stepsPerEdge % 2 == 0;
            for (int jj = 0; jj < stepsPerEdge; ++jj) {
                double t = (double)jj / ((double)stepsPerEdge * 1.0);
                if (!even) {
                    t += 0.5 / (double)stepsPerEdge;
                }
                double a0 = (1.0 - t) * (1.0 - t);
                double a1 = 2.0 * (1.0 - t) * t;
                double a2 = t * t;
                int index = (j * stepsPerEdge + (stepsPerEdge + 1) / 2 + jj + values.length - 1) % (values.length - 1);
                for (int k = 0; k < controlpoints[0].length; ++k) {
                    values[index][k] = a0 * controlpoints[i0][k];
                    double[] dArray = values[index];
                    int n = k;
                    dArray[n] = dArray[n] + a1 * controlpoints[i1][k];
                    double[] dArray2 = values[index];
                    int n2 = k;
                    dArray2[n2] = dArray2[n2] + a2 * controlpoints[i2][k];
                }
            }
        }
        System.arraycopy(values[0], 0, values[values.length - 1], 0, values[0].length);
        return values;
    }

    private static double[][] quadraticCurvedHole(int[] face, int stepsPerEdge, double[][] lch) {
        double[][] values = new double[face.length * stepsPerEdge + 1][lch[0].length];
        int lchl = lch.length;
        int fsize = face.length;
        for (int j = 0; j < fsize; ++j) {
            int i0 = (2 * stepsPerEdge * j + stepsPerEdge) % lchl;
            int i1 = 2 * stepsPerEdge * (j + 1) % lchl;
            for (int jj = 0; jj < stepsPerEdge; ++jj) {
                double t = (double)jj / ((double)stepsPerEdge * 1.0);
                double[] p1 = Rn.linearCombination(null, 1.0 - t, lch[(i0 + jj) % lchl], t, lch[(i1 + jj) % lchl]);
                int index = (j * stepsPerEdge + (stepsPerEdge + 1) / 2 + jj + values.length - 1) % (values.length - 1);
                values[index] = p1;
            }
        }
        System.arraycopy(values[0], 0, values[values.length - 1], 0, values[0].length);
        return values;
    }

    private static double[] centroid(int[] face, double[][] v) {
        double[] center = new double[v[0].length];
        for (int i = 0; i < face.length; ++i) {
            Rn.add(center, v[face[i]], center);
        }
        Rn.times(center, 1.0 / (double)face.length, center);
        return center;
    }

    private static double[] doubleIt(double[] data) {
        double[] newD = new double[data.length * 2];
        System.arraycopy(data, 0, newD, 0, data.length);
        System.arraycopy(data, 0, newD, data.length, data.length);
        return newD;
    }

    private static double[][] doubleIt(double[][] data) {
        double[][] newD = new double[data.length * 2][data[0].length];
        System.arraycopy(data, 0, newD, 0, data.length);
        System.arraycopy(data, 0, newD, data.length, data.length);
        return newD;
    }

    private static double[][] doubleIt(double[][] data, List<Pair> edges) {
        double[][] newD = new double[data.length * 2 + edges.size()][];
        for (int i = 0; i < data.length; ++i) {
            double[] dArray = data[i];
            newD[i + data.length] = dArray;
            newD[i] = dArray;
        }
        int n = 2 * data.length;
        for (int i = 0; i < edges.size(); ++i) {
            Pair p = edges.get(i);
            newD[n + i] = data[p.face];
        }
        return newD;
    }

    public void processBoundary() {
        DataList faceIndices = this.theSurface.getFaceAttributes(Attribute.INDICES);
        if (this.theSurface.getFaceAttributes(Attribute.attributeForName("faceIndices")) != null) {
            faceIndices = this.theSurface.getFaceAttributes(Attribute.attributeForName("faceIndices"));
        }
        DataList faceNormals = this.theSurface.getFaceAttributes(Attribute.NORMALS);
        double[][] fn = null;
        if (faceNormals != null) {
            fn = faceNormals.toDoubleArrayArray(null);
        }
        IntArrayArray faces = faceIndices.toIntArrayArray();
        this.edgelist = new ArrayList<Pair>();
        for (int i = 0; i < faces.getLength(); ++i) {
            IntArray f = faces.getValueAt(i);
            for (int j = 0; j < f.getLength(); ++j) {
                int j1;
                int i1 = f.getValueAt(j);
                Pair p = new Pair(i1, j1 = f.getValueAt((j + 1) % f.getLength()), i, j);
                if (this.edgelist.contains(p)) {
                    this.edgelist.remove(p);
                    continue;
                }
                this.edgelist.add(p);
            }
        }
        this.dupEdgeList = new ArrayList<SharedEdge>();
        if (this.mergeDuplicateBoundaryVerts) {
            ArrayList<Pair> toRemove = new ArrayList<Pair>();
            int n = this.edgelist.size();
            for (int i = 0; i < n; ++i) {
                Pair ip = this.edgelist.get(i);
                int length = this.origIndices[ip.face].length;
                int i0 = this.origIndices[ip.face][ip.edge];
                int i1 = this.origIndices[ip.face][(ip.edge + 1) % length];
                double[] v0i = this.origVertices[i0];
                double[] v1i = this.origVertices[i1];
                for (int j = i + 1; j < n; ++j) {
                    Pair jp = this.edgelist.get(j);
                    length = this.origIndices[jp.face].length;
                    int j0 = this.origIndices[jp.face][jp.edge];
                    int j1 = this.origIndices[jp.face][(jp.edge + 1) % length];
                    double[] v0j = this.origVertices[j0];
                    double[] v1j = this.origVertices[j1];
                    double d00 = Rn.euclideanDistance(v0i, v0j);
                    double d11 = Rn.euclideanDistance(v1i, v1j);
                    double d01 = Rn.euclideanDistance(v0i, v1j);
                    double d10 = Rn.euclideanDistance(v1i, v0j);
                    SharedEdge se = null;
                    if (d00 < this.tolerance && d11 < this.tolerance) {
                        se = new SharedEdge(ip, jp, false);
                    }
                    if (d01 < this.tolerance && d10 < this.tolerance) {
                        se = new SharedEdge(ip, jp, true);
                    }
                    if (se == null) continue;
                    this.dupEdgeList.add(se);
                    toRemove.add(ip);
                    toRemove.add(jp);
                }
            }
            System.err.println("Found duplicate edges: " + this.dupEdgeList.size());
            this.edgelist.removeAll(toRemove);
        }
    }

    public boolean isMergeDuplicateBoundaryVerts() {
        return this.mergeDuplicateBoundaryVerts;
    }

    public void setMergeDuplicateBoundaryVerts(boolean b) {
        this.mergeDuplicateBoundaryVerts = b;
    }

    private static final class Pair {
        final int l;
        final int h;
        final int face;
        final int edge;
        boolean flipped = false;

        Pair(int a, int b, int c, int d) {
            if (a <= b) {
                this.flipped = true;
            }
            this.l = a;
            this.h = b;
            this.face = c;
            this.edge = d;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            try {
                Pair p = (Pair)obj;
                boolean sameSense = this.l == p.l && this.h == p.h;
                boolean flippedSense = this.l == p.h && this.h == p.l;
                return flippedSense || sameSense;
            }
            catch (ClassCastException ex) {
                return false;
            }
        }

        public int hashCode() {
            return this.l << 16 ^ this.h;
        }
    }

    private static final class SharedEdge {
        Pair p1;
        Pair p2;
        boolean flipped;

        SharedEdge(Pair p1, Pair p2, boolean f) {
            this.p1 = p1;
            this.p2 = p2;
            this.flipped = f;
        }
    }
}

