/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.math.Rn;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.Scene;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StorageModel;

public class IndexedLineSetUtility {
    private IndexedLineSetUtility() {
    }

    public static IndexedLineSet refine(IndexedLineSet ils, int n) {
        int[][] indices = ils.getEdgeAttributes(Attribute.INDICES).toIntArrayArray(null);
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i].length == 2) continue;
            throw new IllegalArgumentException("Edge array can have only 2 points per curve");
        }
        double[][] verts = ils.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        int numEdges = ils.getNumEdges();
        int veclength = verts[0].length;
        double[][] newVerts = new double[n * numEdges][veclength];
        int[][] newIndices = new int[numEdges][n];
        for (int i = 0; i < numEdges; ++i) {
            int i0 = indices[i][0];
            int i1 = indices[i][1];
            double[] p0 = verts[i0];
            double[] p1 = verts[i1];
            for (int j = 0; j < n; ++j) {
                double t = (double)j / ((double)n - 1.0);
                double s = 1.0 - t;
                newVerts[i * n + j] = Rn.linearCombination(null, s, p0, t, p1);
                newIndices[i][j] = i * n + j;
            }
        }
        IndexedLineSetFactory ifsf = new IndexedLineSetFactory();
        ifsf.setVertexCount(newVerts.length);
        ifsf.setVertexCoordinates(newVerts);
        ifsf.setEdgeCount(newIndices.length);
        ifsf.setEdgeIndices(newIndices);
        ifsf.update();
        return ifsf.getIndexedLineSet();
    }

    public static double[][] extractCurve(double[][] curve, IndexedLineSet ils, int i) {
        DataList verts = ils.getVertexAttributes(Attribute.COORDINATES);
        DataList indices = ils.getEdgeAttributes(Attribute.INDICES);
        IntArray thisEdge = indices.item(i).toIntArray();
        int n = thisEdge.getLength();
        Object output = null;
        output = curve == null || curve.length != n ? (Object)new double[n][] : curve;
        for (int j = 0; j < n; ++j) {
            int which = thisEdge.getValueAt(j);
            output[j] = verts.item(which).toDoubleArray(null);
        }
        return output;
    }

    public static double[][] extractCurveColors(double[][] curve, IndexedLineSet ils, int i) {
        DataList verts = ils.getVertexAttributes(Attribute.COLORS);
        if (verts == null) {
            return null;
        }
        DataList indices = ils.getEdgeAttributes(Attribute.INDICES);
        IntArray thisEdge = indices.item(i).toIntArray();
        int n = thisEdge.getLength();
        Object output = null;
        output = curve == null || curve.length != n ? (Object)new double[n][] : curve;
        for (int j = 0; j < n; ++j) {
            int which = thisEdge.getValueAt(j);
            output[j] = verts.item(which).toDoubleArray(null);
        }
        return output;
    }

    public static double[] extractRadii(double[] curve, IndexedLineSet ils, int i) {
        DoubleArray verts = ils.getVertexAttributes(Attribute.RELATIVE_RADII).toDoubleArray();
        if (verts == null) {
            return null;
        }
        DataList indices = ils.getEdgeAttributes(Attribute.INDICES);
        IntArray thisEdge = indices.item(i).toIntArray();
        int n = thisEdge.getLength();
        double[] output = null;
        output = curve == null || curve.length != n ? new double[n] : curve;
        for (int j = 0; j < n; ++j) {
            int which = thisEdge.getValueAt(j);
            output[j] = verts.getValueAt(which);
        }
        return output;
    }

    public static IndexedLineSet createCurveFromPoints(double[][] points, boolean closed) {
        return IndexedLineSetUtility.createCurveFromPoints(null, points, closed);
    }

    public static IndexedLineSet createCurveFromPoints(IndexedLineSet g, final double[][] points, boolean closed) {
        int size;
        int n = points.length;
        int n2 = size = closed ? n + 1 : n;
        if (g == null) {
            g = new IndexedLineSet(n, 1);
        }
        final IndexedLineSet ils = g;
        final int[][] ind = new int[1][size];
        for (int i = 0; i < size; ++i) {
            ind[0][i] = i % n;
        }
        final int vectorLength = points[0].length;
        Scene.executeWriter(ils, new Runnable(){

            public void run() {
                ils.setEdgeCountAndAttributes(Attribute.INDICES, new IntArrayArray.Array(ind));
                ils.setVertexCountAndAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(vectorLength).createWritableDataList(points));
            }
        });
        return g;
    }

    public static IndexedLineSet createCurveFromPoints(double[] points, int fiber, boolean closed) {
        return IndexedLineSetUtility.createCurveFromPoints(null, points, fiber, closed);
    }

    public static IndexedLineSet createCurveFromPoints(IndexedLineSet g, final double[] points, final int fiber, final int[][] indices) {
        int n = points.length / fiber;
        if (g == null) {
            g = new IndexedLineSet(n, indices.length);
        }
        final IndexedLineSet ils = g;
        Scene.executeWriter(ils, new Runnable(){

            public void run() {
                ils.setEdgeCountAndAttributes(Attribute.INDICES, new IntArrayArray.Array(indices));
                ils.setVertexCountAndAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.inlined(fiber).createWritableDataList(points));
            }
        });
        return g;
    }

    public static IndexedLineSet createCurveFromPoints(IndexedLineSet g, double[] points, int fiber, boolean closed) {
        int n = points.length / fiber;
        int size = closed ? n + 1 : n;
        int[][] ind = new int[1][size];
        for (int i = 0; i < size; ++i) {
            ind[0][i] = i % n;
        }
        return IndexedLineSetUtility.createCurveFromPoints(g, points, fiber, ind);
    }

    public static IndexedLineSet circle(int n, double cx, double cy, double r) {
        double[][] verts = new double[n][3];
        double angle = 0.0;
        double delta = Math.PI * 2 / (double)n;
        for (int i = 0; i < n; ++i) {
            angle = (double)i * delta;
            verts[i][0] = cx + r * Math.cos(angle);
            verts[i][1] = cy + r * Math.sin(angle);
        }
        return IndexedLineSetUtility.createCurveFromPoints(verts, true);
    }

    public static IndexedLineSet circle(int n) {
        return IndexedLineSetUtility.circle(n, 0.0, 0.0, 1.0);
    }
}

