/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.AbstractGeometryFactory;
import de.jreality.geometry.BoundingBoxUtility;
import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.math.Rn;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Sphere;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.util.LoggingSystem;
import de.jreality.util.Rectangle3D;
import de.jreality.util.SceneGraphUtility;
import java.util.logging.Level;

public class GeometryUtility {
    public static String BOUNDING_BOX = "boundingBox";
    public static String QUAD_MESH_SHAPE = "quadMesh";
    public static String HEIGHT_FIELD_SHAPE = "heightField";
    public static String METRIC = "metric";
    public static String FACTORY = "factory";

    private GeometryUtility() {
    }

    public static int getMetric(Geometry g) {
        Object sigO = g.getGeometryAttributes(METRIC);
        int sig = 0;
        if (sigO != null && sigO instanceof Integer) {
            sig = (Integer)sigO;
        }
        return sig;
    }

    public static AbstractGeometryFactory getFactory(Geometry g) {
        Object factory = g.getGeometryAttributes(FACTORY);
        if (factory != null && factory instanceof AbstractGeometryFactory) {
            LoggingSystem.getLogger(GeometryUtility.class).log(Level.FINER, "Factory found");
            return (AbstractGeometryFactory)factory;
        }
        return null;
    }

    public static void setMetric(Geometry g, int s) {
        Object o = g.getGeometryAttributes(METRIC);
        if (o != null && o instanceof Integer && (Integer)o == s) {
            return;
        }
        g.setGeometryAttributes(METRIC, new Integer(s));
    }

    public static int getVectorLength(DataList ps) {
        int[] dims = ps.getStorageModel().getDimensions(ps);
        int vl = dims[dims.length - 1];
        if (vl == -1) {
            ps = (DataList)ps.item(0);
            vl = ps.size();
        }
        return vl;
    }

    public static int getVectorLength(PointSet ps) {
        DataList vv = ps.getVertexAttributes(Attribute.COORDINATES);
        return GeometryUtility.getVectorLength(vv);
    }

    public static Rectangle3D calculateBoundingBox(double[] initialMatrix, SceneGraphComponent sgc) {
        return BoundingBoxUtility.calculateBoundingBox(initialMatrix, sgc);
    }

    public static Rectangle3D calculateBoundingBox(double[][] verts) {
        return BoundingBoxUtility.calculateBoundingBox(verts);
    }

    public static Rectangle3D calculateBoundingBox(PointSet ps) {
        return BoundingBoxUtility.calculateBoundingBox(ps);
    }

    public static Rectangle3D calculateBoundingBox(SceneGraphComponent sgc) {
        return BoundingBoxUtility.calculateBoundingBox(sgc);
    }

    public static Rectangle3D calculateBoundingBox(Sphere sph) {
        return BoundingBoxUtility.calculateBoundingBox(sph);
    }

    public static Rectangle3D calculateChildrenBoundingBox(SceneGraphComponent sgc) {
        return BoundingBoxUtility.calculateChildrenBoundingBox(sgc);
    }

    public static void calculateAndSetFaceNormals(IndexedFaceSet ifs) {
        IndexedFaceSetUtility.calculateAndSetFaceNormals(ifs);
    }

    public static void calculateAndSetNormals(IndexedFaceSet ifs) {
        IndexedFaceSetUtility.calculateAndSetNormals(ifs);
    }

    public static void calculateAndSetVertexNormals(IndexedFaceSet ifs) {
        IndexedFaceSetUtility.calculateAndSetVertexNormals(ifs);
    }

    public static double[][] calculateFaceNormals(IndexedFaceSet ifs) {
        return IndexedFaceSetUtility.calculateFaceNormals(ifs);
    }

    public static double[][] calculateFaceNormals(IndexedFaceSet ifs, int metric) {
        return IndexedFaceSetUtility.calculateFaceNormals(ifs, metric);
    }

    public static double[][] calculateFaceNormals(int[][] indices, double[][] verts, int metric) {
        return IndexedFaceSetUtility.calculateFaceNormals(indices, verts, metric);
    }

    public static void calculateFaceNormals(SceneGraphComponent c) {
        IndexedFaceSetUtility.calculateFaceNormals(c);
    }

    public static double[][] calculateVertexNormals(IndexedFaceSet ifs) {
        return IndexedFaceSetUtility.calculateVertexNormals(ifs);
    }

    public static double[][] calculateVertexNormals(IndexedFaceSet ifs, int metric) {
        return IndexedFaceSetUtility.calculateVertexNormals(ifs, metric);
    }

    public static double[][] calculateVertexNormals(int[][] indices, double[][] vertsAs2D, double[][] fn, int metric) {
        return IndexedFaceSetUtility.calculateVertexNormals(indices, vertsAs2D, fn, metric);
    }

    public static void calculateVertexNormals(SceneGraphComponent c) {
        IndexedFaceSetUtility.calculateVertexNormals(c);
    }

    public static SceneGraphComponent flatten(SceneGraphComponent sgc) {
        return SceneGraphUtility.flatten(sgc);
    }

    public static SceneGraphComponent flatten(SceneGraphComponent sgc, boolean rejectInvis) {
        return SceneGraphUtility.flatten(sgc, rejectInvis);
    }

    static double[] convert2dArrayTo1dArray(double[] target, double[][] src) {
        return Rn.convertArray2DToArray1D(target, src);
    }
}

