/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.backends.label;

import de.jreality.geometry.Primitives;
import de.jreality.math.P3;
import de.jreality.math.Rn;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StringArray;
import de.jreality.shader.ImageData;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;

public class LabelUtility {
    private static final ReferenceQueue refQueue = new ReferenceQueue();
    private static final WeakHashMap geometryToRefs = new WeakHashMap();
    private static final HashMap refsToImageMaps = new HashMap();
    private static final HashMap refsToAccessTimeMaps = new HashMap();
    private static final Object CACHE_MUTEX = new Object();
    private static final int MAX_UNUSED_COUNT = 10;
    private static final FontRenderContext frc;
    private static BufferedImage bi;
    private static Color TRANSPARENT;
    private static final IndexedFaceSet bb;

    private LabelUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageData[] createImages(Geometry geom, int type, StringArray labels, Color color, Font font) {
        ImageData[] ret = new ImageData[labels.getLength()];
        Object object = CACHE_MUTEX;
        synchronized (object) {
            Key key;
            HashMap<String, ImageData> strToImages;
            HashMap<Key, int[]> keyToAccess;
            HashMap keyToImageMap;
            Reference ref = refQueue.poll();
            while (ref != null) {
                HashMap del = (HashMap)refsToImageMaps.remove(ref);
                ref = refQueue.poll();
            }
            WeakReference<Geometry> wref = (WeakReference<Geometry>)geometryToRefs.get(geom);
            if (wref == null) {
                wref = new WeakReference<Geometry>(geom, refQueue);
                geometryToRefs.put(geom, wref);
            }
            if ((keyToImageMap = (HashMap)refsToImageMaps.get(wref)) == null) {
                keyToImageMap = new HashMap();
                refsToImageMaps.put(wref, keyToImageMap);
            }
            if ((keyToAccess = (HashMap<Key, int[]>)refsToAccessTimeMaps.get(wref)) == null) {
                keyToAccess = new HashMap<Key, int[]>();
                refsToAccessTimeMaps.put(wref, keyToAccess);
            }
            if ((strToImages = (HashMap<String, ImageData>)keyToImageMap.get(key = new Key(type, font, color))) == null) {
                strToImages = new HashMap<String, ImageData>();
                keyToImageMap.put(key, strToImages);
                keyToAccess.put(key, new int[1]);
            }
            int[] accessCount = (int[])keyToAccess.get(key);
            LinkedList<String> remainingStrings = new LinkedList<String>();
            int n = labels.getLength();
            for (int i = 0; i < n; ++i) {
                String str = labels.getValueAt(i);
                ret[i] = (ImageData)strToImages.get(str);
                remainingStrings.add(str);
                if (ret[i] != null) continue;
                ret[i] = new ImageData(LabelUtility.createImageFromString(str, font, color));
                strToImages.put(str, ret[i]);
            }
            accessCount[0] = -1;
            Iterator iter = keyToAccess.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                int[] unusedCnt = (int[])e.getValue();
                unusedCnt[0] = unusedCnt[0] + 1;
                if (unusedCnt[0] <= 10) continue;
                iter.remove();
                Key removeKey = (Key)e.getKey();
                keyToImageMap.remove(removeKey);
            }
            for (Map.Entry e : keyToImageMap.entrySet()) {
                Key k = (Key)e.getKey();
                if (key.type != k.type) continue;
                HashMap strToImgs = (HashMap)e.getValue();
                strToImgs.keySet().retainAll(remainingStrings);
            }
            strToImages.keySet().retainAll(remainingStrings);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageData[] createImages(Geometry geom, int type, StringArray labels, Color[] colors, Font font) {
        ImageData[] ret = new ImageData[labels.getLength()];
        Object object = CACHE_MUTEX;
        synchronized (object) {
            HashMap<Key, int[]> keyToAccess;
            HashMap keyToImageMap;
            Reference ref = refQueue.poll();
            while (ref != null) {
                HashMap del = (HashMap)refsToImageMaps.remove(ref);
                ref = refQueue.poll();
            }
            WeakReference<Geometry> wref = (WeakReference<Geometry>)geometryToRefs.get(geom);
            if (wref == null) {
                wref = new WeakReference<Geometry>(geom, refQueue);
                geometryToRefs.put(geom, wref);
            }
            if ((keyToImageMap = (HashMap)refsToImageMaps.get(wref)) == null) {
                keyToImageMap = new HashMap();
                refsToImageMaps.put(wref, keyToImageMap);
            }
            if ((keyToAccess = (HashMap<Key, int[]>)refsToAccessTimeMaps.get(wref)) == null) {
                keyToAccess = new HashMap<Key, int[]>();
                refsToAccessTimeMaps.put(wref, keyToAccess);
            }
            LinkedList<String> remainingStrings = new LinkedList<String>();
            int n = labels.getLength();
            for (int i = 0; i < n; ++i) {
                String str = labels.getValueAt(i);
                Key key = new Key(type, font, colors[i]);
                HashMap<String, ImageData> strToImages = (HashMap<String, ImageData>)keyToImageMap.get(key);
                if (strToImages == null) {
                    strToImages = new HashMap<String, ImageData>();
                    keyToImageMap.put(key, strToImages);
                    keyToAccess.put(key, new int[1]);
                }
                int[] accessCount = (int[])keyToAccess.get(key);
                ret[i] = (ImageData)strToImages.get(str);
                remainingStrings.add(str);
                if (ret[i] == null) {
                    ret[i] = new ImageData(LabelUtility.createImageFromString(str, font, colors[i]));
                    strToImages.put(str, ret[i]);
                }
                accessCount[0] = -1;
            }
            Iterator iter = keyToAccess.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                int[] unusedCnt = (int[])e.getValue();
                unusedCnt[0] = unusedCnt[0] + 1;
                if (unusedCnt[0] <= 10) continue;
                iter.remove();
                Key removeKey = (Key)e.getKey();
                keyToImageMap.remove(removeKey);
            }
        }
        return ret;
    }

    public static ImageData[] createPointImages(PointSet ps, Font f) {
        DataList dl = ps.getVertexAttributes(Attribute.LABELS);
        if (dl == null) {
            return null;
        }
        StringArray sa = dl.toStringArray();
        DataList cols = ps.getVertexAttributes(Attribute.COLORS);
        if (cols == null) {
            return null;
        }
        DoubleArray colours = cols.toDoubleArray();
        Color[] colors = new Color[colours.getLength() / 3];
        for (int i = 0; i < colours.getLength() / 3; ++i) {
            colors[i] = new Color((float)colours.getValueAt(i * 3), (float)colours.getValueAt(i * 3 + 1), (float)colours.getValueAt(i * 3 + 2));
        }
        return LabelUtility.createImages((Geometry)ps, 0, sa, colors, f);
    }

    public static ImageData[] createPointImages(PointSet ps, Font f, Color c) {
        DataList dl = ps.getVertexAttributes(Attribute.LABELS);
        if (dl == null) {
            return null;
        }
        StringArray sa = dl.toStringArray();
        return LabelUtility.createImages((Geometry)ps, 0, sa, c, f);
    }

    public static ImageData[] createEdgeImages(IndexedLineSet ls, Font f, Color c) {
        DataList dl = ls.getEdgeAttributes(Attribute.LABELS);
        if (dl == null) {
            return null;
        }
        StringArray sa = dl.toStringArray();
        return LabelUtility.createImages((Geometry)ls, 2, sa, c, f);
    }

    public static ImageData[] createFaceImages(IndexedFaceSet fs, Font f, Color c) {
        DataList dl = fs.getFaceAttributes(Attribute.LABELS);
        if (dl == null) {
            return null;
        }
        StringArray sa = dl.toStringArray();
        return LabelUtility.createImages((Geometry)fs, 3, sa, c, f);
    }

    public static BufferedImage createImageFromString(String s, Font f, Color color) {
        return LabelUtility.createImageFromString(s, f, color, TRANSPARENT);
    }

    public static BufferedImage createImageFromString(String s, Font f, Color foreground, Color background) {
        String[] lines = s.split("\n");
        return LabelUtility.createImageFromStrings(lines, f, foreground, background);
    }

    public static BufferedImage createImageFromStrings(String[] ss, Font f, Color foreground, Color background) {
        int width = 0;
        int height = 0;
        int[] hh = new int[ss.length];
        float border = 0.0f;
        if (f == null) {
            f = new Font("Sans Serif", 0, 48);
        }
        for (int i = 0; i < ss.length; ++i) {
            float ftmp;
            String s = ss[i];
            if (s == null || s.length() == 0) {
                if (background.equals(TRANSPARENT)) {
                    return bi;
                }
                s = " ";
            }
            TextLayout tl = new TextLayout(s, f, frc);
            Rectangle r = tl.getBounds().getBounds();
            hh[i] = (int)f.getLineMetrics(s, frc).getHeight();
            height += hh[i];
            int tmp = r.width + 20;
            if (tmp > width) {
                width = tmp;
            }
            if (!((ftmp = (float)hh[i] - tl.getDescent()) > border)) continue;
            border = ftmp;
        }
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setBackground(background);
        g.clearRect(0, 0, width, height);
        g.setColor(foreground);
        g.setFont(f);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        height = 0;
        for (int i = 0; i < ss.length; ++i) {
            g.drawString(ss[i], 0.0f, (float)height + border);
            height += hh[i];
        }
        return img;
    }

    public static SceneGraphComponent sceneGraphForLabel(SceneGraphComponent sgc, double xscale, double yscale, double[] offset, int alignment, int textdirection, double[] camToObj, double[] position) {
        if (sgc == null) {
            sgc = new SceneGraphComponent();
        }
        if (sgc.getGeometry() == null) {
            sgc.setGeometry(bb);
        }
        if (sgc.getTransformation() == null) {
            sgc.setTransformation(new Transformation());
        }
        sgc.getTransformation().setMatrix(LabelUtility.calculateBillboardMatrix(null, xscale, yscale, offset, alignment, camToObj, position, 0, textdirection));
        return sgc;
    }

    public static double[] positionFor(int ind, DoubleArrayArray a, IntArrayArray indexed) {
        if (indexed == null) {
            return a.getValueAt(ind).toDoubleArray(null);
        }
        double[] ret = null;
        IntArray part = indexed.getValueAt(ind);
        double[] tmp = null;
        for (int i = 0; i < part.getLength(); ++i) {
            tmp = a.getValueAt(part.getValueAt(i)).toDoubleArray(tmp);
            if (ret == null) {
                ret = (double[])tmp.clone();
                continue;
            }
            for (int j = 0; j < tmp.length; ++j) {
                int n = j;
                ret[n] = ret[n] + tmp[j];
            }
        }
        int j = 0;
        while (j < tmp.length) {
            int n = j++;
            ret[n] = ret[n] / (double)part.getLength();
        }
        return ret;
    }

    public static double[] calculateBillboardMatrix(double[] result, double xscale, double yscale, double[] xyzOffset, int alignment, double[] cameraToObject, double[] point, int metric, int textorientation) {
        if (result == null) {
            result = new double[16];
        }
        double[] orientation = P3.extractOrientationMatrix(null, cameraToObject, P3.originP3, metric);
        double[] scale = P3.makeStretchMatrix(null, xscale, yscale, 1.0);
        double[] rotation = P3.makeRotationMatrixZ(null, textorientation == 1 ? 1.5707963267948966 : 0.0);
        double align = 0.0;
        double valign = 0.0;
        switch (alignment) {
            case 1: {
                align = -xscale / 2.0;
                break;
            }
            case 3: {
                valign = -yscale / 2.0;
                break;
            }
            case 5: {
                align = -xscale / 2.0;
                valign = -yscale;
                break;
            }
            case 7: {
                align = -xscale;
                valign = -yscale / 2.0;
                break;
            }
            case 0: {
                align = -xscale / 2.0;
                valign = -yscale / 2.0;
                break;
            }
            case 4: {
                valign = -yscale;
                break;
            }
            case 6: {
                align = -xscale;
                valign = -yscale;
                break;
            }
            case 8: {
                align = -xscale;
            }
        }
        metric = 0;
        double[] euclideanTranslation = P3.makeTranslationMatrix(null, Rn.add(null, xyzOffset, new double[]{align, valign, 0.0, 0.0}), metric);
        double[] pointTranslation = Double.isNaN(point[0]) ? Rn.identityMatrix(4) : P3.makeTranslationMatrix(null, point, metric);
        Rn.times(result, pointTranslation, Rn.times(null, orientation, Rn.times(null, euclideanTranslation, Rn.times(null, rotation, scale))));
        return result;
    }

    static {
        bi = new BufferedImage(1, 1, 2);
        frc = bi.createGraphics().getFontRenderContext();
        TRANSPARENT = new Color(0, 0, 0, 0);
        bb = Primitives.texturedQuadrilateral(new double[]{0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0});
    }

    private static class Key {
        static final int TYPE_POINTS = 0;
        static final int TYPE_EDGES = 2;
        static final int TYPE_FACES = 3;
        private int type;
        private Font font;
        private Color color;
        private final int hash;

        Key(int t, Font f, Color c) {
            if (t < 0 || t > 3) {
                throw new IllegalArgumentException("no such type");
            }
            this.type = t;
            this.font = f;
            this.color = c;
            this.hash = 1369 * c.hashCode() + 37 * f.hashCode() + t;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Key)) {
                return false;
            }
            Key k = (Key)obj;
            return k.hashCode() == this.hashCode() && k.type == this.type && k.font.equals(this.font) && k.color.equals(this.color);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "Key: font=" + this.font + " color=" + this.color;
        }
    }
}

