/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio.util;

public class Limiter {
    private static final double RELEASE_FACTOR = 0.99;
    private static final int HOLD_COUNT = 16;
    float maxSignal = 1.0f;
    int holdcnt;

    public void limit(float[] fbuffer, float[] fbuffer_lookAhead) {
        int framesize = fbuffer.length;
        float nextFrameMaxSignal = this.maxSignal;
        for (int i = 0; i < framesize; ++i) {
            float abs = Math.abs(fbuffer_lookAhead[i]);
            if (!(abs > nextFrameMaxSignal)) continue;
            nextFrameMaxSignal = abs;
            this.holdcnt = 16;
        }
        boolean rampUp = nextFrameMaxSignal > this.maxSignal;
        float delta = Math.abs(nextFrameMaxSignal - this.maxSignal);
        float dd = 0.0f;
        if (!rampUp) {
            if (this.holdcnt == 0 && this.maxSignal > 1.0f) {
                delta = -((float)((double)this.maxSignal * 0.010000000000000009));
                dd = delta / (float)framesize;
            } else {
                --this.holdcnt;
            }
        } else {
            dd = delta / (float)framesize;
        }
        int i = 0;
        while (i < framesize) {
            this.maxSignal = this.maxSignal >= 1.0f ? (this.maxSignal += dd) : 1.0f;
            int n = i++;
            fbuffer[n] = fbuffer[n] / this.maxSignal;
        }
    }
}

