/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio.javasound;

import de.jreality.audio.SoundEncoder;
import de.jreality.audio.VbapSoundEncoder;
import de.jreality.audio.javasound.AbstractJavaSoundRenderer;
import de.jreality.audio.javasound.JavaSoundUtility;
import de.jreality.audio.util.Limiter;
import javax.sound.sampled.LineUnavailableException;

public class VbapRenderer
extends AbstractJavaSoundRenderer {
    byte[] buffer;
    float[] fbuffer;
    float[] fbuffer_lookAhead;
    double[][] speakers = new double[][]{{0.5, 0.0}, {0.5, 0.5}, {-1.5, 1.0}, {-1.5, -1.0}, {0.5, -0.5}};
    int[] channelIDs = new int[]{4, 0, 2, 3, 1};
    Limiter limiter = new Limiter();

    protected SoundEncoder createSoundEncoder() {
        return new VbapSoundEncoder(this.speakers.length, this.speakers, this.channelIDs){

            public void finishFrame() {
                VbapRenderer.this.render(this.buf);
            }
        };
    }

    public void launch() throws LineUnavailableException {
        this.channels = this.speakers.length;
        this.openSourceDataLine();
        this.buffer = new byte[this.bufferLength];
        this.fbuffer = new float[this.channels * this.frameSize];
        this.fbuffer_lookAhead = new float[this.channels * this.frameSize];
        super.launch();
    }

    public void render(float[] surroundSamples) {
        System.arraycopy(surroundSamples, 0, this.fbuffer_lookAhead, 0, surroundSamples.length);
        this.limiter.limit(this.fbuffer, this.fbuffer_lookAhead);
        JavaSoundUtility.floatToByte(this.buffer, this.fbuffer);
        this.writePCM(this.buffer, 0, this.bufferLength);
        float[] tmpF = this.fbuffer;
        this.fbuffer = this.fbuffer_lookAhead;
        this.fbuffer_lookAhead = tmpF;
    }
}

