/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.RingBuffer;
import de.jreality.audio.RingBufferSource;
import de.jreality.scene.AudioSource;

public class SampleBufferAudioSource
extends RingBufferSource {
    protected float[] samples;
    protected int index;
    protected boolean loop;
    protected int nSamples;

    public SampleBufferAudioSource(String name, float[] sampleBuffer, int sampleRate, boolean loop) {
        super(name);
        this.loop = loop;
        this.sampleRate = sampleRate;
        this.samples = sampleBuffer;
        this.nSamples = this.samples.length;
        this.ringBuffer = new RingBuffer(sampleRate);
        this.reset();
    }

    protected void reset() {
        this.index = 0;
    }

    protected void writeSamples(int nRequested) {
        while (nRequested > 0) {
            int n = this.nSamples - this.index;
            if (nRequested < n) {
                n = nRequested;
            }
            this.ringBuffer.write(this.samples, this.index, n);
            this.index += n;
            nRequested -= n;
            if (this.index < this.nSamples) continue;
            if (this.loop) {
                this.index -= this.nSamples;
                continue;
            }
            this.state = AudioSource.State.STOPPED;
            this.hasChanged = true;
            this.reset();
            break;
        }
    }
}

