/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.scene.data.SampleReader;
import java.nio.FloatBuffer;

public class RingBuffer {
    private final float[] buffer;
    private final int size;
    private int writePointer;

    public RingBuffer(int size) {
        this.size = size;
        this.buffer = new float[size];
        this.writePointer = 0;
    }

    public int getSize() {
        return this.size;
    }

    public Reader createReader() {
        return new Reader();
    }

    public SampleReader createSampleReader(final int sampleRate) {
        return new SampleReader(){
            private final Reader reader;
            {
                this.reader = RingBuffer.this.createReader();
            }

            public void clear() {
                this.reader.clear();
            }

            public int getSampleRate() {
                return sampleRate;
            }

            public int read(float[] buffer, int initialIndex, int samples) {
                return this.reader.read(buffer, initialIndex, samples);
            }
        };
    }

    public void write(float[] source, int initialIndex, int nSamples) {
        if (this.writePointer + nSamples < this.size) {
            System.arraycopy(source, initialIndex, this.buffer, this.writePointer, nSamples);
            this.writePointer += nSamples;
        } else {
            int n1 = this.size - this.writePointer;
            System.arraycopy(source, initialIndex, this.buffer, this.writePointer, n1);
            this.writePointer = nSamples - n1;
            System.arraycopy(source, initialIndex + n1, this.buffer, 0, this.writePointer);
        }
    }

    public void write(FloatBuffer source) {
        int nSamples = source.remaining();
        if (this.writePointer + nSamples < this.size) {
            source.get(this.buffer, this.writePointer, nSamples);
            this.writePointer += nSamples;
        } else {
            int n1 = this.size - this.writePointer;
            source.get(this.buffer, this.writePointer, n1);
            this.writePointer = nSamples - n1;
            source.get(this.buffer, 0, this.writePointer);
        }
    }

    public class Reader {
        private int readPointer;

        private Reader() {
            this.clear();
        }

        public int getSize() {
            return RingBuffer.this.size;
        }

        public void clear() {
            this.readPointer = RingBuffer.this.writePointer;
        }

        public int valuesLeft() {
            return this.readPointer <= RingBuffer.this.writePointer ? RingBuffer.this.writePointer - this.readPointer : RingBuffer.this.size - this.readPointer + RingBuffer.this.writePointer;
        }

        public int read(float[] target, int initialIndex, int nValues) {
            int n;
            int nLeft = this.valuesLeft();
            int n2 = n = nLeft < nValues ? nLeft : nValues;
            if (this.readPointer + n < RingBuffer.this.size) {
                System.arraycopy(RingBuffer.this.buffer, this.readPointer, target, initialIndex, n);
                this.readPointer += n;
            } else {
                int n1 = RingBuffer.this.size - this.readPointer;
                System.arraycopy(RingBuffer.this.buffer, this.readPointer, target, initialIndex, n1);
                this.readPointer = n - n1;
                System.arraycopy(RingBuffer.this.buffer, 0, target, initialIndex + n1, this.readPointer);
            }
            return n;
        }
    }
}

