/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.DistanceCue;
import de.jreality.shader.EffectiveAppearance;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DistanceCueChain
implements DistanceCue {
    private final List<DistanceCue> cues;

    private DistanceCueChain(List<DistanceCue> cues) {
        this.cues = cues;
    }

    public static DistanceCue create(List<DistanceCue> list) {
        if (list == null || list.isEmpty()) {
            return new DistanceCue.CONSTANT();
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        DistanceCueChain chain = new DistanceCueChain(list);
        return chain;
    }

    @Override
    public void setSampleRate(float sr) {
        for (DistanceCue cue : this.cues) {
            cue.setSampleRate(sr);
        }
    }

    @Override
    public float nextValue(float v, float r, float xMic, float yMic, float zMic) {
        for (DistanceCue cue : this.cues) {
            v = cue.nextValue(v, r, xMic, yMic, zMic);
        }
        return v;
    }

    @Override
    public void reset() {
        for (DistanceCue cue : this.cues) {
            cue.reset();
        }
    }

    @Override
    public boolean hasMore() {
        for (DistanceCue cue : this.cues) {
            if (!cue.hasMore()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setProperties(EffectiveAppearance app) {
        for (DistanceCue cue : this.cues) {
            cue.setProperties(app);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DistanceCueChain:\n");
        for (DistanceCue cue : this.cues) {
            sb.append("   " + cue + "\n");
        }
        return sb.toString();
    }
}

