/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.LowPassFilter;
import de.jreality.shader.EffectiveAppearance;

public interface DistanceCue {
    public void setSampleRate(float var1);

    public boolean hasMore();

    public float nextValue(float var1, float var2, float var3, float var4, float var5);

    public void setProperties(EffectiveAppearance var1);

    public void reset();

    public static final class LOWPASS
    extends LowPassFilter
    implements DistanceCue {
        private float freq = 44000.0f;

        public float nextValue(float v, float r, float x, float y, float z) {
            this.setCutOff(this.freq / (1.0f + r));
            return this.nextValue(v);
        }

        public void reset() {
            this.initialize(0.0f);
        }

        public void setProperties(EffectiveAppearance app) {
            this.freq = app.getAttribute("distanceLowPassKey", 44000.0f);
        }
    }

    public static final class CARDIOID
    extends Attenuation {
        public float nextValue(float v, float r, float xMic, float yMic, float zMic) {
            return 0.5f * v * (1.0f + zMic);
        }
    }

    public static final class CONICAL
    extends Attenuation {
        public float nextValue(float v, float r, float xMic, float yMic, float zMic) {
            return v * zMic * zMic;
        }
    }

    public static final class EXPONENTIAL
    extends Attenuation {
        public float nextValue(float v, float r, float x, float y, float z) {
            return v / (float)Math.exp(r);
        }
    }

    public static final class LINEAR
    extends Attenuation {
        public float nextValue(float v, float r, float x, float y, float z) {
            return v / Math.max(r, 1.0f);
        }
    }

    public static final class CONSTANT
    extends Attenuation {
        public float nextValue(float v, float r, float x, float y, float z) {
            return v;
        }
    }

    public static abstract class Attenuation
    implements DistanceCue {
        public void setSampleRate(float sr) {
        }

        public boolean hasMore() {
            return false;
        }

        public void setProperties(EffectiveAppearance app) {
        }

        public void reset() {
        }
    }
}

