/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.AudioAttributes;
import de.jreality.audio.DistanceCue;
import de.jreality.audio.DistanceCueFactory;
import de.jreality.audio.Interpolation;
import de.jreality.audio.LowPassFilter;
import de.jreality.audio.SampleProcessor;
import de.jreality.audio.SampleProcessorFactory;
import de.jreality.audio.SoundEncoder;
import de.jreality.audio.SoundPath;
import de.jreality.math.Matrix;
import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.scene.data.SampleReader;
import de.jreality.shader.EffectiveAppearance;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class DelayPath
implements SoundPath {
    public static final SoundPath.Factory FACTORY = new SoundPath.Factory(){

        public SoundPath newSoundPath() {
            return new DelayPath();
        }
    };
    private DistanceCueFactory directedFactory = AudioAttributes.DEFAULT_DISTANCE_CUE_FACTORY;
    private DistanceCueFactory directionlessFactory = AudioAttributes.DEFAULT_DISTANCE_CUE_FACTORY;
    private SampleProcessorFactory preProcFactory = AudioAttributes.DEFAULT_PROCESSOR_FACTORY;
    private DistanceCue distanceCue;
    private DistanceCue directionlessCue;
    private SampleProcessor preProcessor;
    private int metric = 0;
    private float gain = 1.0f;
    private float directionlessGain = 0.1f;
    private float speedOfSound = 332.0f;
    private float updateCutoff = 6.0f;
    private int earshot = 96000;
    private boolean withinEarshot = true;
    private int samplesOutOfEarshot = 0;
    private SampleReader reader;
    private int sampleRate;
    private float gamma;
    private Queue<float[]> sourceFrames = new LinkedList<float[]>();
    private Queue<Integer> frameLengths = new LinkedList<Integer>();
    private Queue<Matrix> sourcePositions = new LinkedList<Matrix>();
    private Matrix currentMicPosition;
    private Matrix currentSourcePosition;
    private LowPassFilter rFilter;
    private LowPassFilter thetaFilter;
    private LowPassFilter phiFilter;
    private float rTarget;
    private float thetaTarget;
    private float phiTarget;
    private float rCurrent;
    private float thetaCurrent;
    private float phiCurrent;
    private float xMic;
    private float yMic;
    private float zMic;
    private Matrix auxiliaryMatrix = new Matrix();
    private double[] auxiliaryArray = new double[3];
    private float[] currentFrame = null;
    private int currentLength = 0;
    private int currentIndex = 0;
    private int relativeTime = 0;
    private int frameCount = 0;
    private Interpolation interpolation;
    private static final Map<Integer, Queue<WeakReference<float[]>>> framePool = new HashMap<Integer, Queue<WeakReference<float[]>>>();

    public void initialize(SampleReader reader, Interpolation.Factory factory) {
        this.reader = reader;
        this.sampleRate = reader.getSampleRate();
        this.preProcessor = this.preProcFactory.getInstance(reader);
        this.distanceCue = this.directedFactory.getInstance(this.sampleRate);
        this.directionlessCue = this.directionlessFactory.getInstance(this.sampleRate);
        this.interpolation = factory.newInterpolation();
        this.rFilter = new LowPassFilter(this.sampleRate);
        this.thetaFilter = new LowPassFilter(this.sampleRate);
        this.phiFilter = new LowPassFilter(this.sampleRate);
        this.updateParameters();
    }

    public void setProperties(EffectiveAppearance app) {
        DistanceCueFactory dcf;
        this.metric = app.getAttribute("metric", 0);
        this.gain = app.getAttribute("volumeGain", 1.0f);
        this.directionlessGain = app.getAttribute("directionlessVolumeGain", 0.1f);
        this.speedOfSound = app.getAttribute("speedOfSound", 332.0f);
        this.updateCutoff = app.getAttribute("updateCutoff", 6.0f);
        this.earshot = app.getAttribute("earshotKey", 96000);
        this.updateParameters();
        SampleProcessorFactory spf = (SampleProcessorFactory)app.getAttribute("preprocessorKey", AudioAttributes.DEFAULT_PROCESSOR_FACTORY, SampleProcessorFactory.class);
        if (spf != this.preProcFactory) {
            SampleProcessor proc;
            this.preProcFactory = spf;
            this.preProcessor = proc = spf.getInstance(this.reader);
        }
        if ((dcf = (DistanceCueFactory)app.getAttribute("distanceCue", AudioAttributes.DEFAULT_DISTANCE_CUE_FACTORY, DistanceCueFactory.class)) != this.directedFactory) {
            this.directedFactory = dcf;
            this.distanceCue = dcf.getInstance(this.sampleRate);
        }
        if ((dcf = (DistanceCueFactory)app.getAttribute("directionlessCueKey", AudioAttributes.DEFAULT_DISTANCE_CUE_FACTORY, DistanceCueFactory.class)) != this.directionlessFactory) {
            this.directionlessFactory = dcf;
            this.directionlessCue = dcf.getInstance(this.sampleRate);
        }
        this.preProcessor.setProperties(app);
        this.distanceCue.setProperties(app);
        this.directionlessCue.setProperties(app);
    }

    private void updateParameters() {
        float f = this.gamma = this.speedOfSound > 0.0f ? (float)this.sampleRate / this.speedOfSound : 0.0f;
        if (this.updateCutoff != this.rFilter.getCutOff()) {
            this.rFilter.setCutOff(this.updateCutoff);
            this.thetaFilter.setCutOff(this.updateCutoff);
            this.phiFilter.setCutOff(this.updateCutoff);
        }
    }

    public boolean processFrame(SoundEncoder enc, int frameSize, Matrix sourcePosition, Matrix inverseMicMatrix, float[] directionlessBuffer) {
        this.currentMicPosition = inverseMicMatrix;
        this.currentSourcePosition = sourcePosition;
        this.updateTarget();
        boolean sourceActive = this.evaluateSourceFrame(frameSize);
        this.encodeFrame(enc, frameSize, directionlessBuffer);
        if (sourceActive || this.frameCount > 0 || this.currentFrame != null || this.preProcessor.hasMore() || this.distanceCue.hasMore() || this.directionlessCue.hasMore()) {
            return true;
        }
        this.reset();
        return false;
    }

    private boolean evaluateSourceFrame(int frameSize) {
        float[] newFrame = DelayPath.getBuffer(frameSize);
        int nRead = this.preProcessor.read(newFrame, 0, frameSize);
        if (this.withinEarshot) {
            if (nRead > 0) {
                ++this.frameCount;
                if (nRead < frameSize) {
                    Arrays.fill(newFrame, nRead, frameSize, 0.0f);
                }
                this.queueFrame(frameSize, newFrame);
            } else {
                DelayPath.reuseBuffer(newFrame);
                this.queueFrame(frameSize, null);
            }
            this.withinEarshot = this.earshot <= 0 || this.relativeTime < this.earshot + 4 * frameSize;
        } else {
            DelayPath.reuseBuffer(newFrame);
            this.samplesOutOfEarshot += frameSize;
            boolean bl = this.withinEarshot = this.relativeTime < this.earshot;
            if (this.withinEarshot || 2 * this.samplesOutOfEarshot / frameSize > this.relativeTime / this.earshot) {
                this.queueNullFrame();
            }
        }
        return nRead > 0;
    }

    private void queueNullFrame() {
        this.queueFrame(this.samplesOutOfEarshot, null);
        this.samplesOutOfEarshot = 0;
    }

    private void queueFrame(int size, float[] frame) {
        this.sourcePositions.add(new Matrix(this.currentSourcePosition));
        if (this.currentLength > 0) {
            this.frameLengths.add(size);
            this.sourceFrames.add(frame);
        } else {
            this.currentLength = size;
            this.currentFrame = frame;
            this.rCurrent = this.rFilter.initialize(this.rTarget);
            this.thetaCurrent = this.thetaFilter.initialize(this.thetaTarget);
            this.phiCurrent = this.phiFilter.initialize(this.phiTarget);
        }
    }

    private void updateTarget() {
        this.auxiliaryMatrix.assignFrom(this.sourcePositions.isEmpty() ? this.currentSourcePosition : this.sourcePositions.element());
        this.auxiliaryMatrix.multiplyOnLeft(this.currentMicPosition);
        DelayPath.homogeneousToSpherical(this.auxiliaryArray, this.auxiliaryMatrix.getColumn(3), this.metric);
        this.rTarget = (float)this.auxiliaryArray[0];
        this.thetaTarget = (float)this.auxiliaryArray[1];
        this.phiTarget = (float)this.auxiliaryArray[2];
        while ((double)(this.thetaTarget - this.thetaCurrent) > Math.PI) {
            this.thetaCurrent = (float)((double)this.thetaCurrent + Math.PI * 2);
        }
        while ((double)(this.thetaCurrent - this.thetaTarget) > Math.PI) {
            this.thetaCurrent = (float)((double)this.thetaCurrent - Math.PI * 2);
        }
        this.thetaFilter.initialize(this.thetaCurrent);
        this.auxiliaryMatrix.invert();
        DelayPath.homogeneousToSpherical(this.auxiliaryArray, this.auxiliaryMatrix.getColumn(3), this.metric);
        this.auxiliaryArray[0] = 1.0;
        DelayPath.sphericalToRectangular(this.auxiliaryArray);
        this.xMic = (float)this.auxiliaryArray[0];
        this.yMic = (float)this.auxiliaryArray[1];
        this.zMic = (float)this.auxiliaryArray[2];
    }

    private static void homogeneousToSpherical(double[] dst, double[] src, int metric) {
        double x = src[0];
        double y = src[1];
        double z = src[2];
        dst[0] = Pn.distanceBetween(P3.originP3, src, metric);
        dst[1] = Math.atan2(x, z);
        dst[2] = Math.atan2(y, Math.sqrt(x * x + z * z));
    }

    private static void sphericalToRectangular(double[] p) {
        double r = p[0];
        double theta = p[1];
        double phi = p[2];
        double cp = r * Math.cos(phi);
        double sp = r * Math.sin(phi);
        p[2] = cp * Math.cos(theta);
        p[0] = cp * Math.sin(theta);
        p[1] = sp;
    }

    private void advanceFrame() {
        if (this.currentFrame != null) {
            DelayPath.reuseBuffer(this.currentFrame);
        }
        this.currentFrame = this.sourceFrames.remove();
        this.currentLength = this.frameLengths.remove();
        this.sourcePositions.remove();
        this.updateTarget();
        if (this.currentFrame != null) {
            --this.frameCount;
        }
    }

    private void encodeFrame(SoundEncoder enc, int frameSize, float[] directionlessBuffer) {
        for (int j = 0; j < frameSize; ++j) {
            float time = (float)this.relativeTime++ - this.gamma * this.rCurrent;
            int targetIndex = (int)time;
            float fractionalTime = time - (float)targetIndex;
            while (targetIndex >= this.currentIndex) {
                if (this.currentIndex >= this.currentLength) {
                    this.relativeTime -= this.currentLength;
                    this.currentIndex -= this.currentLength;
                    targetIndex -= this.currentLength;
                    this.advanceFrame();
                }
                float newSample = this.currentFrame != null ? this.currentFrame[this.currentIndex] * this.gain : 0.0f;
                newSample = this.directionlessCue.nextValue(newSample, this.rCurrent, this.xMic, this.yMic, this.zMic);
                this.interpolation.put(newSample);
                ++this.currentIndex;
            }
            float v = this.interpolation.get(fractionalTime);
            v = this.distanceCue.nextValue(v, this.rCurrent, this.xMic, this.yMic, this.zMic);
            this.auxiliaryArray[0] = 1.0;
            this.auxiliaryArray[1] = this.thetaCurrent;
            this.auxiliaryArray[2] = this.phiCurrent;
            DelayPath.sphericalToRectangular(this.auxiliaryArray);
            enc.encodeSample(v, j, this.rCurrent, (float)this.auxiliaryArray[0], (float)this.auxiliaryArray[1], (float)this.auxiliaryArray[2]);
            if (directionlessBuffer != null) {
                int n = j;
                directionlessBuffer[n] = directionlessBuffer[n] + v * this.directionlessGain;
            }
            this.rCurrent = this.rFilter.nextValue(this.rTarget);
            this.thetaCurrent = this.thetaFilter.nextValue(this.thetaTarget);
            this.phiCurrent = this.phiFilter.nextValue(this.phiTarget);
        }
    }

    private void reset() {
        this.sourceFrames.clear();
        this.frameLengths.clear();
        this.sourcePositions.clear();
        this.currentFrame = null;
        this.currentLength = 0;
        this.currentIndex = 0;
        this.relativeTime = 0;
        this.frameCount = 0;
        this.withinEarshot = true;
        this.samplesOutOfEarshot = 0;
        this.interpolation.reset();
        this.preProcessor.clear();
        this.distanceCue.reset();
        this.directionlessCue.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reuseBuffer(float[] frame) {
        int size = frame.length;
        Map<Integer, Queue<WeakReference<float[]>>> map = framePool;
        synchronized (map) {
            Queue<WeakReference<float[]>> queue = framePool.get(size);
            if (queue == null) {
                queue = new LinkedList<WeakReference<float[]>>();
                framePool.put(size, queue);
            }
            queue.add(new WeakReference<float[]>(frame));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float[] getBuffer(int size) {
        Map<Integer, Queue<WeakReference<float[]>>> map = framePool;
        synchronized (map) {
            Queue<WeakReference<float[]>> queue = framePool.get(size);
            if (queue != null) {
                while (!queue.isEmpty()) {
                    float[] frame = (float[])queue.remove().get();
                    if (frame == null) continue;
                    return frame;
                }
            }
        }
        return new float[size];
    }
}

