/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.ConvertingReader;
import de.jreality.audio.Interpolation;
import de.jreality.audio.RingBuffer;
import de.jreality.audio.SampleProcessor;
import de.jreality.audio.SampleProcessorFactory;
import de.jreality.audio.SoundEncoder;
import de.jreality.audio.SoundPath;
import de.jreality.math.Matrix;
import de.jreality.scene.Appearance;
import de.jreality.scene.AudioSource;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphPathObserver;
import de.jreality.scene.data.SampleReader;
import de.jreality.scene.event.AppearanceEvent;
import de.jreality.scene.event.AppearanceListener;
import de.jreality.scene.event.AudioEvent;
import de.jreality.scene.event.AudioListener;
import de.jreality.scene.proxy.tree.EntityFactory;
import de.jreality.scene.proxy.tree.ProxyTreeFactory;
import de.jreality.scene.proxy.tree.SceneGraphNodeEntity;
import de.jreality.scene.proxy.tree.SceneTreeNode;
import de.jreality.scene.proxy.tree.UpToDateSceneProxyBuilder;
import de.jreality.shader.EffectiveAppearance;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AudioBackend
extends UpToDateSceneProxyBuilder
implements AppearanceListener {
    private int sampleRate;
    private SceneGraphPath microphonePath;
    private Matrix inverseMicrophoneMatrix = new Matrix();
    private float[] directionlessBuffer = null;
    private SampleReader directionlessReader;
    private RingBuffer ringBuffer;
    private List<AudioTreeNode> audioSources = new CopyOnWriteArrayList<AudioTreeNode>();
    private SceneGraphPathObserver rootAppearanceObserver = new SceneGraphPathObserver();
    private SceneGraphPath rootAppearancePath = new SceneGraphPath();
    private Interpolation.Factory interpolationFactory;
    private SoundPath.Factory soundPathFactory;
    private SampleProcessorFactory directionlessFactory = null;
    private SampleProcessor directionlessProcessor = null;

    public AudioBackend(SceneGraphComponent root, SceneGraphPath microphonePath, int sampleRate, Interpolation.Factory interpolationFactory, SoundPath.Factory soundPathFactory) {
        super(root);
        this.microphonePath = microphonePath;
        this.sampleRate = sampleRate;
        this.interpolationFactory = interpolationFactory;
        this.soundPathFactory = soundPathFactory;
        this.ringBuffer = new RingBuffer(sampleRate);
        this.directionlessReader = this.ringBuffer.createSampleReader(sampleRate);
        Appearance rootApp = root.getAppearance();
        if (rootApp == null) {
            rootApp = new Appearance();
            root.setAppearance(rootApp);
        }
        this.rootAppearancePath.push(root);
        this.rootAppearancePath.push(rootApp);
        this.rootAppearanceObserver.setPath(this.rootAppearancePath);
        this.appearanceChanged(null);
        this.rootAppearanceObserver.addAppearanceListener(this);
        this.setEntityFactory(new EntityFactory(){
            {
                this.setUpdateAudioSource(true);
            }

            protected SceneGraphNodeEntity produceAudioSourceEntity(AudioSource g) {
                return new AudioSourceEntity(g);
            }
        });
        this.setProxyTreeFactory(new ProxyTreeFactory(){

            public void visit(AudioSource a) {
                this.proxyNode = new AudioTreeNode(a);
            }
        });
        super.createProxyTree();
    }

    public void appearanceChanged(AppearanceEvent ev) {
        SampleProcessor proc;
        EffectiveAppearance app = EffectiveAppearance.create(this.rootAppearancePath);
        SampleProcessorFactory newDirectionlessFactory = (SampleProcessorFactory)app.getAttribute("directionlessProcessor", null, SampleProcessorFactory.class);
        if (this.directionlessFactory != newDirectionlessFactory) {
            this.directionlessFactory = newDirectionlessFactory;
            SampleProcessor sampleProcessor = this.directionlessProcessor = this.directionlessFactory != null ? this.directionlessFactory.getInstance(this.directionlessReader) : null;
        }
        if ((proc = this.directionlessProcessor) != null) {
            proc.setProperties(app);
        }
    }

    public void processFrame(SoundEncoder enc, int frameSize) {
        SampleProcessor directionlessProcessor = this.directionlessProcessor;
        if (directionlessProcessor != null) {
            if (this.directionlessBuffer == null || this.directionlessBuffer.length < frameSize) {
                this.directionlessBuffer = new float[frameSize];
            } else {
                Arrays.fill(this.directionlessBuffer, 0, frameSize, 0.0f);
            }
        } else {
            this.directionlessBuffer = null;
        }
        this.microphonePath.getInverseMatrix(this.inverseMicrophoneMatrix.getArray());
        enc.startFrame(frameSize);
        for (AudioTreeNode node : this.audioSources) {
            try {
                node.processFrame(enc, frameSize, this.directionlessBuffer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (directionlessProcessor != null) {
            try {
                this.ringBuffer.write(this.directionlessBuffer, 0, frameSize);
                int nRead = directionlessProcessor.read(this.directionlessBuffer, 0, frameSize);
                for (int i = 0; i < nRead; ++i) {
                    enc.encodeSample(this.directionlessBuffer[i], i);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        enc.finishFrame();
    }

    private class AudioSourceEntity
    extends SceneGraphNodeEntity
    implements AudioListener {
        protected AudioSourceEntity(SceneGraphNode node) {
            super(node);
        }

        public void audioChanged(AudioEvent ev) {
        }

        protected void addTreeNode(SceneTreeNode tn) {
            super.addTreeNode(tn);
            AudioBackend.this.audioSources.add((AudioTreeNode)tn);
        }

        protected void removeTreeNode(SceneTreeNode tn) {
            super.removeTreeNode(tn);
            AudioBackend.this.audioSources.remove((AudioTreeNode)tn);
        }

        protected void dispose() {
            for (SceneTreeNode tn : this.getTreeNodes()) {
                if (!(tn instanceof AudioTreeNode)) continue;
                AudioTreeNode atn = (AudioTreeNode)tn;
                atn.dispose();
            }
            super.dispose();
        }
    }

    private class AudioTreeNode
    extends SceneTreeNode
    implements AudioListener,
    AppearanceListener {
        private SoundPath soundPath;
        private Matrix currentPosition;
        private SceneGraphPath path;
        private SceneGraphPathObserver observer;
        private boolean nodeActive;
        private boolean pathActive;

        protected AudioTreeNode(AudioSource audio) {
            super(audio);
            this.soundPath = AudioBackend.this.soundPathFactory.newSoundPath();
            this.currentPosition = new Matrix();
            this.observer = new SceneGraphPathObserver();
            this.nodeActive = false;
            this.pathActive = false;
            this.soundPath.initialize(ConvertingReader.createReader(audio.createReader(), AudioBackend.this.sampleRate, AudioBackend.this.interpolationFactory), AudioBackend.this.interpolationFactory);
            audio.addAudioListener(this);
            this.observer.addAppearanceListener(this);
            this.audioChanged(null);
        }

        void processFrame(SoundEncoder encoder, int frameSize, float[] directionlessBuffer) {
            if (this.nodeActive || this.pathActive) {
                if (this.path == null) {
                    this.path = this.toPath();
                    this.appearanceChanged(null);
                    this.observer.setPath(this.path);
                }
                this.path.getMatrix(this.currentPosition.getArray());
                this.pathActive = this.soundPath.processFrame(encoder, frameSize, this.currentPosition, AudioBackend.this.inverseMicrophoneMatrix, directionlessBuffer);
            }
        }

        public void audioChanged(AudioEvent ev) {
            this.nodeActive = ((AudioSource)this.getNode()).getState() == AudioSource.State.RUNNING;
        }

        public void appearanceChanged(AppearanceEvent ev) {
            if (this.path != null) {
                this.soundPath.setProperties(EffectiveAppearance.create(this.path));
            }
        }

        public void dispose() {
            this.observer.removeAppearanceListener(this);
            this.observer.setPath(null);
        }
    }
}

