/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.cache;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.python.pydev.core.REF;
import org.python.pydev.core.cache.LRUCache;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskCache
extends LRUCache<String, Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private transient Object lock = new Object();
    private String folderToPersist;
    private Set<String> keys = new HashSet<String>();
    private String suffix;

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        this.lock = new Object();
        aStream.defaultReadObject();
        this.keys = (Set)aStream.readObject();
        this.folderToPersist = (String)aStream.readObject();
        this.suffix = (String)aStream.readObject();
        this.maxSize = aStream.readInt();
        this.cache = this.createMap(this.maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream aStream) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            aStream.defaultWriteObject();
            aStream.writeObject(this.keys());
            aStream.writeObject(this.folderToPersist);
            aStream.writeObject(this.suffix);
            aStream.writeInt(this.maxSize);
        }
    }

    public DiskCache(int maxSize, File folderToPersist, String suffix) {
        super(maxSize);
        this.folderToPersist = REF.getFileAbsolutePath(folderToPersist);
        this.suffix = suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Serializable getObj(String key) {
        Object object = this.lock;
        synchronized (object) {
            Serializable v = (Serializable)super.getObj(key);
            if (v == null && this.keys.contains(key)) {
                File file = this.getFileForKey(key);
                if (file.exists()) {
                    v = (Serializable)REF.readFromFile(file);
                }
                if (v == null) {
                    this.remove(key);
                    return null;
                }
                super.add(key, v);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileForKey(String o) {
        Object object = this.lock;
        synchronized (object) {
            return new File(this.folderToPersist, new StringBuffer(String.valueOf(o)).append(this.suffix).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        Object object = this.lock;
        synchronized (object) {
            super.remove(key);
            File fileForKey = this.getFileForKey(key);
            fileForKey.delete();
            this.keys.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String key, Serializable n) {
        Object object = this.lock;
        synchronized (object) {
            super.add(key, n);
            File fileForKey = this.getFileForKey(key);
            REF.writeToFile(n, fileForKey);
            this.keys.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            for (String key : this.keys) {
                super.remove(key);
                File fileForKey = this.getFileForKey(key);
                fileForKey.delete();
            }
            this.keys.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keys() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<String>(this.keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFolderToPersist(String folderToPersist) {
        Object object = this.lock;
        synchronized (object) {
            this.folderToPersist = folderToPersist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFolderToPersist() {
        Object object = this.lock;
        synchronized (object) {
            return this.folderToPersist;
        }
    }

    @Override
    public /* synthetic */ void add(Object object, Object object2) {
        this.add((String)object, (Serializable)object2);
    }

    @Override
    public /* synthetic */ Object getObj(Object object) {
        return this.getObj((String)object);
    }

    @Override
    public /* synthetic */ void remove(Object object) {
        this.remove((String)object);
    }
}

