/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.prettyprinterv2;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.parser.jython.ISpecialStr;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.prettyprinterv2.ILinePart;
import org.python.pydev.parser.prettyprinterv2.ILinePart2;
import org.python.pydev.parser.prettyprinterv2.LinePartIndentMark;
import org.python.pydev.parser.prettyprinterv2.LinePartRequireAdded;
import org.python.pydev.parser.prettyprinterv2.LinePartRequireIndentMark;
import org.python.pydev.parser.prettyprinterv2.LinePartRequireMark;
import org.python.pydev.parser.prettyprinterv2.LinePartsIterator;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterDocLineEntry;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyPrinterDocV2 {
    public final SortedMap<Integer, PrettyPrinterDocLineEntry> linesToColAndContents = new TreeMap<Integer, PrettyPrinterDocLineEntry>();
    private Map<Integer, List<ILinePart>> recordedChanges = new HashMap<Integer, List<ILinePart>>();
    private int lastRecordedChangesId = 0;

    public void addBefore(int beginLine, int beginCol, String string, Object token) {
        PrettyPrinterDocLineEntry lineContents = this.getLine(beginLine);
        ILinePart linePart = lineContents.addBefore(beginCol, string, token);
        this.addToCurrentRecordedChanges(linePart);
    }

    private void addToCurrentRecordedChanges(ILinePart linePart) {
        for (List<ILinePart> lst : this.recordedChanges.values()) {
            lst.add(linePart);
        }
    }

    public void add(int beginLine, int beginCol, String string, Object token) {
        PrettyPrinterDocLineEntry lineContents = this.getLine(beginLine);
        ILinePart linePart = lineContents.add(beginCol, string, token);
        this.addToCurrentRecordedChanges(linePart);
    }

    public LinePartRequireMark addRequireOneOf(SimpleNode node, String ... requireOneOf) {
        PrettyPrinterDocLineEntry line = this.getLine(node.beginLine);
        LinePartRequireMark linePart = line.addRequireMark(node.beginColumn, requireOneOf);
        this.addToCurrentRecordedChanges(linePart);
        return linePart;
    }

    public LinePartRequireMark addRequire(String string, SimpleNode node) {
        this.checkLine(node);
        PrettyPrinterDocLineEntry line = this.getLine(node.beginLine);
        LinePartRequireMark linePart = line.addRequireMark(node.beginColumn, string);
        this.addToCurrentRecordedChanges(linePart);
        return linePart;
    }

    private void checkLine(SimpleNode node) {
        if (node.beginLine < 0 || node.beginColumn < 0) {
            throw new RuntimeException(new StringBuffer("Node: ").append(node).append(" has invalid line ").append(node.beginLine).append(" or col ").append(node.beginColumn).toString());
        }
    }

    public LinePartRequireMark addRequireBefore(String string, ILinePart o1) {
        PrettyPrinterDocLineEntry line = this.getLine(o1.getLine());
        LinePartRequireMark linePart = line.addRequireMarkBefore(o1, string);
        this.addToCurrentRecordedChanges(linePart);
        return linePart;
    }

    public LinePartRequireMark addRequireAfter(String string, ILinePart o1) {
        PrettyPrinterDocLineEntry line = this.getLine(o1.getLine());
        LinePartRequireMark linePart = line.addRequireMarkAfterBefore(o1, string);
        this.addToCurrentRecordedChanges(linePart);
        return linePart;
    }

    public LinePartRequireIndentMark addRequireIndent(String string, SimpleNode node) {
        PrettyPrinterDocLineEntry line = this.getLine(node.beginLine);
        LinePartRequireIndentMark linePart = line.addRequireIndentMark(node.beginColumn, string);
        this.addToCurrentRecordedChanges(linePart);
        return linePart;
    }

    public void addStartStatementMark(ILinePart foundWithLowerLocation, SimpleNode node) {
        this.getLine(foundWithLowerLocation.getLine()).addStartStatementMark(foundWithLowerLocation, node);
    }

    public void addEndStatementMark(ILinePart foundWithHigherLocation, SimpleNode node) {
        this.getLine(foundWithHigherLocation.getLine()).addEndStatementMark(foundWithHigherLocation, node);
    }

    PrettyPrinterDocLineEntry getLine(int beginLine) {
        if (beginLine < 0) {
            throw new RuntimeException("Cannot get negative line.");
        }
        PrettyPrinterDocLineEntry lineContents = (PrettyPrinterDocLineEntry)this.linesToColAndContents.get(Autobox.valueOf((int)beginLine));
        if (lineContents == null) {
            lineContents = new PrettyPrinterDocLineEntry(beginLine);
            this.linesToColAndContents.put(Autobox.valueOf((int)beginLine), lineContents);
        }
        return lineContents;
    }

    int getLastLineKey() {
        return this.linesToColAndContents.lastKey();
    }

    PrettyPrinterDocLineEntry getLastLine(boolean considerOnlyCommentOrEmptyLines) {
        Integer line = this.linesToColAndContents.lastKey();
        PrettyPrinterDocLineEntry last = null;
        if (line != null) {
            while (line >= this.linesToColAndContents.firstKey()) {
                List<ILinePart> sortedParts;
                PrettyPrinterDocLineEntry found = (PrettyPrinterDocLineEntry)this.linesToColAndContents.get(line);
                if (found != null && (sortedParts = (last = found).getSortedParts()).size() != 0) {
                    for (ILinePart iLinePart : sortedParts) {
                        if (iLinePart.getToken() instanceof commentType) continue;
                        return last;
                    }
                }
                line = Autobox.valueOf((int)(line - 1));
            }
        }
        return last;
    }

    public ILinePart getLastPart() {
        PrettyPrinterDocLineEntry lastLine = this.getLastLine(true);
        List<ILinePart> sortedParts = lastLine.getSortedParts();
        return sortedParts.get(sortedParts.size() - 1);
    }

    public void addIndent(SimpleNode node) {
        PrettyPrinterDocLineEntry line = this.getLine(node.beginLine);
        line.indent(node);
    }

    public LinePartIndentMark addIndent(SimpleNode node, boolean requireNewLine) {
        PrettyPrinterDocLineEntry line = this.getLine(node.beginLine);
        return line.indent(node, requireNewLine);
    }

    public LinePartIndentMark addDedent() {
        return this.addDedent(0);
    }

    public LinePartIndentMark addDedent(int emptyLinesRequiredAfterDedent) {
        PrettyPrinterDocLineEntry lastLine = this.getLastLine(false);
        return lastLine.dedent(emptyLinesRequiredAfterDedent);
    }

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer();
        buf.append("PrettyPrinterDocV2[\n");
        Set<Map.Entry<Integer, PrettyPrinterDocLineEntry>> entrySet = this.linesToColAndContents.entrySet();
        for (Map.Entry<Integer, PrettyPrinterDocLineEntry> entry : entrySet) {
            buf.append(new StringBuffer().append(entry.getKey()).append(": ").append(entry.getValue()).append("\n").toString());
        }
        return new StringBuffer("PrettyPrinterDocV2[").append(buf).append("]").toString();
    }

    public int pushRecordChanges() {
        ++this.lastRecordedChangesId;
        this.recordedChanges.put(Autobox.valueOf((int)this.lastRecordedChangesId), new ArrayList());
        return this.lastRecordedChangesId;
    }

    public List<ILinePart> popRecordChanges(int id) {
        List<ILinePart> ret = this.recordedChanges.remove(Autobox.valueOf((int)id));
        return ret;
    }

    public int replaceRecorded(List<ILinePart> recordChanges, String ... replacements) {
        int replaced = 0;
        Assert.isTrue((replacements.length % 2 == 0 ? 1 : 0) != 0);
        for (ILinePart linePart : recordChanges) {
            if (!(linePart instanceof ILinePart2)) continue;
            ILinePart2 iLinePart2 = (ILinePart2)linePart;
            int i = 0;
            while (i < replacements.length) {
                String toReplace = replacements[i];
                String newToken = replacements[i + 1];
                if (iLinePart2.getString().equals(toReplace)) {
                    iLinePart2.setString(newToken);
                    ++replaced;
                }
                i += 2;
            }
        }
        return replaced;
    }

    public Tuple<ILinePart, ILinePart> getLowerAndHigerFound(List<ILinePart> recordChanges) {
        return this.getLowerAndHigerFound(recordChanges, true);
    }

    public Tuple<ILinePart, ILinePart> getLowerAndHigerFound(List<ILinePart> recordChanges, boolean acceptToken) {
        Tuple lowerAndHigher = null;
        ILinePart foundWithLowerLocation = null;
        ILinePart foundWithHigherLocation = null;
        for (ILinePart p : recordChanges) {
            if (p.getToken() instanceof commentType || !acceptToken && p.getToken() instanceof ISpecialStr) continue;
            if (foundWithHigherLocation == null) {
                foundWithHigherLocation = p;
            } else if (p.getLine() > foundWithHigherLocation.getLine()) {
                foundWithHigherLocation = p;
            } else if (p.getLine() == foundWithHigherLocation.getLine() && p.getBeginCol() > foundWithHigherLocation.getBeginCol()) {
                foundWithHigherLocation = p;
            }
            if (foundWithLowerLocation == null) {
                foundWithLowerLocation = p;
                continue;
            }
            if (p.getLine() < foundWithLowerLocation.getLine()) {
                foundWithLowerLocation = p;
                continue;
            }
            if (p.getLine() != foundWithLowerLocation.getLine() || p.getBeginCol() >= foundWithLowerLocation.getBeginCol()) continue;
            foundWithLowerLocation = p;
        }
        if (foundWithLowerLocation != null && foundWithHigherLocation != null) {
            lowerAndHigher = new Tuple(foundWithLowerLocation, foundWithHigherLocation);
        }
        return lowerAndHigher;
    }

    public void validateRequireMarks() {
        if (this.linesToColAndContents.size() == 0) {
            return;
        }
        Tuple search = null;
        int line = this.linesToColAndContents.firstKey();
        while (line <= this.linesToColAndContents.lastKey()) {
            PrettyPrinterDocLineEntry prettyPrinterDocLineEntry = (PrettyPrinterDocLineEntry)this.linesToColAndContents.get(Autobox.valueOf((int)line));
            if (prettyPrinterDocLineEntry != null) {
                List<ILinePart> parts = prettyPrinterDocLineEntry.getSortedParts();
                int position = 0;
                while (position < parts.size()) {
                    ILinePart iLinePart = parts.get(position);
                    if (iLinePart instanceof LinePartRequireMark) {
                        LinePartRequireMark linePartRequireMark = (LinePartRequireMark)iLinePart;
                        Tuple lastSearch = search;
                        search = this.search(line, position, linePartRequireMark, false, lastSearch);
                        boolean found = (Boolean)search.o2;
                        if (!found) {
                            search = this.search(line, position, linePartRequireMark, true, lastSearch);
                            found = (Boolean)search.o2;
                        }
                        ILinePart next = (ILinePart)search.o1;
                        if (!found) {
                            int i;
                            if (iLinePart instanceof LinePartRequireIndentMark) {
                                throw new RuntimeException("Unable to find place to add indent");
                            }
                            ILinePart removed = parts.remove(position);
                            LinePartRequireAdded linePartRequireAdded = new LinePartRequireAdded(removed.getBeginCol(), linePartRequireMark.getToken(), linePartRequireMark.getToken(), prettyPrinterDocLineEntry);
                            int addAt = position;
                            if (lastSearch != null && (i = parts.indexOf(lastSearch.o1)) > -1 && position == i - 1) {
                                addAt = i + 1;
                            }
                            parts.add(addAt, linePartRequireAdded);
                            search = new Tuple((Object)linePartRequireAdded, (Object)Autobox.valueOf((boolean)true));
                        } else {
                            if (iLinePart instanceof LinePartRequireIndentMark) {
                                PrettyPrinterDocLineEntry l = this.getLine(next.getLine());
                                l.indentAfter(next, true);
                            } else {
                                ((ILinePart)search.o1).setMarkAsFound();
                            }
                            int i = parts.indexOf(iLinePart);
                            parts.remove(i);
                            --position;
                        }
                    }
                    ++position;
                }
            }
            ++line;
        }
    }

    private Tuple<ILinePart, Boolean> search(int line, int position, LinePartRequireMark linePartRequireMark, boolean forward, Tuple<ILinePart, Boolean> lastSearch) {
        boolean found = false;
        ILinePart next = null;
        LinePartsIterator it = this.getLinePartsIterator(line, position, forward, lastSearch);
        boolean searchForIndentMark = linePartRequireMark instanceof LinePartRequireIndentMark;
        block0: while (it.hasNext() && !found) {
            next = it.next();
            if (!(next instanceof ILinePart2)) continue;
            if (!searchForIndentMark && next instanceof LinePartRequireAdded) break;
            if (!searchForIndentMark && next.isMarkedAsFound()) continue;
            ILinePart2 part2 = (ILinePart2)next;
            if (linePartRequireMark.requireOneOf != null) {
                String[] stringArray = linePartRequireMark.requireOneOf;
                int n = linePartRequireMark.requireOneOf.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (part2.getString().equals(s)) {
                        found = true;
                        break block0;
                    }
                    ++n2;
                }
            } else if (part2.getString().equals(linePartRequireMark.getToken())) {
                found = true;
                break;
            }
            Object token = next.getToken();
            if (token instanceof SimpleNode && !(token instanceof commentType)) break;
        }
        return new Tuple((Object)next, (Object)Autobox.valueOf((boolean)found));
    }

    public LinePartsIterator getLinePartsIterator(int initialLine, int initialPos, boolean forward, Tuple<ILinePart, Boolean> lastSearch) {
        return new LinePartsIterator(this, initialLine, initialPos, forward, lastSearch);
    }

    public LinePartIndentMark getLastDedent() {
        int line = this.getLastLineKey();
        while (line >= this.linesToColAndContents.firstKey()) {
            PrettyPrinterDocLineEntry prettyPrinterDocLineEntry = (PrettyPrinterDocLineEntry)this.linesToColAndContents.get(Autobox.valueOf((int)line));
            if (prettyPrinterDocLineEntry != null) {
                List<ILinePart> sortedParts = prettyPrinterDocLineEntry.getSortedParts();
                int i = sortedParts.size() - 1;
                while (i >= 0) {
                    LinePartIndentMark linePartIndentMark;
                    ILinePart iLinePart = sortedParts.get(i);
                    if (iLinePart instanceof LinePartIndentMark && !(linePartIndentMark = (LinePartIndentMark)iLinePart).isIndent()) {
                        return linePartIndentMark;
                    }
                    --i;
                }
            }
            --line;
        }
        return null;
    }
}

